/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.engine;

import com.fasterxml.jackson.databind.JavaType;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.service.script.command.CommandExecutionException;
import org.thingsboard.trendz.exception.service.script.engine.PythonException;
import org.thingsboard.trendz.exception.service.script.engine.ScriptEngineException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.script.engine.ScriptExecutionResult;
import org.thingsboard.trendz.service.script.engine.provider.EngineProvider;
import org.thingsboard.trendz.service.script.engine.provider.EngineProviderType;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class PythonScriptEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PythonScriptEngine.class);
    private final EngineProviderType engineProviderType;
    private final Map<EngineProviderType, EngineProvider> engineProviderMap;
    private final ExecutorManagementService executorManagementService;

    @Autowired
    public PythonScriptEngine(@Value(value="${script-engine.provider}") EngineProviderType engineProviderType, Map<String, EngineProvider> engineProviderBeanMap, ExecutorManagementService executorManagementService) {
        this.engineProviderType = engineProviderType;
        this.engineProviderMap = new EnumMap(EngineProviderType.class);
        for (EngineProvider engineProvider : engineProviderBeanMap.values()) {
            this.engineProviderMap.put(engineProvider.getType(), engineProvider);
        }
        this.executorManagementService = executorManagementService;
    }

    public Mono<ScriptExecutionResult> runScript(JwtSecurityUser user, String script, JavaType returnType, Map<String, Object> input) {
        return this.runScript(user, script, returnType, input, null);
    }

    public Mono<ScriptExecutionResult> runScript(JwtSecurityUser user, String script, JavaType returnType, Map<String, Object> input, UUID runExecutionId) {
        ExecutorService executor = this.executorManagementService.getExecutorByName(ExecutorName.SCRIPT_ENGINE);
        return Mono.just((Object)new Object()).publishOn(Schedulers.fromExecutorService((ExecutorService)executor)).flatMap(o -> this.run(user, script, returnType, input, runExecutionId)).publishOn(Schedulers.fromExecutorService((ExecutorService)this.executorManagementService.getExecutorByName(ExecutorName.UI_POST_BUILD)));
    }

    private Mono<ScriptExecutionResult> run(JwtSecurityUser user, String script, JavaType returnType, Map<String, Object> input, UUID scriptRunId) {
        UUID scriptExecutionId = UUID.randomUUID();
        String formattedScript = "_script_execution_id = \"%s\"\n\n%s\n\n".formatted(scriptExecutionId, script);
        return Mono.just((Object)new Object()).doOnNext(o -> log.debug("Python script execution is started, id = {}", (Object)scriptExecutionId)).flatMap(o -> {
            EngineProvider engineProvider = (EngineProvider)this.engineProviderMap.get(this.engineProviderType);
            return engineProvider.run(user, scriptExecutionId, formattedScript, returnType, input, scriptRunId);
        }).doOnSuccess(result -> log.debug("Python script execution is finished, id = {}", (Object)scriptExecutionId)).doOnError(e -> {
            if (e instanceof CommandExecutionException && e.getCause() instanceof InterruptedException) {
                log.warn("Python script execution is interrupted, id = {}", (Object)scriptExecutionId);
            } else if (e instanceof PythonException) {
                log.info("Python script execution is finished successfully with script error, id = {}, message = {}", (Object)scriptExecutionId, (Object)e.getMessage());
            } else {
                log.error("Python script execution is failed, id = {}", (Object)scriptExecutionId, e);
            }
        }).onErrorMap(e -> new ScriptEngineException("Python script execution was failed unexpectedly: " + e.getMessage(), e));
    }
}

