/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;

@Service
public class MyCustomLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MyCustomLogger.class);
    private static final int maxLogSizePerField = 1000;
    private final Cache loggerCache;

    @Autowired
    public MyCustomLogger(CacheManager cacheManager) {
        this.loggerCache = cacheManager.getCache(CacheConfigurationName.scriptLoggerCacheName.getValue());
    }

    public List<String> getLog(UUID executionId) {
        return (List)this.loggerCache.get((Object)executionId, ArrayList::new);
    }

    public void putLog(UUID executionId, String ... message) {
        if (Objects.isNull(executionId)) {
            return;
        }
        List log = this.getLog(executionId);
        long maxCount = 1000 - log.size();
        if (maxCount <= 0L) {
            return;
        }
        List<String> newMessages = Arrays.stream(message).limit(maxCount).toList();
        log.addAll(newMessages);
        this.loggerCache.put((Object)executionId, (Object)log);
    }

    public void clearLog(UUID executionId) {
        this.loggerCache.evict((Object)executionId);
    }
}

