/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.command;

import java.util.List;
import lombok.Generated;
import org.thingsboard.trendz.service.script.command.CommandExecutionResult;

public class CommandExecutionResult {
    private boolean started;
    private boolean finished;
    private int exitCode;
    private long duration;
    private List<String> resultOutput;
    private List<String> errorOutput;

    public String toString() {
        String result = this.resultOutput.stream().map(line -> "\t\t" + line).reduce((o1, o2) -> o1 + "\n" + o2).map(i -> "\n" + i).orElse("");
        String error = this.errorOutput.stream().map(line -> "\t\t" + line).reduce((o1, o2) -> o1 + "\n" + o2).map(i -> "\n" + i).orElse("");
        return String.format("CommandExecutionResult(\n\tstarted=%s, \n\tfinished=%s, \n\texitCode=%s, \n\tduration=%s, \n\tresultOutput=%s,  \n\terrorOutput=%s\n)", this.started, this.finished, this.exitCode, this.duration, result, error);
    }

    @Generated
    public static CommandExecutionResultBuilder builder() {
        return new CommandExecutionResultBuilder();
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public boolean isFinished() {
        return this.finished;
    }

    @Generated
    public int getExitCode() {
        return this.exitCode;
    }

    @Generated
    public long getDuration() {
        return this.duration;
    }

    @Generated
    public List<String> getResultOutput() {
        return this.resultOutput;
    }

    @Generated
    public List<String> getErrorOutput() {
        return this.errorOutput;
    }

    @Generated
    public void setStarted(boolean started) {
        this.started = started;
    }

    @Generated
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Generated
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    @Generated
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Generated
    public void setResultOutput(List<String> resultOutput) {
        this.resultOutput = resultOutput;
    }

    @Generated
    public void setErrorOutput(List<String> errorOutput) {
        this.errorOutput = errorOutput;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandExecutionResult)) {
            return false;
        }
        CommandExecutionResult other = (CommandExecutionResult)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isStarted() != other.isStarted()) {
            return false;
        }
        if (this.isFinished() != other.isFinished()) {
            return false;
        }
        if (this.getExitCode() != other.getExitCode()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        List this$resultOutput = this.getResultOutput();
        List other$resultOutput = other.getResultOutput();
        if (this$resultOutput == null ? other$resultOutput != null : !((Object)this$resultOutput).equals(other$resultOutput)) {
            return false;
        }
        List this$errorOutput = this.getErrorOutput();
        List other$errorOutput = other.getErrorOutput();
        return !(this$errorOutput == null ? other$errorOutput != null : !((Object)this$errorOutput).equals(other$errorOutput));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandExecutionResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStarted() ? 79 : 97);
        result = result * 59 + (this.isFinished() ? 79 : 97);
        result = result * 59 + this.getExitCode();
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        List $resultOutput = this.getResultOutput();
        result = result * 59 + ($resultOutput == null ? 43 : ((Object)$resultOutput).hashCode());
        List $errorOutput = this.getErrorOutput();
        result = result * 59 + ($errorOutput == null ? 43 : ((Object)$errorOutput).hashCode());
        return result;
    }

    @Generated
    public CommandExecutionResult() {
    }

    @Generated
    public CommandExecutionResult(boolean started, boolean finished, int exitCode, long duration, List<String> resultOutput, List<String> errorOutput) {
        this.started = started;
        this.finished = finished;
        this.exitCode = exitCode;
        this.duration = duration;
        this.resultOutput = resultOutput;
        this.errorOutput = errorOutput;
    }
}

