/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.calculatedfield;

import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.script.calculatedfield.ScriptCalculationService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class NativeFieldScriptProcessor {
    private final ScriptCalculationService scriptCalculationService;

    @Autowired
    public NativeFieldScriptProcessor(ScriptCalculationService scriptCalculationService) {
        this.scriptCalculationService = scriptCalculationService;
    }

    @Measurable(context="#ctx", type=MeasuredTaskType.NATIVE_CALCULATION_FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType", itemName="#item.name")
    public Flux<FieldValue> processNativeCalculatedField(Item item, BusinessEntityType entityType, ViewField viewField, ViewRequest viewRequest, ViewContext ctx) {
        return Mono.just((Object)new Object()).map(o -> this.scriptCalculationService.processNativeScript(ctx.getUser(), item.getId(), entityType, viewField, viewField.getScriptLanguage(), viewField.getLabel(), viewField.getParsedCondition(), viewRequest.getStartTs(viewField), viewRequest.getEndTs(viewField), viewRequest.getGroupBy(), viewRequest.getZoneId())).map(resultFieldValues -> {
            if (viewField.getAggregationType() == FieldAggregation.COUNT) {
                return resultFieldValues.stream().map(fv -> new FieldValue(item, FieldType.NUMERIC, (Object)1, fv.getTs())).collect(Collectors.toList());
            }
            return resultFieldValues;
        }).doOnNext(resultFieldValues -> resultFieldValues.forEach(f -> f.setItems(Collections.singleton(item)))).flatMapIterable(l -> l).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }
}

