/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.script.calculatedfield;

import java.util.Collections;
import lombok.Generated;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.service.script.calculatedfield.FieldDto;

public class FieldDto {
    private long ts;
    private Object value;

    public FieldDto(FieldDto that) {
        this.ts = that.ts;
        this.value = that.value;
    }

    public static FieldDto fromField(FieldValue fv) {
        FieldDto dto = new FieldDto();
        dto.setTs(fv.getTs());
        dto.setValue(fv.getInnerValue());
        return dto;
    }

    public FieldValue toField() {
        if (this.value == null) {
            return new FieldValue(Collections.emptySet(), FieldType.BLANK, null, this.ts);
        }
        Object object = this.value;
        if (object instanceof Number) {
            Number number = (Number)object;
            return new FieldValue(Collections.emptySet(), FieldType.NUMERIC, (Object)number.doubleValue(), this.ts);
        }
        object = this.value;
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return new FieldValue(Collections.emptySet(), FieldType.BOOLEAN, (Object)bool, this.ts);
        }
        String stringValue = this.value.toString();
        try {
            double numericValue = Double.parseDouble(stringValue);
            return new FieldValue(Collections.emptySet(), FieldType.NUMERIC, (Object)numericValue, this.ts);
        }
        catch (NumberFormatException numberFormatException) {
            if ("true".equalsIgnoreCase(stringValue)) {
                return new FieldValue(Collections.emptySet(), FieldType.BOOLEAN, (Object)true, this.ts);
            }
            if ("false".equalsIgnoreCase(stringValue)) {
                return new FieldValue(Collections.emptySet(), FieldType.BOOLEAN, (Object)false, this.ts);
            }
            return new FieldValue(Collections.emptySet(), FieldType.STRING, (Object)stringValue, this.ts);
        }
    }

    @Generated
    public static FieldDtoBuilder builder() {
        return new FieldDtoBuilder();
    }

    @Generated
    public long getTs() {
        return this.ts;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public void setTs(long ts) {
        this.ts = ts;
    }

    @Generated
    public void setValue(Object value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldDto)) {
            return false;
        }
        FieldDto other = (FieldDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTs() != other.getTs()) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ts = this.getTs();
        result = result * 59 + (int)($ts >>> 32 ^ $ts);
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldDto(ts=" + this.getTs() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Generated
    public FieldDto() {
    }

    @Generated
    public FieldDto(long ts, Object value) {
        this.ts = ts;
        this.value = value;
    }
}

