/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Component
public class WebClientCachier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebClientCachier.class);
    private boolean apiCallCacheEnabled = false;
    @Value(value="${cache.type}")
    private String cacheType;
    private static final String CACHE_TYPE_CAFFEINE = "caffeine";
    private static final String CACHE_TYPE_REDIS = "redis";
    @Autowired
    private TokenExtractor tokenExtractor;
    @Autowired
    private StatsCollector statsCollector;
    @Autowired
    private CacheManager cacheManager;
    private final Scheduler scheduler = Schedulers.newParallel((String)"parallel-scheduler-cachier", (int)32);

    @PostConstruct
    public void init() {
        if (this.cacheManager.getCache(CacheConfigurationName.apiCallsCacheName.getValue()) != null) {
            this.apiCallCacheEnabled = true;
        }
    }

    public Mono<Map<String, List<TsData>>> getOrFetchTelemetry(String key, JwtSecurityUser user, Supplier<Mono<Map<String, List<TsData>>>> fetcher) {
        return fetcher.get();
    }

    public <T> Flux<T> getOrFetch(String reqType, String key, JwtSecurityUser user, Supplier<Flux<T>> fetcher, TypeReference<List<T>> contentType) {
        if (!this.apiCallCacheEnabled) {
            return fetcher.get();
        }
        Cache apiCallCache = this.cacheManager.getCache(CacheConfigurationName.apiCallsCacheName.getValue());
        long startTs = System.currentTimeMillis();
        return Mono.just((Object)new Object()).flatMap(o -> {
            String cacheKey = reqType + "_" + key + "_" + String.valueOf(user);
            List cachedData = null;
            if (this.cacheType.equals(CACHE_TYPE_REDIS)) {
                Object cachedRawData = apiCallCache.get((Object)cacheKey, Object.class);
                if (cachedRawData != null) {
                    cachedData = (List)JsonUtils.getObjectMapper().convertValue(cachedRawData, contentType);
                }
            } else if (this.cacheType.equals(CACHE_TYPE_CAFFEINE)) {
                cachedData = (List)apiCallCache.get((Object)cacheKey, List.class);
            } else {
                throw new IllegalStateException("Cache type is not supported: " + this.cacheType);
            }
            if (cachedData != null) {
                this.statsCollector.tick("restCacheHit", startTs, System.currentTimeMillis(), TickType.OTHER);
                return Mono.just((Object)cachedData);
            }
            return ((Flux)fetcher.get()).subscribeOn(this.scheduler).collectList().map(list -> {
                apiCallCache.put((Object)cacheKey, list);
                return list;
            });
        }).flatMapIterable(o -> o);
    }
}

