/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider.cache;

import com.fasterxml.jackson.databind.JavaType;
import java.time.Duration;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.trendz.domain.InitStatus;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite;
import org.thingsboard.trendz.domain.chat.ChatQuotaQueue;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.runtime.ViewReport;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.UserValidationResult;
import org.thingsboard.trendz.service.definition.TopologyStorage;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheSpecs;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Configuration
@ConditionalOnProperty(prefix="cache", value={"type"}, havingValue="redis")
@ConfigurationProperties(prefix="cache")
@EnableCaching
public class RedisCacheConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedisCacheConfiguration.class);
    private static final String cacheNamePattern = "%s:%s";
    @Value(value="${redis.host}")
    private String host;
    @Value(value="${redis.port}")
    private Integer port;
    @Value(value="${redis.database:0}")
    private Integer database;
    @Value(value="${redis.keyPrefix:trendz}")
    private String cacheKeyPrefix;
    private Map<String, CacheSpecs> specs;
    private final GenericJackson2JsonRedisSerializer jsonRedisSerializer = new GenericJackson2JsonRedisSerializer(JsonUtils.getObjectMapper());
    private final Map<CacheConfigurationName, RedisSerializationContext.SerializationPair<?>> serializerMap = this.getSerializerMap();

    @Bean
    public RedisConnectionFactory redisConnectionFactory() {
        RedisStandaloneConfiguration standaloneConfiguration = new RedisStandaloneConfiguration();
        standaloneConfiguration.setHostName(this.host);
        standaloneConfiguration.setPort(this.port.intValue());
        standaloneConfiguration.setDatabase(this.database.intValue());
        return new JedisConnectionFactory(standaloneConfiguration);
    }

    @Bean
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
        RedisCacheManager.RedisCacheManagerBuilder redisCacheManagerBuilder = RedisCacheManager.builder((RedisConnectionFactory)redisConnectionFactory).cacheDefaults(org.springframework.data.redis.cache.RedisCacheConfiguration.defaultCacheConfig().computePrefixWith(cacheName -> cacheNamePattern.formatted(this.cacheKeyPrefix, cacheName)).entryTtl(Duration.ofMinutes(5L)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.jsonRedisSerializer)));
        for (Map.Entry cacheSpecsEntry : this.specs.entrySet()) {
            String cacheNameString = (String)cacheSpecsEntry.getKey();
            CacheConfigurationName cacheName2 = CacheConfigurationName.getValue((String)cacheNameString);
            RedisSerializationContext.SerializationPair serializationPair = (RedisSerializationContext.SerializationPair)this.serializerMap.get(cacheName2);
            if (serializationPair == null) {
                throw new TrendzInternalException("No cache configuration serialization pair by name = " + cacheNameString);
            }
            CacheSpecs cacheSpec = (CacheSpecs)cacheSpecsEntry.getValue();
            String cacheKey = cacheName2.getValue();
            redisCacheManagerBuilder = redisCacheManagerBuilder.withCacheConfiguration(cacheKey, org.springframework.data.redis.cache.RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(cacheSpec.getTimeToLiveInMinutes().intValue())).serializeValuesWith(serializationPair));
        }
        return redisCacheManagerBuilder.build();
    }

    private Map<CacheConfigurationName, RedisSerializationContext.SerializationPair<?>> getSerializerMap() {
        EnumMap result = new EnumMap(CacheConfigurationName.class);
        result.put(CacheConfigurationName.tbConfigurationFlagCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(String.class)));
        result.put(CacheConfigurationName.jwtTokenCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(String.class)));
        result.put(CacheConfigurationName.jwtTokenValidationCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(UserValidationResult.class)));
        result.put(CacheConfigurationName.userValidationCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(UserValidationResult.class)));
        result.put(CacheConfigurationName.trendzJwtTokenCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(String.class)));
        result.put(CacheConfigurationName.apiCallsCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)this.jsonRedisSerializer));
        result.put(CacheConfigurationName.viewReportsCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(ViewReport.class)));
        result.put(CacheConfigurationName.topologyStorageCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(TopologyStorage.class)));
        result.put(CacheConfigurationName.tenantInitStatusCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(InitStatus.class)));
        result.put(CacheConfigurationName.domainTrackCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Boolean.class)));
        result.put(CacheConfigurationName.domainAllowedWhiteLabelingCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Boolean.class)));
        result.put(CacheConfigurationName.userTrackCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Boolean.class)));
        result.put(CacheConfigurationName.tenantCustomViewSettingsCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(CustomViewSettings.class)));
        result.put(CacheConfigurationName.subcustomerCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer((JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, Customer.class))));
        result.put(CacheConfigurationName.tenantCustomerInfoCache, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer((JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(Map.class, UUID.class, String.class))));
        result.put(CacheConfigurationName.scriptLoggerCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer((JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, String.class))));
        result.put(CacheConfigurationName.metricTenantNameCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(String.class)));
        result.put(CacheConfigurationName.metricCustomerNameCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(String.class)));
        result.put(CacheConfigurationName.userTaskInitializationCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Boolean.class)));
        result.put(CacheConfigurationName.viewAssistanceChatQuotaCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(ChatQuotaQueue.class)));
        result.put(CacheConfigurationName.systemAiPromptsCacheName, RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer((JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, CustomPromptLite.class))));
        return result;
    }

    @Generated
    public RedisCacheConfiguration() {
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Integer getDatabase() {
        return this.database;
    }

    @Generated
    public String getCacheKeyPrefix() {
        return this.cacheKeyPrefix;
    }

    @Generated
    public Map<String, CacheSpecs> getSpecs() {
        return this.specs;
    }

    @Generated
    public GenericJackson2JsonRedisSerializer getJsonRedisSerializer() {
        return this.jsonRedisSerializer;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setDatabase(Integer database) {
        this.database = database;
    }

    @Generated
    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix;
    }

    @Generated
    public void setSpecs(Map<String, CacheSpecs> specs) {
        this.specs = specs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisCacheConfiguration)) {
            return false;
        }
        RedisCacheConfiguration other = (RedisCacheConfiguration)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$database = this.getDatabase();
        Integer other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !((Object)this$database).equals(other$database)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$cacheKeyPrefix = this.getCacheKeyPrefix();
        String other$cacheKeyPrefix = other.getCacheKeyPrefix();
        if (this$cacheKeyPrefix == null ? other$cacheKeyPrefix != null : !this$cacheKeyPrefix.equals(other$cacheKeyPrefix)) {
            return false;
        }
        Map this$specs = this.getSpecs();
        Map other$specs = other.getSpecs();
        if (this$specs == null ? other$specs != null : !((Object)this$specs).equals(other$specs)) {
            return false;
        }
        GenericJackson2JsonRedisSerializer this$jsonRedisSerializer = this.getJsonRedisSerializer();
        GenericJackson2JsonRedisSerializer other$jsonRedisSerializer = other.getJsonRedisSerializer();
        if (this$jsonRedisSerializer == null ? other$jsonRedisSerializer != null : !this$jsonRedisSerializer.equals(other$jsonRedisSerializer)) {
            return false;
        }
        Map this$serializerMap = this.getSerializerMap();
        Map other$serializerMap = other.getSerializerMap();
        return !(this$serializerMap == null ? other$serializerMap != null : !((Object)this$serializerMap).equals(other$serializerMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedisCacheConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : ((Object)$database).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $cacheKeyPrefix = this.getCacheKeyPrefix();
        result = result * 59 + ($cacheKeyPrefix == null ? 43 : $cacheKeyPrefix.hashCode());
        Map $specs = this.getSpecs();
        result = result * 59 + ($specs == null ? 43 : ((Object)$specs).hashCode());
        GenericJackson2JsonRedisSerializer $jsonRedisSerializer = this.getJsonRedisSerializer();
        result = result * 59 + ($jsonRedisSerializer == null ? 43 : $jsonRedisSerializer.hashCode());
        Map $serializerMap = this.getSerializerMap();
        result = result * 59 + ($serializerMap == null ? 43 : ((Object)$serializerMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RedisCacheConfiguration(host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", cacheKeyPrefix=" + this.getCacheKeyPrefix() + ", specs=" + String.valueOf(this.getSpecs()) + ", jsonRedisSerializer=" + String.valueOf(this.getJsonRedisSerializer()) + ", serializerMap=" + String.valueOf(this.getSerializerMap()) + ")";
    }
}

