/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;

public class TbWebRequest<T> {
    private static final HttpHeaders DEFAULT_HEADERS = HttpHeaders.EMPTY;
    private String baseUrl;
    private String uri;
    private Map<String, Object> params;
    private HttpHeaders headers;
    private Object body;
    private RequestPriority priority;
    private ParameterizedTypeReference<T> typeReference;
    private boolean isNotFoundErrorSuppressed;

    public TbWebRequest(String uri, RequestPriority priority, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), DEFAULT_HEADERS, null, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, HttpHeaders headers, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), headers, null, typeReference);
    }

    public TbWebRequest(String baseUrl, String uri, RequestPriority priority, HttpHeaders headers, ParameterizedTypeReference<T> typeReference) {
        this(baseUrl, uri, priority, Collections.emptyMap(), headers, null, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, Map<String, Object> params, HttpHeaders headers, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, params, headers, null, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, Object body, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), DEFAULT_HEADERS, body, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, HttpHeaders headers, Object body, ParameterizedTypeReference<T> typeReference) {
        this(uri, priority, Collections.emptyMap(), headers, body, typeReference);
    }

    public TbWebRequest(String uri, RequestPriority priority, Map<String, Object> params, HttpHeaders headers, Object body, ParameterizedTypeReference<T> typeReference) {
        this(null, uri, priority, params, headers, body, typeReference);
    }

    public TbWebRequest(String baseUrl, String uri, RequestPriority priority, Map<String, Object> params, HttpHeaders headers, Object body, ParameterizedTypeReference<T> typeReference) {
        this.validate(typeReference);
        this.baseUrl = baseUrl;
        this.uri = uri;
        this.params = params;
        this.headers = headers;
        this.body = body;
        this.typeReference = typeReference;
        this.priority = priority == null ? RequestPriority.LOW : priority;
        this.isNotFoundErrorSuppressed = false;
    }

    public TbWebRequest<T> suppressNotFoundError() {
        this.isNotFoundErrorSuppressed = true;
        return this;
    }

    private void validate(ParameterizedTypeReference<T> typeReference) {
        if (typeReference.getType().equals(Void.class)) {
            throw new IllegalArgumentException("Void type is not supported, use Boolean instead for empty http response");
        }
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public Object getBody() {
        return this.body;
    }

    @Generated
    public RequestPriority getPriority() {
        return this.priority;
    }

    @Generated
    public ParameterizedTypeReference<T> getTypeReference() {
        return this.typeReference;
    }

    @Generated
    public boolean isNotFoundErrorSuppressed() {
        return this.isNotFoundErrorSuppressed;
    }

    @Generated
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    @Generated
    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @Generated
    public void setBody(Object body) {
        this.body = body;
    }

    @Generated
    public void setPriority(RequestPriority priority) {
        this.priority = priority;
    }

    @Generated
    public void setTypeReference(ParameterizedTypeReference<T> typeReference) {
        this.typeReference = typeReference;
    }

    @Generated
    public void setNotFoundErrorSuppressed(boolean isNotFoundErrorSuppressed) {
        this.isNotFoundErrorSuppressed = isNotFoundErrorSuppressed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbWebRequest)) {
            return false;
        }
        TbWebRequest other = (TbWebRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isNotFoundErrorSuppressed() != other.isNotFoundErrorSuppressed()) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        Map this$params = this.getParams();
        Map other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        RequestPriority this$priority = this.getPriority();
        RequestPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        ParameterizedTypeReference this$typeReference = this.getTypeReference();
        ParameterizedTypeReference other$typeReference = other.getTypeReference();
        return !(this$typeReference == null ? other$typeReference != null : !this$typeReference.equals(other$typeReference));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbWebRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotFoundErrorSuppressed() ? 79 : 97);
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        Map $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        RequestPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        ParameterizedTypeReference $typeReference = this.getTypeReference();
        result = result * 59 + ($typeReference == null ? 43 : $typeReference.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbWebRequest(baseUrl=" + this.getBaseUrl() + ", uri=" + this.getUri() + ", params=" + String.valueOf(this.getParams()) + ", headers=" + String.valueOf(this.getHeaders()) + ", body=" + String.valueOf(this.getBody()) + ", priority=" + String.valueOf(this.getPriority()) + ", typeReference=" + String.valueOf(this.getTypeReference()) + ", isNotFoundErrorSuppressed=" + this.isNotFoundErrorSuppressed() + ")";
    }
}

