/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.ConsumptionProbe;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.SingletonDnsServerAddressStreamProvider;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeFunctions;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientRequestException;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.domain.tb.provider.RequestTask;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.service.executor.ExecutorManagementService;
import org.thingsboard.trendz.service.executor.ExecutorName;
import org.thingsboard.trendz.service.metrics.RateLimitsMetricService;
import org.thingsboard.trendz.service.provider.CloudRateLimitService;
import org.thingsboard.trendz.service.provider.TbWebClientProperties;
import org.thingsboard.trendz.service.provider.TbWebRequest;
import org.thingsboard.trendz.service.provider.TbWebRequestExecutionInfo;
import org.thingsboard.trendz.service.provider.TbWebResponse;
import org.thingsboard.trendz.service.startup.TrendzStartupService;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.stats.TickType;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;
import org.thingsboard.trendz.tools.SSLUtils;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.PooledConnectionProvider;
import reactor.util.retry.Retry;

@Service
public class TbWebClient
implements TrendzStartupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbWebClient.class);
    private final TbConfigurationStorage tbConfigurationStorage;
    private final RateLimitsMetricService metricService;
    private final CloudRateLimitService cloudRateLimitService;
    private final StatsCollector statsCollector;
    private final Bucket requestCountingBucket;
    private final Scheduler scheduler;
    private final TbWebClientProperties properties;
    private final ExchangeFunction exchangeFunction;
    private final WebClient webClient;
    private final PriorityBlockingQueue<RequestTask<?>> queue = new PriorityBlockingQueue();
    private final int retryMaxAttempts;
    private final int retryTimeout;
    private final AtomicReference<ConnectionProvider> connectionProvider = new AtomicReference();
    private final AtomicLong requestsTotal = new AtomicLong();
    private final AtomicLong requestsPending = new AtomicLong();
    private final AtomicLong requestsWaiting = new AtomicLong();
    private final AtomicLong connectionsTotal = new AtomicLong();
    private final AtomicLong connectionsActive = new AtomicLong();
    private final AtomicLong connectionsIdle = new AtomicLong();

    @Autowired
    public TbWebClient(@Value(value="${tb.api.custom-dns.enabled}") boolean customDnsEnabled, @Value(value="${tb.api.custom-dns.dns-address}") String customDnsAddress, @Value(value="${tb.api.retry.maxAttempts}") int retryMaxAttempts, @Value(value="${tb.api.retry.timeout}") int retryTimeout, TbWebClientProperties properties, TbConfigurationStorage tbConfigurationStorage, ExecutorManagementService executorManagementService, RateLimitsMetricService metricService, CloudRateLimitService cloudRateLimitService, StatsCollector statsCollector, Bucket requestCountingBucket) throws Exception {
        this.tbConfigurationStorage = tbConfigurationStorage;
        this.metricService = metricService;
        this.cloudRateLimitService = cloudRateLimitService;
        this.statsCollector = statsCollector;
        this.requestCountingBucket = requestCountingBucket;
        this.scheduler = Schedulers.fromExecutor((Executor)executorManagementService.getExecutorByName(ExecutorName.WEB_CLIENT));
        this.properties = properties;
        this.retryMaxAttempts = retryMaxAttempts;
        this.retryTimeout = retryTimeout;
        this.metricService.initializeRequestsTotal(this.requestsTotal);
        this.metricService.initializeRequestsPending(this.requestsPending);
        this.metricService.initializeRequestsWaiting(this.requestsWaiting);
        this.metricService.initializeConnectionsMax(properties.getConnection().getCount());
        this.metricService.initializeConnectionsTotal(this.connectionsTotal);
        this.metricService.initializeConnectionsActive(this.connectionsActive);
        this.metricService.initializeConnectionsIdle(this.connectionsIdle);
        TbWebClientProperties.Timeout timeoutProperties = properties.getTimeout();
        SSLUtils.turnOffSslChecking();
        ConnectionProvider provider = ((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder((String)"trendz-web-client-pool").maxConnections(properties.getConnection().getCount())).pendingAcquireMaxCount(-1)).pendingAcquireTimeout(Duration.ofMillis(timeoutProperties.getTotal()))).pendingAcquireTimer((runnable, timeout) -> () -> {})).maxIdleTime(Duration.ofMillis(timeoutProperties.getIdle()))).maxLifeTime(Duration.ofMillis(timeoutProperties.getTotal()))).evictInBackground(Duration.ofMillis(properties.getConnection().getCleanupFrequencyMs()))).metrics(true)).build();
        this.connectionProvider.set(provider);
        SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        HttpClient httpClient = (HttpClient)((HttpClient)HttpClient.create((ConnectionProvider)provider).metrics(true, id -> id).secure(t -> t.sslContext(sslContext)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)timeoutProperties.getConnect())).responseTimeout(Duration.ofMillis(timeoutProperties.getResponse())).doOnConnected(connection -> {
            connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)timeoutProperties.getRead(), TimeUnit.MILLISECONDS));
            connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)timeoutProperties.getWrite(), TimeUnit.MILLISECONDS));
        });
        if (customDnsEnabled) {
            DnsNameResolverBuilder dnsNameResolverBuilder = new DnsNameResolverBuilder().channelType(NioDatagramChannel.class).resolvedAddressTypes(ResolvedAddressTypes.IPV4_PREFERRED).queryTimeoutMillis((long)timeoutProperties.getDns()).nameServerProvider((DnsServerAddressStreamProvider)new SingletonDnsServerAddressStreamProvider(new InetSocketAddress(customDnsAddress, 53)));
            DnsAddressResolverGroup resolverGroup = new DnsAddressResolverGroup(dnsNameResolverBuilder);
            httpClient = (HttpClient)httpClient.resolver((AddressResolverGroup)resolverGroup);
            log.info("Custom DNS resolver is used: {} with query timeout: {}ms", (Object)customDnsAddress, (Object)timeoutProperties.getDns());
        } else {
            log.info("Default (system) DNS resolver is used with configured query timeout: {}ms", (Object)timeoutProperties.getDns());
        }
        ReactorClientHttpConnector httpConnector = new ReactorClientHttpConnector(httpClient);
        ExchangeStrategies exchangeStrategies = ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(0x4000000)).build();
        this.exchangeFunction = ExchangeFunctions.create((ClientHttpConnector)httpConnector, (ExchangeStrategies)exchangeStrategies);
        DefaultUriBuilderFactory defaultUriBuilderFactory = new DefaultUriBuilderFactory();
        defaultUriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        this.webClient = WebClient.builder().uriBuilderFactory((UriBuilderFactory)defaultUriBuilderFactory).filters(exchangeFilterFunctions -> exchangeFilterFunctions.add(this.logResponse())).clientConnector((ClientHttpConnector)httpConnector).exchangeFunction(request -> {
            AtomicLong startTs = new AtomicLong();
            return Mono.just((Object)new Object()).doOnNext(o -> startTs.set(System.currentTimeMillis())).flatMap(o -> this.exchangeFunction.exchange(request)).doOnNext(o -> this.statsCollector.tick("generalRestClient", startTs.get(), System.currentTimeMillis(), TickType.OTHER));
        }).defaultHeader(properties.getCustomHeader().getKey(), new String[]{properties.getCustomHeader().getValue()}).build();
        if (properties.getLogging().isEnabled()) {
            ScheduledExecutorService logExecutor = (ScheduledExecutorService)executorManagementService.getExecutorByName(ExecutorName.RATE_LIMIT_LOGGING);
            logExecutor.scheduleWithFixedDelay(() -> this.loggingRoutine(), 0L, properties.getLogging().getFrequencyMs(), TimeUnit.MILLISECONDS);
        }
    }

    public void onStartup(ApplicationContext context) {
        int maxConnectionCount = this.properties.getConnection().getCount();
        Scheduler myDispatcherScheduler = Schedulers.newBoundedElastic((int)maxConnectionCount, (int)maxConnectionCount, (String)"dispatcher-thread");
        IntStream.range(0, maxConnectionCount).forEach(i -> this.processNext(myDispatcherScheduler));
    }

    public int priority() {
        return 2;
    }

    private void processNext(Scheduler scheduler) {
        Mono.fromCallable(this.queue::take).subscribeOn(scheduler).flatMap(task -> this.executeTask(task)).doFinally(st -> this.processNext(scheduler)).subscribe();
    }

    private <T> Mono<Void> executeTask(RequestTask<T> task) {
        return task.getWork().doOnNext(value -> task.getFuture().completeAsync(() -> value)).onErrorResume(error -> {
            CompletableFuture.runAsync(() -> task.getFuture().completeExceptionally((Throwable)error));
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            if (!task.getFuture().isDone()) {
                CompletableFuture.runAsync(() -> task.getFuture().complete(null));
            }
            return Mono.empty();
        })).then();
    }

    public <T> Mono<TbWebResponse<T>> get(TbWebRequest<T> request) {
        String uriWithParams = this.createUriWithParams(request);
        WebClient.ResponseSpec responseSpec = this.responseSpecGet(uriWithParams, request.getHeaders());
        return this.queryWrapper(responseSpec, request, "GET");
    }

    public <T> Mono<TbWebResponse<T>> post(TbWebRequest<T> request) {
        String uriWithParams = this.createUriWithParams(request);
        WebClient.ResponseSpec responseSpec = request.getBody() == null ? this.responseSpecPost(uriWithParams, request.getHeaders()) : this.responseSpecPost(uriWithParams, request.getHeaders(), request.getBody());
        return this.queryWrapper(responseSpec, request, "POST");
    }

    public <T> Mono<TbWebResponse<T>> delete(TbWebRequest<T> request) {
        String uriWithParams = this.createUriWithParams(request);
        WebClient.ResponseSpec responseSpec = this.responseSpecDelete(uriWithParams, request.getHeaders());
        return this.queryWrapper(responseSpec, request, "DELETE");
    }

    public <T> Mono<TbWebResponse<T>> method(TbWebRequest<T> request, String method) {
        String uriWithParams = this.createUriWithParams(request);
        WebClient.ResponseSpec responseSpec = this.responseSpec(method, uriWithParams, request.getHeaders(), request.getBody());
        return this.queryWrapper(responseSpec, request, method);
    }

    private String createUriWithParams(TbWebRequest<?> request) {
        String baseUrl = Optional.ofNullable(request.getBaseUrl()).orElse(this.tbConfigurationStorage.getTbConfiguration().getUrl());
        StringBuilder url = new StringBuilder(baseUrl).append(request.getUri()).append("?");
        for (Map.Entry entry : request.getParams().entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                value = StringUtils.join((Iterable)iterable, (String)",");
            }
            String queryParam = URLEncoder.encode(value.toString(), StandardCharsets.UTF_8);
            url.append((String)entry.getKey()).append("=").append(queryParam).append("&");
        }
        url.deleteCharAt(url.length() - 1);
        return url.toString();
    }

    private WebClient.ResponseSpec responseSpecGet(String uriAndParams, HttpHeaders headers) {
        return this.webClient.get().uri(uriAndParams, new Object[0]).headers(s -> s.addAll((MultiValueMap)headers)).retrieve();
    }

    private WebClient.ResponseSpec responseSpecPost(String uriAndParams, HttpHeaders headers) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(uriAndParams, new Object[0])).headers(s -> s.addAll((MultiValueMap)headers))).retrieve();
    }

    private WebClient.ResponseSpec responseSpecPost(String uriAndParams, HttpHeaders headers, Object body) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(uriAndParams, new Object[0])).headers(s -> s.addAll((MultiValueMap)headers))).body(BodyInserters.fromValue((Object)body)).retrieve();
    }

    private WebClient.ResponseSpec responseSpecDelete(String uriAndParams, HttpHeaders headers) {
        return this.webClient.delete().uri(uriAndParams, new Object[0]).headers(s -> s.addAll((MultiValueMap)headers)).retrieve();
    }

    private WebClient.ResponseSpec responseSpec(String method, String uriAndParams, HttpHeaders headers, Object body) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)method)).uri(uriAndParams, new Object[0])).headers(s -> s.addAll((MultiValueMap)headers))).bodyValue(body).retrieve();
    }

    private Mono<Long> waitForBothBuckets(TbWebRequest<?> request) {
        this.requestsWaiting.incrementAndGet();
        log.trace("Rate limit probe: start");
        long start = System.currentTimeMillis();
        return this.tryAcquire(request, start).doOnNext(waitTime -> {
            this.requestsWaiting.decrementAndGet();
            this.metricService.recordRateLimitWaitDuration(waitTime.longValue());
            log.trace("Rate limit probe: finish");
        });
    }

    private Mono<Long> tryAcquire(TbWebRequest<?> request, long start) {
        ConsumptionProbe p2;
        log.trace("Rate limit probe: checking");
        boolean isTelemetry = this.cloudRateLimitService.shouldTelemetryCountRateLimitsBeApplied(request.getUri());
        ConsumptionProbe p1 = this.requestCountingBucket.tryConsumeAndReturnRemaining(1L);
        ConsumptionProbe consumptionProbe = p2 = isTelemetry ? this.cloudRateLimitService.consume(request.getBody()) : ConsumptionProbe.consumed((long)-1L);
        if (p1.isConsumed() && p2.isConsumed()) {
            log.trace("Rate limit probe: yes");
            return Mono.just((Object)(System.currentTimeMillis() - start));
        }
        long nanos = Math.max(p1.getNanosToWaitForRefill(), p2.getNanosToWaitForRefill());
        log.debug("Rate limit probe: wait {}ms", (Object)(nanos / 1000L));
        return Mono.delay((Duration)Duration.ofNanos(nanos)).then(Mono.defer(() -> this.tryAcquire(request, start)));
    }

    private <T> Mono<TbWebResponse<T>> queryWrapper(WebClient.ResponseSpec responseSpec, TbWebRequest<T> request, String method) {
        log.trace("Request: start");
        AtomicLong schedulingTs = new AtomicLong(System.currentTimeMillis());
        AtomicLong startTs = new AtomicLong(-1L);
        AtomicLong endTs = new AtomicLong(-1L);
        AtomicLong rateLimitDelay = new AtomicLong(-1L);
        this.logRequest(request, method);
        RequestPriority priority = request.getPriority() == null ? RequestPriority.LOW : request.getPriority();
        Mono guardedCall = Mono.defer(() -> Mono.just((Object)true)).doOnNext(o -> startTs.set(System.currentTimeMillis())).flatMap(o -> this.waitForBothBuckets(request)).doOnNext(rateLimitDelay::set).then(this.rawCall(responseSpec, request)).timeout(Duration.ofMillis(this.properties.getTimeout().getTotal()));
        RequestTask task = new RequestTask(guardedCall, priority);
        Mono retried = Mono.defer(() -> {
            this.queue.add(task);
            return Mono.fromFuture((CompletableFuture)task.getFuture());
        }).retryWhen((Retry)Retry.fixedDelay((long)this.retryMaxAttempts, (Duration)Duration.ofSeconds(this.retryTimeout)).filter(throwable -> {
            WebClientResponseException ex;
            HttpStatusCode code;
            if (throwable instanceof WebClientResponseException && ((code = (ex = (WebClientResponseException)throwable).getStatusCode()).is5xxServerError() || code.value() == 429)) {
                log.warn("Retrying request to TB api ({}): {}", (Object)code.value(), (Object)request.getUri());
                return true;
            }
            if (throwable instanceof WebClientRequestException && (ex = (WebClientRequestException)throwable).getCause() instanceof SocketException) {
                log.warn("Retrying request to TB api (SocketException): {}", (Object)request.getUri());
                return true;
            }
            return false;
        })).publishOn(this.scheduler);
        log.trace("Run request mono build.");
        return Mono.just((Object)true).flatMap(o -> retried).switchIfEmpty(this.processEmptyResponse(request.getTypeReference())).map(Optional::of).onErrorResume(error -> this.suppressNotFoundError(error, request)).map(response -> {
            endTs.set(System.currentTimeMillis());
            return new TbWebResponse(response, new TbWebRequestExecutionInfo(schedulingTs.get(), startTs.get(), endTs.get(), rateLimitDelay.get()));
        }).doOnNext(resp -> {
            if (this.properties.getLogging().isEnabled() && this.properties.getLogging().isVerbose()) {
                log.info("Response body: {}", (Object)resp.getResponse().map(JsonUtils::toJson).orElse(""));
            }
            log.trace("Request: finished");
            this.requestsTotal.incrementAndGet();
        }).onErrorMap(error -> {
            long finishTs = System.currentTimeMillis();
            TbWebRequestExecutionInfo ei = new TbWebRequestExecutionInfo(schedulingTs.get(), startTs.get(), finishTs, rateLimitDelay.get());
            Object msg = error.getMessage();
            if (error instanceof WebClientResponseException) {
                WebClientResponseException ex = (WebClientResponseException)error;
                msg = (String)msg + ex.getResponseBodyAsString();
            }
            return new TbWebClientException(error, (String)msg, request, ei);
        });
    }

    private <T> Mono<T> rawCall(WebClient.ResponseSpec responseSpec, TbWebRequest<T> request) {
        responseSpec = responseSpec.onStatus(status -> status.is5xxServerError() || status.is4xxClientError(), clientResponse -> clientResponse.createException().flatMap(Mono::error));
        if (request.getTypeReference().getType().equals(Boolean.class)) {
            return responseSpec.toBodilessEntity().hasElement();
        }
        return responseSpec.bodyToMono(request.getTypeReference());
    }

    private <T> Mono<T> processEmptyResponse(ParameterizedTypeReference<T> typeReference) {
        return Mono.defer(() -> {
            if (typeReference.getType().equals(Boolean.class)) {
                return Mono.just((Object)Boolean.TRUE);
            }
            if (typeReference.getType().equals(Void.class)) {
                return Mono.error((Throwable)new IllegalArgumentException("Void type is not allowed for processing empty http responses, use Boolean type instead."));
            }
            return Mono.error((Throwable)new IllegalArgumentException("The http response is empty, therefore you must use Boolean type instead provided: " + typeReference.getType().getTypeName()));
        });
    }

    private <T> Mono<Optional<T>> suppressNotFoundError(Throwable error, TbWebRequest<T> request) {
        if (request.isNotFoundErrorSuppressed() && error instanceof WebClientResponseException.NotFound) {
            return Mono.just(Optional.empty());
        }
        return Mono.error((Throwable)error);
    }

    private void logRequest(TbWebRequest<?> request, String method) {
        if (!this.properties.getLogging().isEnabled() || !this.properties.getLogging().isVerbose()) {
            return;
        }
        String fullUri = this.createUriWithParams(request);
        StringBuilder logBuilder = new StringBuilder().append("\n").append("Request:\n").append("\t").append(method).append(" ").append(fullUri).append("\n").append("Headers:\n");
        request.getHeaders().forEach((name, values) -> {
            String value = values.stream().reduce((o1, o2) -> o1 + ", " + o2).orElse("");
            logBuilder.append("\t").append((String)name).append(" = ").append(value).append("\n");
        });
        if (!request.getParams().isEmpty()) {
            logBuilder.append("Query params:\n");
            request.getParams().forEach((k, v) -> {
                Object val = v;
                if (val instanceof Iterable) {
                    val = StringUtils.join((Iterable)((Iterable)val), (String)",");
                }
                logBuilder.append("\t").append((String)k).append(" = ").append(val).append("\n");
            });
        }
        logBuilder.append("Body:\n").append("\t").append(JsonUtils.toJson((Object)request.getBody())).append("\n");
        log.info("Request:\n{}", (Object)logBuilder);
    }

    private ExchangeFilterFunction logResponse() {
        return ExchangeFilterFunction.ofResponseProcessor(clientResponse -> {
            if (!this.properties.getLogging().isEnabled() || !this.properties.getLogging().isVerbose()) {
                return Mono.just((Object)clientResponse);
            }
            return clientResponse.bodyToMono(String.class).defaultIfEmpty((Object)"").flatMap(body -> {
                StringBuilder logBuilder = new StringBuilder().append("\n").append("Response: ").append(clientResponse.statusCode()).append("\n").append("Headers: ").append("\n");
                clientResponse.headers().asHttpHeaders().forEach((name, values) -> {
                    String value = values.stream().reduce((o1, o2) -> o1 + ", " + o2).orElse("");
                    logBuilder.append("\t").append((String)name).append(" = ").append(value).append("\n");
                });
                logBuilder.append("Body: ").append((String)body).append("\n");
                log.info(logBuilder.toString());
                ClientResponse mutatedResponse = clientResponse.mutate().body(body).build();
                return Mono.just((Object)mutatedResponse);
            });
        });
    }

    private void loggingRoutine() {
        try {
            ConnectionProvider provider = (ConnectionProvider)this.connectionProvider.get();
            if (provider == null) {
                log.info("Metrics not yet initialized");
                return;
            }
            PooledConnectionProvider pooledProvider = (PooledConnectionProvider)provider;
            Field poolsField = PooledConnectionProvider.class.getDeclaredField("channelPools");
            poolsField.setAccessible(true);
            ConcurrentMap channelPools = (ConcurrentMap)poolsField.get(pooledProvider);
            long total = 0L;
            long active = 0L;
            long idle = 0L;
            long pending = 0L;
            for (InstrumentedPool pool : channelPools.values()) {
                InstrumentedPool.PoolMetrics m = pool.metrics();
                active += (long)m.acquiredSize();
                idle += (long)m.idleSize();
                pending += (long)m.pendingAcquireSize();
                total += (long)(m.acquiredSize() + m.idleSize());
            }
            this.connectionsTotal.set(total);
            this.connectionsActive.set(active);
            this.connectionsIdle.set(idle);
            this.requestsPending.set(pending);
            log.info("Requests: sent = {}, pending: {}, waiting: {}. Connections: max = {}, total = {}, active = {}, idle = {}", new Object[]{this.requestsTotal.get(), this.requestsPending.get(), this.requestsWaiting.get(), this.properties.getConnection().getCount(), this.connectionsTotal.get(), this.connectionsActive.get(), this.connectionsIdle.get()});
        }
        catch (Exception ex) {
            log.error("Error during web client metric gathering", (Throwable)ex);
        }
    }
}

