/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.runtime.EnhancedCustomer;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TbCustomerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbCustomerService.class);
    private final TbRestDataSource tbClient;

    @Autowired
    public TbCustomerService(TbRestDataSource tbClient) {
        this.tbClient = tbClient;
    }

    public Flux<Item> loadCustomers(BusinessEntity businessEntity, ViewRequest request, ViewContext ctx, JwtSecurityUser user) {
        return this.tbClient.loadCustomers(businessEntity, request, ctx, user).map(customer -> TbCustomerService.mapCustomerToItem((Customer)customer, null));
    }

    public Flux<Item> loadRelatedCustomers(UUID parentId, BusinessEntity parentEntity, ViewRequest request, ViewContext ctx, Relation relation, BusinessEntity relatedBusinessEntity, JwtSecurityUser user) {
        BusinessEntityQuery entityQuery = relatedBusinessEntity.getQuery();
        BusinessEntityQuery query = parentEntity.getQuery();
        AssetId parent = new AssetId(parentId);
        if (query.getEntityType().equals((Object)BusinessEntityType.DEVICE)) {
            parent = new DeviceId(parentId);
        } else if (query.getEntityType().equals((Object)BusinessEntityType.CUSTOMER)) {
            parent = new CustomerId(parentId);
        }
        return this.tbClient.findRelatedCustomers(relatedBusinessEntity, request, ctx, relation, entityQuery.getType(), (EntityId)parent, user).map(customer -> TbCustomerService.mapCustomerToItem((Customer)customer, (UUID)parentId));
    }

    public static Item mapCustomerToItem(Customer customer, UUID parentId) {
        UUID ownerId = customer.getOwnerId() != null ? customer.getOwnerId().getId() : null;
        Item item = Item.builder().id(customer.getUuidId()).parentId(parentId).ownerId(ownerId).name(customer.getName()).label(null).build();
        if (customer instanceof EnhancedCustomer) {
            EnhancedCustomer enhancedCustomer = (EnhancedCustomer)customer;
            item.setAttributes(enhancedCustomer.getAttributes());
            item.setLatestTelemetry(enhancedCustomer.getLatestTelemetries());
        }
        return item;
    }
}

