/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.service.provider.PartitionBuilder;
import org.thingsboard.trendz.service.provider.TelemetryPartitionQuery;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class PartitionBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PartitionBuilder.class);
    private static final Set<FieldAggregation> allowedAggregations = Sets.newHashSet((Object[])new FieldAggregation[]{FieldAggregation.SUM, FieldAggregation.MAX, FieldAggregation.MIN, FieldAggregation.COUNT, FieldAggregation.AVG});
    private static final int maxQueryCount = 500;

    public List<TelemetryPartitionQuery> buildPartitionQueries(long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType timeAggregation, ZoneId requestZoneId, boolean useOneSingleRawPartition) {
        ChronoUnit timeUnit = null;
        if (timeAggregation != null) {
            timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)timeAggregation);
        }
        if (fieldAggregation == FieldAggregation.LATEST || timeUnit == null && !useOneSingleRawPartition) {
            return Lists.newArrayList((Object[])new TelemetryPartitionQuery[]{new TelemetryPartitionQuery(startTs, endTs, endTs - startTs, this.toStrAgg(fieldAggregation))});
        }
        if (useOneSingleRawPartition) {
            return Lists.newArrayList((Object[])new TelemetryPartitionQuery[]{new TelemetryPartitionQuery(startTs, endTs, 0L, "NONE")});
        }
        if (allowedAggregations.contains(fieldAggregation) && !DateAggregationType.isNotLoadableAggregationType((DateAggregationType)timeAggregation)) {
            return this.buildPartitions(startTs, endTs, timeUnit, 500, requestZoneId, fieldAggregation);
        }
        log.warn("Partition builder uses default behavior because of undefined conditions.");
        return Collections.singletonList(new TelemetryPartitionQuery(startTs, endTs, 0L, "NONE"));
    }

    private List<TelemetryPartitionQuery> buildPartitions(long startTs, long endTs, ChronoUnit truncateUnit, int maxIntervalCount, ZoneId requestZoneId, FieldAggregation fieldAggregation) {
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), requestZoneId);
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTs), requestZoneId);
        ZonedDateTime truncatedStart = DateTimeUtils.extendedTruncateTo((ZonedDateTime)startDate, (ChronoUnit)truncateUnit);
        ZonedDateTime truncatedEnd = DateTimeUtils.extendedTruncateTo((ZonedDateTime)endDate, (ChronoUnit)truncateUnit);
        ArrayList ranges = Lists.newArrayList();
        ranges.add(startTs);
        ZonedDateTime currentTruncatedTime = truncatedStart;
        while (!currentTruncatedTime.equals(truncatedEnd)) {
            ZonedDateTime nextTruncatedDate = currentTruncatedTime.plus(1L, truncateUnit);
            long nextTruncatedDateTs = nextTruncatedDate.toInstant().toEpochMilli();
            ranges.add(nextTruncatedDateTs);
            currentTruncatedTime = nextTruncatedDate;
        }
        if (!truncatedEnd.equals(endDate)) {
            ranges.add(endTs);
        }
        ArrayList rawPartitions = Lists.newArrayList();
        Iterator rangeIterator = ranges.iterator();
        Long previousRange = (Long)rangeIterator.next();
        Long previousInterval = -1L;
        TelemetryPartitionQuery lastPartition = null;
        while (rangeIterator.hasNext()) {
            Long currentRange = (Long)rangeIterator.next();
            Long currentInterval = currentRange - previousRange;
            if (currentInterval.equals(previousInterval)) {
                lastPartition.setEndTs(currentRange.longValue());
            } else {
                lastPartition = new TelemetryPartitionQuery(previousRange.longValue(), currentRange.longValue(), currentInterval.longValue(), this.toStrAgg(fieldAggregation));
                rawPartitions.add(lastPartition);
            }
            previousRange = currentRange;
            previousInterval = currentInterval;
        }
        ArrayList partitions = Lists.newArrayList();
        rawPartitions.forEach(rawPartition -> {
            if ((rawPartition.getEndTs() - rawPartition.getStartTs()) / rawPartition.getInterval() > (long)maxIntervalCount) {
                partitions.addAll(this.splitBigIntervals(rawPartition.getStartTs(), rawPartition.getEndTs(), rawPartition.getInterval(), maxIntervalCount, this.toStrAgg(fieldAggregation)));
            } else {
                partitions.add(rawPartition);
            }
        });
        if (log.isTraceEnabled()) {
            partitions.forEach(partition -> log.trace("Partition: {} ", partition));
        }
        return partitions;
    }

    private String toStrAgg(FieldAggregation aggregation) {
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$FieldAggregation[aggregation.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return aggregation.name();
            }
        }
        throw new IllegalArgumentException("Unsupported field aggregation: " + String.valueOf(aggregation));
    }

    private List<TelemetryPartitionQuery> splitBigIntervals(long startTs, long endTs, long step, int maxQueries, String agg) {
        ArrayList partitions = Lists.newArrayList();
        long currStart = startTs;
        while (currStart < endTs) {
            long currEnd;
            int stepsCount = 0;
            for (currEnd = currStart; stepsCount < maxQueries && currEnd < endTs; currEnd += step, ++stepsCount) {
            }
            partitions.add(new TelemetryPartitionQuery(currStart, currEnd, step, agg));
            currStart = currEnd;
        }
        return partitions;
    }
}

