/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.ConsumptionProbe;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CloudRateLimitService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudRateLimitService.class);
    public final boolean cloudRateLimitingEnabled;
    private final Bucket bucket;

    public CloudRateLimitService(@Value(value="${ratelimit.cloud.useCloudRateLimiting}") boolean cloudRateLimitingEnabled, Bucket telemetryPointsPostCountingBucket) {
        log.info("Cloud Rate Limiting status: {}", (Object)(cloudRateLimitingEnabled ? "ENABLED" : "DISABLED"));
        if (cloudRateLimitingEnabled) {
            this.cloudRateLimitingEnabled = true;
            this.bucket = telemetryPointsPostCountingBucket;
        } else {
            this.cloudRateLimitingEnabled = false;
            this.bucket = null;
        }
    }

    public boolean shouldTelemetryCountRateLimitsBeApplied(String uri) {
        return this.cloudRateLimitingEnabled && this.isTelemetryPostApi(uri);
    }

    public ConsumptionProbe consume(Object body) {
        if (body instanceof List) {
            List list = (List)body;
            return this.bucket.tryConsumeAndReturnRemaining((long)list.size());
        }
        throw new IllegalArgumentException("Body of the send telemetry request is not a list - can not measure point count for rate limiting");
    }

    private boolean isTelemetryPostApi(String uri) {
        boolean sendTelemetryViaToken = uri.matches("^/api/v1/[a-zA-Z0-9]{20}/telemetry$");
        boolean sendTelemetryDirectly = uri.matches("^/api/plugins/telemetry/[a-zA-Z0-9_]+/[a-fA-F0-9\\-]{36}/timeseries/ANY$");
        return sendTelemetryViaToken || sendTelemetryDirectly;
    }
}

