/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.provider;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.local.LocalBucketBuilder;
import io.github.bucket4j.local.SynchronizationStrategy;
import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.thingsboard.trendz.service.tb.configuration.TbConfigurationStorage;

@Configuration
class BucketConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BucketConfiguration.class);

    BucketConfiguration() {
    }

    @Bean
    public Bucket requestCountingBucket(TbConfigurationStorage tbConfigurationStorage, @Value(value="${ratelimit.duration.sec}") int rateLimitDurationSec, @Value(value="${ratelimit.max_requests_per_duration}") int maxRequests) {
        LocalBucketBuilder builder = Bucket4j.builder();
        if (tbConfigurationStorage.getTbConfiguration().getUrl().contains("demo.thingsboard.io")) {
            builder.addLimit(Bandwidth.simple((long)4L, (Duration)Duration.ofSeconds(1L)));
            builder.addLimit(Bandwidth.simple((long)45L, (Duration)Duration.ofSeconds(10L)));
            builder.addLimit(Bandwidth.simple((long)95L, (Duration)Duration.ofSeconds(30L)));
        } else {
            builder.addLimit(Bandwidth.simple((long)maxRequests, (Duration)Duration.ofSeconds(rateLimitDurationSec)));
        }
        return builder.build();
    }

    @Bean
    public Bucket telemetryPointsPostCountingBucket(@Value(value="${ratelimit.cloud.seconds}") String secondRateLimit, @Value(value="${ratelimit.cloud.minutes}") String minuteRateLimit, @Value(value="${ratelimit.cloud.hours}") String hourRateLimit, @Value(value="${ratelimit.cloud.useCloudRateLimiting}") boolean cloudRateLimitingEnabled) {
        log.info("Cloud Rate Limiting status: {}", (Object)(cloudRateLimitingEnabled ? "ENABLED" : "DISABLED"));
        if (!cloudRateLimitingEnabled) {
            return ((LocalBucketBuilder)Bucket4j.builder().addLimit(Bandwidth.simple((long)1L, (Duration)Duration.ofNanos(1L)))).build();
        }
        log.info("cloud rate limits enabled with values: [{}] per second, [{}] per minute, [{}] per hour", new Object[]{secondRateLimit, minuteRateLimit, hourRateLimit});
        return ((LocalBucketBuilder)((LocalBucketBuilder)((LocalBucketBuilder)Bucket4j.builder().withSynchronizationStrategy(SynchronizationStrategy.LOCK_FREE).addLimit(Bandwidth.simple((long)Integer.parseInt(secondRateLimit), (Duration)Duration.ofSeconds(1L)))).addLimit(Bandwidth.simple((long)Integer.parseInt(minuteRateLimit), (Duration)Duration.ofMinutes(1L)))).addLimit(Bandwidth.simple((long)Integer.parseInt(hourRateLimit), (Duration)Duration.ofHours(1L)))).build();
    }
}

