/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict.executors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.Point;
import org.thingsboard.trendz.domain.base.TimeSeries;
import org.thingsboard.trendz.domain.definition.view.PredictionType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.predict.PredictionMethodData;
import org.thingsboard.trendz.service.predict.PredictionMethodExecutor;
import org.thingsboard.trendz.service.script.engine.PythonScriptEngine;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service(value="linearRegressionMethodOld")
public class LinearRegressionMethod
implements PredictionMethodExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinearRegressionMethod.class);
    private final PythonScriptEngine pythonScriptEngine;

    @Autowired
    public LinearRegressionMethod(PythonScriptEngine pythonScriptEngine) {
        this.pythonScriptEngine = pythonScriptEngine;
    }

    public PredictionType getPredictiontype() {
        return PredictionType.LINEAR_REGRESSION;
    }

    public Mono<TimeSeries> predict(JwtSecurityUser user, TimeSeries learnSet, long[] predictionTs, PredictionMethodData methodData) {
        return Mono.just((Object)new Object()).flatMap(o -> {
            List inputX = learnSet.getPoints().stream().map(Point::getTs).collect(Collectors.toList());
            List inputY = learnSet.getPoints().stream().map(Point::getValue).collect(Collectors.toList());
            ArrayList outputY = new ArrayList();
            HashMap<String, Object> input = new HashMap<String, Object>();
            input.put("inputX", inputX);
            input.put("inputY", inputY);
            input.put("outputX", predictionTs);
            input.put("outputY", outputY);
            CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, Double.class);
            String script = "import numpy as np\nfrom sklearn.linear_model import LinearRegression\n\nprint(f\"inputX: {inputX}\")\nprint(f\"inputY: {inputY}\")\nprint(f\"outputX: {outputX}\")\n\nx_train = np.array(inputX).reshape((-1, 1))\ny_train = np.array(inputY)\nx_predict = np.array(outputX).reshape((-1, 1))\n\nmodel = LinearRegression()\nmodel.fit(x_train, y_train)\nr_sq = model.score(x_train, y_train)\nprint(f\"intercept: {model.intercept_}\")\nprint(f\"slope: {model.coef_}\")\nprint(f\"coefficient of determination: {r_sq}\")\nprint(f\"intercept: {model.intercept_}\")\nprint(f\"slope: {model.coef_}\")\n\ny_predict = model.predict(x_predict)\noutputY = y_predict.tolist()\nreturn outputY\n";
            return this.pythonScriptEngine.runScript(user, script, (JavaType)type, input).map(executionResult -> {
                List output = (List)executionResult.getResult();
                if (predictionTs.length != output.size()) {
                    throw new RuntimeException("Prediction sets are not corresponding");
                }
                return IntStream.range(0, predictionTs.length).mapToObj(i -> new Point(predictionTs[i], ((Double)output.get(i)).doubleValue())).sorted(Comparator.comparingLong(Point::getTs)).collect(Collectors.collectingAndThen(Collectors.toList(), TimeSeries::new));
            });
        });
    }
}

