/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregationService;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Service
public class PreaggregationService {
    private static final Set<FieldAggregation> COUNT_DEPENDENT_FIELD_AGGREGATIONS = Set.of(FieldAggregation.SUM, FieldAggregation.COUNT);
    private final AggregationService aggregationService;

    @Autowired
    PreaggregationService(AggregationService aggregationService) {
        this.aggregationService = aggregationService;
    }

    public List<FieldValue> preaggregateIfNeeded(List<FieldValue> values, ViewField viewField, ViewRequest viewRequest, ViewContext ctx) {
        if (!viewField.isPredictionPreAggregationDisabled() && !viewField.getAggregationType().equals((Object)FieldAggregation.NONE)) {
            DateAggregationType dateAggregation = Optional.ofNullable(viewRequest.getMinimalDateAggregation()).orElseGet(() -> DateAggregationType.getAggregationTypeForRange((long)viewRequest.getStartTs(null), (long)viewRequest.getEndTs(null)));
            List dateAggregationField = dateAggregation.getCachingDateAggregationFieldList();
            BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
            List aggregated = this.aggregationService.preagregate(values, viewField, viewRequest, viewRequest.getCachingDateAggregationType(), dateAggregationField, entityField, ctx);
            aggregated.sort(Comparator.comparingLong(FieldValue::getTs));
            if (COUNT_DEPENDENT_FIELD_AGGREGATIONS.contains(viewField.getAggregationType()) && !((FieldValue)aggregated.get(0)).getFieldType().equals((Object)FieldType.BLANK)) {
                aggregated = this.removeNotCompleteValues(aggregated, viewRequest.getMinimalDateAggregation(), System.currentTimeMillis());
            }
            return aggregated;
        }
        return values;
    }

    List<FieldValue> removeNotCompleteValues(List<FieldValue> fieldValueList, DateAggregationType dateAggregation, long currentTimeMillis) {
        long dateAggregationMillis = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)dateAggregation).getDuration().toMillis();
        if (fieldValueList.get(fieldValueList.size() - 1).getTs() + dateAggregationMillis > currentTimeMillis) {
            return fieldValueList.subList(0, fieldValueList.size() - 1);
        }
        return fieldValueList;
    }
}

