/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.predict;

import java.lang.invoke.CallSite;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.FieldIdTriple;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.predict.PreaggregationService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;
import org.thingsboard.trendz.service.view.proto.ItemDataLoader;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AdditionalDataLoader {
    private final ItemDataLoader dataLoader;
    private final PreaggregationService preaggregationService;

    @Autowired
    public AdditionalDataLoader(ItemDataLoader dataLoader, PreaggregationService preaggregationService) {
        this.dataLoader = dataLoader;
        this.preaggregationService = preaggregationService;
    }

    public Mono<Map<String, List<FieldValue>>> loadAdditionalData(ViewField viewField, Item item, ViewRequest viewRequest, WindowedStreamStore windowedStreamStore, ViewContext ctx, List<FieldIdTriple> fieldIdList) {
        if (fieldIdList.isEmpty()) {
            return Mono.just(Map.of());
        }
        HashMap<CallSite, ViewField> keyToFieldMap = new HashMap<CallSite, ViewField>();
        for (FieldIdTriple triple : fieldIdList) {
            String key = "input " + triple.getFieldName() + " (multi_prophet)";
            ViewField value = new ViewField();
            value.setLabel(key + "(multivariable prediction)");
            value.setBusinessEntityId(triple.getEntityId());
            value.setEntityFieldId(triple.getFieldId());
            value.setForStateCondition(true);
            value.setAggregationType(FieldAggregation.AVG);
            value.setFillGapSettings(FillGapSettings.builder().enableFillGap(true).timeUnit(viewRequest.getMinimalDateAggregation().mapToUnit()).fillGapStrategy(FillGapStrategy.LINEAR).build());
            keyToFieldMap.put((CallSite)((Object)key), value);
        }
        return this.dataLoader.loadChildrenData(viewField, keyToFieldMap, item, viewRequest, windowedStreamStore, ctx, false).flatMap(values -> Flux.fromIterable(values.entrySet()).map(value -> Pair.of((Object)((String)value.getKey()), this.preaggregationService.preaggregateIfNeeded((List)value.getValue(), viewField, viewRequest, ctx).stream().sorted(Comparator.comparingLong(FieldValue::getTs)).collect(Collectors.toList()))).collectList()).map(list -> list.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }
}

