/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.methods;

import org.springframework.stereotype.Service;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethod;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodParameters;
import org.thingsboard.trendz.service.model.prediction.methods.PredictionMethodType;

@Service
public class ProphetMethod
implements PredictionMethod {
    public PredictionMethodType getType() {
        return PredictionMethodType.PROPHET;
    }

    public String getMethodDefinition(PredictionMethodParameters methodParameters) {
        return "#####################################################\n# Prediction Method: PROPHET\nimport pandas as pd\nfrom prophet import Prophet\nimport numpy as np\nimport pickle\nfrom prophet.serialize import model_to_json, model_from_json\n\nEMPTY_PROPHET_MODELS_MAGIC_BYTES = b'\\123'\n\n\nclass CustomModel(IModel):\n\n    def __init__(self, value_transformer=None, timestamp_transformer=None):\n        # \u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u043b\u0438\u043c\u0438\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 (\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0442\u043e\u0447\u0435\u043a \u0445\u0440\u0430\u043d\u0438\u043c)\n        self.data_storage_limit = 2048\n\n        # \u0425\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0434\u043b\u044f \u0438\u0441\u0442\u043e\u0440\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445\n        # (\u043b\u0438\u0431\u043e \u0441\u0440\u0430\u0437\u0443 \u0434\u0435\u043b\u0430\u0435\u043c \u043f\u0443\u0441\u0442\u0443\u044e DataFrame, \u043a\u0443\u0434\u0430 \u0431\u0443\u0434\u0435\u043c \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0438)\n        self._data_buffer = pd.DataFrame(columns=['ds', 'y'])\n\n        # \u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u043c \u043c\u043e\u0434\u0435\u043b\u044c Prophet\n        self.model = Prophet()\n\n    def init_state(self):\n        # \u0415\u0441\u043b\u0438 \u043d\u0443\u0436\u043d\u043e \u043f\u0435\u0440\u0435\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c\n        self.model = Prophet()\n        self._data_buffer = pd.DataFrame(columns=['ds', 'y'])\n\n    def train(self, data, additionalData=None):\n        # \u041f\u043e\u043b\u043d\u043e\u0435 \u043e\u0431\u0443\u0447\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0435\u043b\u0438 Prophet \u043d\u0430 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445.\n        # data: \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u0440\u0442\u0435\u0436\u0435\u0439 (timestamp, value).\n\n        df = self._make_df(data)\n\n        # \u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c df \u0432\u043e \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0431\u0443\u0444\u0435\u0440 (\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u043c 2048 \u0442\u043e\u0447\u043a\u0430\u043c\u0438 \u00ab\u0441 \u043a\u043e\u043d\u0446\u0430\u00bb).\n        self._update_data_buffer(df)\n\n        self.model.fit(self._data_buffer)\n\n    def partial_fit(self, data, additionalData=None):\n        # \u00ab\u0414\u043e\u043e\u0431\u0443\u0447\u0435\u043d\u0438\u0435\u00bb \u043c\u043e\u0434\u0435\u043b\u0438 Prophet \u043f\u0443\u0442\u0451\u043c:\n        #  1) \u043a\u043e\u043d\u043a\u0430\u0442\u0435\u043d\u0430\u0446\u0438\u0438 \u043d\u043e\u0432\u044b\u0445 \u0442\u043e\u0447\u0435\u043a \u0441 \u0431\u0443\u0444\u0435\u0440\u043e\u043c,\n        #  2) \u043e\u0431\u0440\u0435\u0437\u043a\u0438 (\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 2048),\n        #  3) \u043f\u0435\u0440\u0435\u043e\u0431\u0443\u0447\u0435\u043d\u0438\u044f (fit) \u0437\u0430\u043d\u043e\u0432\u043e \u043d\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 2048 \u0442\u043e\u0447\u043a\u0430\u0445.\n\n        new_df = self._make_df(data)\n\n        # \u041e\u0431\u043d\u043e\u0432\u043b\u044f\u0435\u043c \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0431\u0443\u0444\u0435\u0440\n        self._update_data_buffer(new_df)\n\n        # \u0415\u0441\u043b\u0438 \u043c\u043e\u0434\u0435\u043b\u044c \u0431\u044b\u043b\u0430 \u00ab\u043f\u0443\u0441\u0442\u0430\u044f\u00bb, \u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0441\u0442\u043e fit\n        if self.model.history is None or len(self.model.history) == 0:\n            self.model.fit(self._data_buffer)\n        else:\n            # \u0427\u0442\u043e\u0431\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e (seasonality \u0438 \u043f\u0440\u043e\u0447\u0438\u0435), \u043f\u043e\u043b\u0443\u0447\u0438\u043c \u0435\u0451 \u0438\u0437 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u043c\u043e\u0434\u0435\u043b\u0438\n            config = {\n                'growth'                : self.model.growth,\n                'changepoints'          : None,\n                'n_changepoints'        : self.model.n_changepoints,\n                'changepoint_range'     : self.model.changepoint_range,\n                'yearly_seasonality'    : self.model.yearly_seasonality,\n                'weekly_seasonality'    : self.model.weekly_seasonality,\n                'daily_seasonality'     : self.model.daily_seasonality,\n                'holidays'              : self.model.holidays,\n                'seasonality_mode'      : self.model.seasonality_mode,\n                'seasonality_prior_scale': self.model.seasonality_prior_scale,\n                'holidays_prior_scale'  : self.model.holidays_prior_scale,\n                'changepoint_prior_scale': self.model.changepoint_prior_scale,\n                'mcmc_samples'          : self.model.mcmc_samples,\n                'interval_width'        : self.model.interval_width,\n                'uncertainty_samples'   : self.model.uncertainty_samples,\n                'stan_backend'          : self.model.stan_backend\n            }\n\n            # \u0421\u043e\u0437\u0434\u0430\u0451\u043c \u043d\u043e\u0432\u0443\u044e \u043c\u043e\u0434\u0435\u043b\u044c \u0441 \u0442\u043e\u0439 \u0436\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0435\u0439\n            self.model = Prophet(**config)\n\n            # \u0418 \u0437\u0430\u043d\u043e\u0432\u043e \u043e\u0431\u0443\u0447\u0430\u0435\u043c \u0435\u0451 \u043d\u0430 \u00ab\u0441\u0432\u0435\u0436\u0435\u043c\u00bb \u0431\u0443\u0444\u0435\u0440\u0435 (\u0434\u043e 2048 \u0442\u043e\u0447\u0435\u043a)\n            self.model.fit(self._data_buffer)\n\n    def predict(self, timestamps):\n        # \u0414\u0435\u043b\u0430\u0435\u0442 \u043f\u0440\u043e\u0433\u043d\u043e\u0437 \u043d\u0430 \u0441\u043f\u0438\u0441\u043e\u043a \u0431\u0443\u0434\u0443\u0449\u0438\u0445 timestamps.\n\n        future = pd.DataFrame()\n        future['ds'] = pd.to_datetime(timestamps, unit='ms')\n\n        forecast = self.model.predict(future)\n        outputY = forecast['yhat'].tolist()\n        return list(zip(timestamps, outputY))\n\n    def save_state(self, file_path):\n        # \u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442:\n        #  1) \u043c\u043e\u0434\u0435\u043b\u044c Prophet (\u043b\u0438\u0431\u043e \u0431\u0430\u0439\u0442\u044b \u043f\u0443\u0441\u0442\u043e\u0442\u044b, \u0435\u0441\u043b\u0438 \u043d\u0435 \u043e\u0431\u0443\u0447\u0430\u043b\u0430\u0441\u044c),\n        #  2) \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0439 \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 (\u0447\u0442\u043e\u0431\u044b \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0441\u0442\u0438 \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435).\n\n        model = self.model\n        is_not_fit = model.history is None\n        to_serialize = (\n            EMPTY_PROPHET_MODELS_MAGIC_BYTES if is_not_fit\n            else bytes(model_to_json(model), 'UTF-8')\n        )\n        with open(file_path, 'wb') as file:\n            file.write(to_serialize)\n\n        # \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445\n        with open(file_path + '.data', 'wb') as file:\n            pickle.dump(self._data_buffer, file)\n\n    def load_state(self, file_path):\n        # \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442:\n        #  1) \u043c\u043e\u0434\u0435\u043b\u044c Prophet,\n        #  2) \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445.\n\n        with open(file_path, 'rb') as file:\n            model_json_or_nothing = file.read()\n            is_not_fit = (model_json_or_nothing == EMPTY_PROPHET_MODELS_MAGIC_BYTES)\n            self.model = Prophet() if is_not_fit else model_from_json(model_json_or_nothing)\n\n        # \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0431\u0443\u0444\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445 (\u0435\u0441\u043b\u0438 \u0444\u0430\u0439\u043b \u0435\u0441\u0442\u044c)\n        try:\n            with open(file_path + '.data', 'rb') as file:\n                self._data_buffer = pickle.load(file)\n        except FileNotFoundError:\n            self._data_buffer = pd.DataFrame(columns=['ds', 'y'])\n\n    def name(self):\n        return \"ProphetMethod\"\n\n\n    # -----------------------------------------------\n    # \u0412\u0441\u043f\u043e\u043c\u043e\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043c\u0435\u0442\u043e\u0434\u044b\n    # -----------------------------------------------\n\n    def _make_df(self, data):\n        # \u0423\u0442\u0438\u043b\u0438\u0442\u0430 \u0434\u043b\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 (timestamp, value) \u0432 DataFrame Prophet-\u0444\u043e\u0440\u043c\u0430\u0442\u0430.\n\n        df = pd.DataFrame()\n        df['ds'] = pd.to_datetime([point[0] for point in data], unit='ms')\n        df['y']  = [point[1] for point in data]\n        return df\n\n    def _update_data_buffer(self, df_new):\n        # \u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u043d\u043e\u0432\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0432 \u043a\u043e\u043d\u0435\u0446 \u0431\u0443\u0444\u0435\u0440\u0430, \u0430 \u0437\u0430\u0442\u0435\u043c \u043e\u0431\u0440\u0435\u0437\u0430\u0435\u043c \u0435\u0433\u043e, \u0435\u0441\u043b\u0438 \u043e\u043d \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 2048 \u0442\u043e\u0447\u0435\u043a.\n\n        self._data_buffer = pd.concat([self._data_buffer, df_new], ignore_index=True)\n        if len(self._data_buffer) > self.data_storage_limit:\n            self._data_buffer = self._data_buffer.iloc[-self.data_storage_limit:]\n\n#####################################################\n";
    }
}

