/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.prediction.accuracy;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.model.prediction.segment.SegmentDataDao;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.model.prediction.PredictionModel;
import org.thingsboard.trendz.service.model.prediction.PredictionModelDatasourceParameters;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethod;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodConfidenceBand;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodConfidenceLevel;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodData;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyMethodType;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyResponse;
import org.thingsboard.trendz.service.model.prediction.accuracy.AccuracyService;
import org.thingsboard.trendz.service.model.prediction.segment.SegmentData;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AccuracyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccuracyService.class);
    private final SegmentDataDao segmentDataDao;
    private final AccuracyMethodConfidenceBand accuracyMethodConfidenceBand;
    private final AccuracyMethodConfidenceLevel accuracyMethodConfidenceLevel;

    @Autowired
    public AccuracyService(SegmentDataDao segmentDataDao, AccuracyMethodConfidenceBand accuracyMethodConfidenceBand, AccuracyMethodConfidenceLevel accuracyMethodConfidenceLevel) {
        this.segmentDataDao = segmentDataDao;
        this.accuracyMethodConfidenceBand = accuracyMethodConfidenceBand;
        this.accuracyMethodConfidenceLevel = accuracyMethodConfidenceLevel;
    }

    public Mono<AccuracyResponse> processAccuracyRequest(JwtSecurityUser user, PredictionModel model, Set<UUID> itemIdSet, Set<AccuracyMethodData> accuracyMethodDataSet, boolean autoDefineSettings) {
        List<AccuracyMethodType> methodTypes = accuracyMethodDataSet.stream().map(AccuracyMethodData::getType).toList();
        log.info("Calculating accuracy for model \"{}\", item count = {}, methods = {}", new Object[]{model.getName(), itemIdSet.size(), methodTypes});
        UUID modelId = model.getId();
        PredictionModelDatasourceParameters dsParameters = model.getDatasourceParameters();
        ZoneId zoneId = ZoneId.of(dsParameters.getTzName());
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)DateAggregationType.getDateGroupingFromPicker((String)dsParameters.getAggregationInterval()));
        return Mono.just((Object)new Object()).flatMap(o -> {
            Set segmentDataSet = this.segmentDataDao.findByModelIdAndItemSet(modelId, itemIdSet);
            log.debug("Loaded segment data, count = {}", (Object)segmentDataSet.size());
            if (segmentDataSet.isEmpty()) {
                return Mono.error((Throwable)new TrendzException("Segment data were not found"));
            }
            Map<UUID, Set> itemSegmentDataMap = segmentDataSet.stream().collect(Collectors.groupingBy(segmentData -> segmentData.getItem().getId(), Collectors.toCollection(TreeSet::new)));
            itemSegmentDataMap.put(EntityId.NULL_UUID, segmentDataSet);
            HashMap<UUID, Map> itemToSegmentPrehistoricalDataMap = new HashMap<UUID, Map>();
            HashMap<UUID, Map> itemToSegmentHistoricalDataMap = new HashMap<UUID, Map>();
            HashMap<UUID, Map> itemToSegmentPredictionDataMap = new HashMap<UUID, Map>();
            int segmentCountIterator = 0;
            for (UUID itemId : itemSegmentDataMap.keySet()) {
                Set itemSegmentDataSet = itemSegmentDataMap.get(itemId);
                int index = 0;
                for (SegmentData segmentData2 : itemSegmentDataSet) {
                    itemToSegmentPrehistoricalDataMap.computeIfAbsent(itemId, key -> new HashMap()).computeIfAbsent(index, key -> segmentData2.getPrehistoricalTelemetry());
                    itemToSegmentHistoricalDataMap.computeIfAbsent(itemId, key -> new HashMap()).computeIfAbsent(index, key -> segmentData2.getHistoricalTelemetry());
                    itemToSegmentPredictionDataMap.computeIfAbsent(itemId, key -> new HashMap()).computeIfAbsent(index, key -> segmentData2.getPredictionTelemetry());
                    ++index;
                }
                segmentCountIterator = Math.max(segmentCountIterator, index);
            }
            int segmentCount = segmentCountIterator;
            Set refreshedAccuracyMethodDataSet = accuracyMethodDataSet.stream().map(accuracyMethodData -> {
                AccuracyMethodType type = accuracyMethodData.getType();
                AccuracyMethod method = this.getMethodByType(type);
                AccuracyMethodData refreshedData = autoDefineSettings ? method.autoDefineSettings(accuracyMethodData, segmentDataSet) : accuracyMethodData;
                method.validate(accuracyMethodData);
                return refreshedData;
            }).collect(Collectors.toSet());
            return Flux.fromIterable(refreshedAccuracyMethodDataSet).flatMap(accuracyMethodData -> Mono.just((Object)itemSegmentDataMap).flatMapIterable(Map::entrySet).map(entry -> {
                UUID itemId = (UUID)entry.getKey();
                Set itemSegmentData = (Set)entry.getValue();
                AccuracyMethodType type = accuracyMethodData.getType();
                AccuracyMethod method = this.getMethodByType(type);
                AccuracyData accuracyData = method.calculate(itemSegmentData, accuracyMethodData, timeUnit, zoneId, autoDefineSettings);
                return Map.entry(itemId, accuracyData);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(accuracyItemDataMap -> Map.entry(accuracyMethodData.getType(), accuracyItemDataMap))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(typeToItemToAccuracyDataMap -> AccuracyResponse.builder().modelId(modelId).itemIdSet(itemIdSet).segmentCount(segmentCount).itemToSegmentPrehistoricalDataMap(itemToSegmentPrehistoricalDataMap).itemToSegmentHistoricalDataMap(itemToSegmentHistoricalDataMap).itemToSegmentPredictionDataMap(itemToSegmentPredictionDataMap).accuracyMethodDataSet(refreshedAccuracyMethodDataSet).typeToItemToAccuracyDataMap(typeToItemToAccuracyDataMap).build());
        });
    }

    private AccuracyMethod getMethodByType(AccuracyMethodType type) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$service$model$prediction$accuracy$AccuracyMethodType[type.ordinal()]) {
            case 1 -> this.accuracyMethodConfidenceBand;
            case 2 -> this.accuracyMethodConfidenceLevel;
            default -> throw new TrendzException("Unsupported accuracy method type: " + String.valueOf(type));
        };
    }
}

