/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apache.commons.math3.ml.distance.CanberraDistance;
import org.apache.commons.math3.ml.distance.ChebyshevDistance;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.ManhattanDistance;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.model.anomaly.distance.DtwDistance;
import org.thingsboard.trendz.service.model.anomaly.distance.EuclidDistance;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;

public final class AnomaliesUtil {
    public static DistanceMeasure getMeasure(MlProperties.DistanceFunctionType functionType) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$anomaly$MlProperties$DistanceFunctionType[functionType.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new DtwDistance();
            case 2 -> new EuclidDistance();
            case 3 -> new ManhattanDistance();
            case 4 -> new CanberraDistance();
            case 5 -> new ChebyshevDistance();
        };
    }

    public static ChronoUnit unitToChronoUnit(String unit) {
        return switch (unit.toLowerCase()) {
            case "minute" -> ChronoUnit.MINUTES;
            case "hour" -> ChronoUnit.HOURS;
            case "day" -> ChronoUnit.DAYS;
            default -> throw new TrendzInternalException("Unsupported telemetry storage frequency unit: " + unit);
        };
    }

    public static double calculateScoreIndexDiff(ScoredPoint sp1, ScoredPoint sp2) {
        double averageScore = (sp1.getS() + sp2.getS()) / 2.0;
        long tsDiff = Math.abs(sp1.getT() - sp2.getT());
        double hourDurationMs = Duration.of(1L, ChronoUnit.HOURS).toMillis();
        return averageScore * (double)tsDiff / hourDurationMs;
    }

    @Generated
    private AnomaliesUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

