/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.segment;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.segment.SegmentSplitter;

@Service
public class SlidingWindowSegmentSplitter
implements SegmentSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlidingWindowSegmentSplitter.class);

    public List<Segment> split(List<ComplexTsPoint> points, MlProperties.SegmentSplitProperties properties) {
        int slidingStepPercent = properties.getSlidingStepPercent();
        long windowTimeMs = properties.getWindowSizeMs();
        long maxGapMs = properties.getMaxGapMs();
        ArrayList<Segment> result = new ArrayList<Segment>();
        LinkedList<ComplexTsPoint> window = new LinkedList<ComplexTsPoint>();
        long slidingStepMs = windowTimeMs * (long)slidingStepPercent / 100L;
        window.add(points.get(0));
        for (int currIndex = 1; currIndex < points.size(); ++currIndex) {
            ComplexTsPoint currRecord = points.get(currIndex);
            long possibleDuration = currRecord.getTs() - ((ComplexTsPoint)window.getFirst()).getTs();
            long gap = currRecord.getTs() - ((ComplexTsPoint)window.getLast()).getTs();
            if (gap > maxGapMs) {
                segment = this.buildSegment(window);
                result.add(segment);
                window.clear();
            } else if (possibleDuration > windowTimeMs) {
                segment = this.buildSegment(window);
                result.add(segment);
                long slidingStartTs = ((ComplexTsPoint)window.getFirst()).getTs();
                while (!window.isEmpty() && currRecord.getTs() - ((ComplexTsPoint)window.getFirst()).getTs() > windowTimeMs) {
                    window.pollFirst();
                }
                while (!window.isEmpty() && ((ComplexTsPoint)window.getFirst()).getTs() - slidingStartTs < slidingStepMs) {
                    window.pollFirst();
                }
            }
            window.add(currRecord);
        }
        return result;
    }
}

