/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.segment;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.segment.SegmentSplitter;

@Service
public class FixedRangeSegmentSplitter
implements SegmentSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FixedRangeSegmentSplitter.class);

    public List<Segment> split(List<ComplexTsPoint> points, MlProperties.SegmentSplitProperties properties) {
        ArrayList<ComplexTsPoint> segmentPoints;
        long windowTimeMs = properties.getWindowSizeMs();
        long maxGapMs = properties.getMaxGapMs();
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (int startIndex = 0; startIndex < points.size(); startIndex += segmentPoints.size()) {
            long duration;
            ComplexTsPoint record = points.get(startIndex);
            long segmentStartTs = record.getTs();
            segmentPoints = new ArrayList<ComplexTsPoint>();
            segmentPoints.add(record);
            ComplexTsPoint prevRec = record;
            for (int currIndex = startIndex + 1; currIndex < points.size() && (duration = (record = points.get(currIndex)).getTs() - segmentStartTs) <= windowTimeMs && record.getTs() - prevRec.getTs() <= maxGapMs; ++currIndex) {
                segmentPoints.add(record);
                prevRec = record;
            }
            segments.add(this.buildSegment(segmentPoints));
        }
        return segments;
    }
}

