/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.segment;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.service.model.anomaly.segment.CompositSegmentSplitter;
import org.thingsboard.trendz.service.model.anomaly.segment.FixedRangeSegmentSplitter;
import org.thingsboard.trendz.service.model.anomaly.segment.SegmentSplitter;
import org.thingsboard.trendz.service.model.anomaly.segment.SlidingWindowSegmentSplitter;

@Service
public class CompositSegmentSplitter
implements SegmentSplitter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositSegmentSplitter.class);
    private final FixedRangeSegmentSplitter fixedRangeSegmentSplitter;
    private final SlidingWindowSegmentSplitter slidingWindowSegmentSplitter;

    @Autowired
    public CompositSegmentSplitter(FixedRangeSegmentSplitter fixedRangeSegmentSplitter, SlidingWindowSegmentSplitter slidingWindowSegmentSplitter) {
        this.fixedRangeSegmentSplitter = fixedRangeSegmentSplitter;
        this.slidingWindowSegmentSplitter = slidingWindowSegmentSplitter;
    }

    public List<Segment> split(List<ComplexTsPoint> points, MlProperties.SegmentSplitProperties properties) {
        if (CollectionUtils.isEmpty(points)) {
            return Collections.emptyList();
        }
        SegmentSplitter splitter = this.getSplitter(properties);
        List segments = splitter.split(points, properties);
        log.info("Found segments {}", (Object)segments.size());
        return segments;
    }

    private SegmentSplitter getSplitter(MlProperties.SegmentSplitProperties properties) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$anomaly$MlProperties$SegmentSplitType[properties.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.fixedRangeSegmentSplitter;
            case 2 -> this.slidingWindowSegmentSplitter;
        };
    }
}

