/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.segment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.DoubleStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.ComplexTsPoint;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.service.model.anomaly.segment.AggregateReducer;

@Service
public class AggregateReducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AggregateReducer.class);

    public List<ComplexTsPoint> reduce(List<ComplexTsPoint> original, Set<UUID> fieldIds, int requiredSize, MlProperties.FeatureAggregation aggregation) {
        ArrayList<ComplexTsPoint> aggregated = new ArrayList<ComplexTsPoint>();
        long maxTs = original.stream().mapToLong(ComplexTsPoint::getTs).max().orElse(0L);
        long minTs = original.stream().mapToLong(ComplexTsPoint::getTs).min().orElse(0L);
        long stepMs = (maxTs - minTs) / (long)requiredSize;
        for (long windowStartTs = minTs; windowStartTs <= maxTs; windowStartTs += stepMs) {
            long finalWindowStartTs = windowStartTs;
            HashMap<UUID, Double> valueMap = new HashMap<UUID, Double>();
            for (UUID fieldId : fieldIds) {
                DoubleStream doubleStream = original.stream().filter(r -> r.getTs() >= finalWindowStartTs && r.getTs() <= finalWindowStartTs + stepMs).map(cp -> (Double)cp.getValues().get(fieldId)).filter(Objects::nonNull).mapToDouble(d -> d);
                double aggValue = this.aggregate(doubleStream, aggregation);
                valueMap.put(fieldId, aggValue);
            }
            ComplexTsPoint aggRec = new ComplexTsPoint(windowStartTs, valueMap);
            aggregated.add(aggRec);
        }
        return aggregated;
    }

    private double aggregate(DoubleStream doubleStream, MlProperties.FeatureAggregation agg) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$anomaly$MlProperties$FeatureAggregation[agg.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> doubleStream.sum();
            case 2 -> doubleStream.average().orElse(0.0);
            case 3 -> doubleStream.min().orElse(0.0);
            case 4 -> doubleStream.max().orElse(0.0);
            case 5 -> doubleStream.count();
        };
    }
}

