/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.cluster;

import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.anomaly.ClusterableSegment;
import org.thingsboard.trendz.domain.anomaly.MlProperties;
import org.thingsboard.trendz.domain.anomaly.Segment;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.service.model.anomaly.cluster.CompositeSegmentClusterer;
import org.thingsboard.trendz.service.model.anomaly.cluster.CustomDistanceClusterer;
import org.thingsboard.trendz.service.model.anomaly.cluster.DBScanClusterer;
import org.thingsboard.trendz.service.model.anomaly.cluster.KMeansClusterer;
import org.thingsboard.trendz.service.model.anomaly.cluster.SegmentClusterer;
import org.thingsboard.trendz.service.model.anomaly.util.AnomaliesUtil;

@Component
public class CompositeSegmentClusterer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeSegmentClusterer.class);
    @Autowired
    private DBScanClusterer dbScanClusterer;
    @Autowired
    private KMeansClusterer kMeansClusterer;
    @Autowired
    private CustomDistanceClusterer customDistanceClusterer;

    public List<CentroidCluster<ClusterableSegment>> cluster(List<Segment> segments, MlProperties.ClusteringProperties properties) {
        DistanceMeasure measure = this.getMeasure(properties);
        SegmentClusterer clusterer = this.getClusterer(properties);
        List centroids = this.extract(clusterer, segments, measure, properties);
        centroids.sort(Comparator.comparingInt(o -> o.getPoints().size()));
        log.info("Detected centroids {}", (Object)centroids.size());
        for (int i = 0; i < centroids.size(); ++i) {
            CentroidCluster cluster = (CentroidCluster)centroids.get(i);
            Clusterable center = cluster.getCenter();
            List clusterRecords = cluster.getPoints();
            log.info("Cluster {} size {}", (Object)i, (Object)clusterRecords.size());
        }
        return centroids;
    }

    private SegmentClusterer getClusterer(MlProperties.ClusteringProperties properties) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$anomaly$MlProperties$ClusterAlgorithm[properties.getClusterAlgorithm().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.customDistanceClusterer;
            case 2 -> this.kMeansClusterer;
            case 3 -> this.dbScanClusterer;
        };
    }

    private DistanceMeasure getMeasure(MlProperties.ClusteringProperties properties) {
        return AnomaliesUtil.getMeasure((MlProperties.DistanceFunctionType)properties.getClusterLearnDistFunc());
    }

    private List<CentroidCluster<ClusterableSegment>> extract(SegmentClusterer clusterer, List<Segment> segments, DistanceMeasure distanceMeasure, MlProperties.ClusteringProperties properties) {
        try {
            return clusterer.cluster(segments, distanceMeasure, properties);
        }
        catch (NumberIsTooSmallException e) {
            throw new BadConfiguredTaskException("The given segment has to small count of points, less than clusters count. Segment time range increasing might be helpful.");
        }
    }
}

