/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.cluster;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.random.EmpiricalDistribution;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;
import org.thingsboard.trendz.domain.anomaly.ClusterableSegment;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;

@Service
public class ClusterInfoBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterInfoBuilder.class);

    public List<ClusterInfo> build(List<CentroidCluster<ClusterableSegment>> centroids, List<Anomaly> anomalies) {
        ArrayList<ClusterInfo> result = new ArrayList<ClusterInfo>();
        long clusterId = 0L;
        for (CentroidCluster<ClusterableSegment> centroid : centroids) {
            long finalClusterId = ++clusterId;
            List clusterAnomalies = anomalies.stream().filter(a -> a.getClusterId() == finalClusterId).collect(Collectors.toList());
            int segmentCount = clusterAnomalies.size();
            int segmentPercent = anomalies.isEmpty() ? 0 : clusterAnomalies.size() * 100 / anomalies.size();
            long duration = clusterAnomalies.stream().mapToLong(a -> a.getEndTs() - a.getStartTs()).sum();
            double minScore = clusterAnomalies.stream().mapToDouble(Anomaly::getScore).min().orElse(0.0);
            double maxScore = clusterAnomalies.stream().mapToDouble(Anomaly::getScore).max().orElse(0.0);
            AtomicInteger index = new AtomicInteger();
            double[] centerPoints = centroid.getCenter().getPoint();
            List centroidPoints = Doubles.asList((double[])centerPoints).stream().map(d -> new ScoredPoint((long)index.incrementAndGet(), d)).collect(Collectors.toList());
            HashMap examples = new HashMap();
            int j = 0;
            int jStep = centroid.getPoints().size() / 20;
            for (ClusterableSegment segment : centroid.getPoints()) {
                if (jStep == 0 || j % jStep == 0) {
                    index.set(0);
                    List coordinates = Doubles.asList((double[])segment.getPoint()).stream().map(d -> new ScoredPoint((long)index.incrementAndGet(), d)).collect(Collectors.toList());
                    examples.put(TimeStampUUIDGenerator.generateId(), coordinates);
                }
                ++j;
            }
            ArrayList<ScoredPoint> histogram = new ArrayList<ScoredPoint>();
            double[] data = clusterAnomalies.stream().mapToDouble(Anomaly::getScore).toArray();
            EmpiricalDistribution distribution = new EmpiricalDistribution(20);
            distribution.load(data);
            for (SummaryStatistics binStat : distribution.getBinStats()) {
                if (Double.isNaN(binStat.getMin())) continue;
                histogram.add(new ScoredPoint((long)binStat.getMin(), Double.valueOf(binStat.getN())));
            }
            ClusterInfo clusterInfo = ClusterInfo.builder().clusterId(finalClusterId).segmentsCount(segmentCount).segmentsPercent(segmentPercent).durationMs(duration).minScore(minScore).maxScore(maxScore).centroid(centroidPoints).clusterExamples(examples).histogram(histogram).build();
            result.add(clusterInfo);
        }
        return result;
    }
}

