/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly.anomalyfield;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyDao;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyAggregatedData;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.model.anomaly.AnomalyMapper;
import org.thingsboard.trendz.service.model.anomaly.anomalyfield.AnomalyField;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyFilter;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Flux;

@Service
public class AnomalyFieldProcessor {
    private final AnomalyMapper anomalyMapper;
    private final AnomalyDao anomalyDao;

    @Autowired
    public AnomalyFieldProcessor(AnomalyMapper anomalyMapper, AnomalyDao anomalyDao) {
        this.anomalyMapper = anomalyMapper;
        this.anomalyDao = anomalyDao;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Measurable(context="#ctx", type=MeasuredTaskType.ANOMALY_FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType", itemName="#item.name")
    public Flux<FieldValue> processField(Item item, ViewField viewField, ViewRequest viewRequest, ViewContext ctx) {
        List fieldValues;
        long startTs = viewRequest.getStartTs(viewField);
        long endTs = viewRequest.getEndTs(viewField);
        AnomalyFilter filter = new AnomalyFilter();
        filter.setItemIds(Set.of(item.getId()));
        filter.setModelIds(Set.of(viewField.getAnomalyModelId()));
        filter.setStartTs(Long.valueOf(startTs));
        filter.setEndTs(Long.valueOf(endTs));
        List anomalies = this.anomalyDao.findByFilter(filter);
        if (viewRequest.getMinimalDateAggregation() != null) {
            if (viewField.getAggregationType() == FieldAggregation.COUNT) {
                fieldValues = this.mapAnomalyAggregatedDataOnFieldValues(item, anomalies, startTs, endTs, viewRequest.getZoneId(), viewRequest.getMinimalDateAggregation(), AnomalyAggregatedData::getCount);
                return Flux.fromIterable((Iterable)fieldValues).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
            } else if (viewField.getSelectedAnomalyField() == AnomalyField.SCORE) {
                fieldValues = this.mapAnomalyAggregatedDataOnFieldValues(item, anomalies, startTs, endTs, viewRequest.getZoneId(), viewRequest.getMinimalDateAggregation(), AnomalyAggregatedData::getScore);
                return Flux.fromIterable((Iterable)fieldValues).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
            } else {
                if (viewField.getSelectedAnomalyField() != AnomalyField.SCORE_INDEX) throw new TrendzInternalException("Anomaly field is not supported: " + String.valueOf(viewField.getSelectedAnomalyField()));
                fieldValues = this.mapAnomalyAggregatedDataOnFieldValues(item, anomalies, startTs, endTs, viewRequest.getZoneId(), viewRequest.getMinimalDateAggregation(), AnomalyAggregatedData::getScoreIndex);
            }
            return Flux.fromIterable((Iterable)fieldValues).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
        } else if (viewField.getAggregationType() == FieldAggregation.COUNT) {
            fieldValues = this.simpleMapAnomalyCount(item, anomalies, startTs);
            return Flux.fromIterable((Iterable)fieldValues).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
        } else if (viewField.getSelectedAnomalyField() == AnomalyField.SCORE) {
            fieldValues = this.simpleMapAnomalyScore(item, anomalies, startTs, endTs);
            return Flux.fromIterable((Iterable)fieldValues).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
        } else {
            if (viewField.getSelectedAnomalyField() != AnomalyField.SCORE_INDEX) throw new TrendzInternalException("Anomaly field is not supported: " + String.valueOf(viewField.getSelectedAnomalyField()));
            fieldValues = this.simpleMapAnomalyScore(item, anomalies, startTs);
        }
        return Flux.fromIterable((Iterable)fieldValues).defaultIfEmpty((Object)new FieldValue(item, FieldType.BLANK, null));
    }

    private List<FieldValue> mapAnomalyAggregatedDataOnFieldValues(Item item, List<Anomaly> anomalies, long startTs, long endTs, ZoneId zoneId, DateAggregationType dateAggregationType, Function<AnomalyAggregatedData, Object> aggregator) {
        ChronoUnit chronoUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)dateAggregationType);
        Map dataMap = this.anomalyMapper.generateTelemetryMap(startTs, endTs, chronoUnit, zoneId);
        anomalies.forEach(anomaly -> this.anomalyMapper.populateTelemetryMapWithAnomaly(dataMap, anomaly, chronoUnit, zoneId));
        return dataMap.entrySet().stream().map(entry -> new FieldValue(Set.of(item), FieldType.NUMERIC, aggregator.apply((AnomalyAggregatedData)entry.getValue()), ((Long)entry.getKey()).longValue())).toList();
    }

    private List<FieldValue> simpleMapAnomalyScore(Item item, List<Anomaly> anomalies, long startTs, long endTs) {
        return anomalies.stream().map(anomaly -> anomaly.getData().stream().filter(sp -> startTs <= sp.getT() && sp.getT() <= endTs).mapToDouble(ScoredPoint::getS).max()).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).map(value -> new FieldValue(Set.of(item), FieldType.NUMERIC, value, startTs)).toList();
    }

    private List<FieldValue> simpleMapAnomalyScore(Item item, List<Anomaly> anomalies, long startTs) {
        return anomalies.stream().map(Anomaly::getScoreIndex).map(value -> new FieldValue(Set.of(item), FieldType.NUMERIC, value, startTs)).toList();
    }

    private List<FieldValue> simpleMapAnomalyCount(Item item, List<Anomaly> anomalies, long startTs) {
        return anomalies.stream().map(value -> new FieldValue(Set.of(item), FieldType.NUMERIC, (Object)1, startTs)).toList();
    }
}

