/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyAggregatedData;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.TbDataEntry;
import org.thingsboard.trendz.service.model.anomaly.AnomalyMapper;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelAssociatedFieldService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.view.ItemService;
import reactor.core.publisher.Mono;

@Service
public class AnomalyTbService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyTbService.class);
    private final AnomalyMapper anomalyMapper;
    private final ItemService itemService;
    private final BusinessEntityService businessEntityService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public AnomalyTbService(AnomalyMapper anomalyMapper, ItemService itemService, BusinessEntityService businessEntityService, TbRestDataSource tbRestDataSource) {
        this.anomalyMapper = anomalyMapper;
        this.itemService = itemService;
        this.businessEntityService = businessEntityService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public Mono<Boolean> saveAnomaliesToTb(AnomalyModel anomalyModel, Set<ItemLite> itemSet, List<Anomaly> anomalies, long startTs, long endTs, ZoneId zoneId, ChronoUnit unit) {
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(anomalyModel.getUser(), anomalyModel.getDatasetConfig().getBusinessEntityId());
        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
        if (anomalyModel.getTbTelemetryKey() == null) {
            log.warn("TbKeys were not found for anomaly model: {}", (Object)anomalyModel.getName());
            return Mono.just((Object)false);
        }
        String scoreKey = AnomalyModelAssociatedFieldService.getScoreTbKey((String)anomalyModel.getTbTelemetryKey());
        String indexKey = AnomalyModelAssociatedFieldService.getScoreIndexTbKey((String)anomalyModel.getTbTelemetryKey());
        Map<String, Double> emptyMap = Map.of(scoreKey, 0.0, indexKey, 0.0);
        Map itemAnomaliesMap = anomalies.stream().collect(Collectors.groupingBy(Anomaly::getItemId, Collectors.toList()));
        return this.itemService.loadItems(businessEntity.getId(), itemSet, anomalyModel.getUser()).map(item -> {
            Map telemetryMap = this.anomalyMapper.generateTelemetryMap(startTs, endTs, unit, zoneId);
            itemAnomaliesMap.getOrDefault(item.getId(), Collections.emptyList()).forEach(anomaly -> this.anomalyMapper.populateTelemetryMapWithAnomaly(telemetryMap, anomaly, unit, zoneId));
            List tbDataEntryList = telemetryMap.entrySet().stream().map(entry -> {
                AnomalyAggregatedData anomalyAggregatedData = (AnomalyAggregatedData)entry.getValue();
                Map<String, Double> map = anomalyAggregatedData.isEmpty() ? emptyMap : Map.of(scoreKey, anomalyAggregatedData.getScore(), indexKey, anomalyAggregatedData.getScoreIndex());
                return new TbDataEntry(((Long)entry.getKey()).longValue(), map);
            }).collect(Collectors.toList());
            return Pair.of((Object)item.getId(), tbDataEntryList);
        }).flatMap(telemetryPair -> this.tbRestDataSource.sendTelemetryDirectly(null, entityType.name(), (UUID)telemetryPair.getLeft(), anomalyModel.getUser(), (List)telemetryPair.getRight())).all(status -> status);
    }
}

