/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelProperties;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelTaskData;
import org.thingsboard.trendz.domain.anomaly.ChangeAnomalyModelConfig;
import org.thingsboard.trendz.domain.anomaly.ClusterReport;
import org.thingsboard.trendz.domain.anomaly.DataVector;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.anomaly.ModelType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.BadConfiguredTaskException;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.model.anomaly.TrendzAnomalyModelException;
import org.thingsboard.trendz.exception.task.TrendzTaskException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metrics.ModelMetricService;
import org.thingsboard.trendz.service.model.anomaly.ClusteringService;
import org.thingsboard.trendz.service.model.anomaly.fetcher.DatasetFetcher;
import reactor.core.publisher.Mono;

@Service
public class AnomalyModelBuildService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelBuildService.class);
    private final BusinessEntityService businessEntityService;
    private final ClusteringService clusteringService;
    private final DatasetFetcher datasetFetcher;
    private final ModelMetricService metricService;

    @Autowired
    public AnomalyModelBuildService(BusinessEntityService businessEntityService, ClusteringService clusteringService, DatasetFetcher datasetFetcher, ModelMetricService metricService) {
        this.businessEntityService = businessEntityService;
        this.clusteringService = clusteringService;
        this.datasetFetcher = datasetFetcher;
        this.metricService = metricService;
    }

    public AnomalyModel createInitialModel(JwtSecurityUser user, AnomalyModelProperties properties) {
        UUID modelId = TimeStampUUIDGenerator.generateId();
        properties.setModelId(modelId);
        AnomalyModel clusterModel = new AnomalyModel();
        clusterModel.setId(modelId);
        clusterModel.setCreateTs(System.currentTimeMillis());
        this.populateModel(user, clusterModel, properties, ChangeAnomalyModelConfig.getInstanceForNewModel());
        return clusterModel;
    }

    public void populateModel(JwtSecurityUser user, AnomalyModel model, AnomalyModelProperties properties, ChangeAnomalyModelConfig config) {
        model.setUser(user);
        model.setEnabledAlarmDeletion(properties.isEnabledAlarmDeletion());
        if (model.getTaskData() == null) {
            model.setTaskData(AnomalyModelTaskData.getDefault((UUID)model.getId()));
        }
        if (!config.isNameTheSame()) {
            model.setName(properties.getName());
        }
        if (!config.isTelemetryKeyTheSame()) {
            model.setTbTelemetryKey(properties.getTbTelemetryKey());
        }
        if (!config.isTelemetrySavingOptionsTheSame()) {
            model.setTelemetrySavePeriodUnit(properties.getTelemetrySavePeriodUnit());
        }
        if (!config.isDatasetTheSame()) {
            UUID datasetId = model.getDatasetConfig() == null || model.getDatasetConfig().getId() == null ? UUID.randomUUID() : model.getDatasetConfig().getId();
            model.setDatasetConfig(properties.getDatasetConfig());
            model.getDatasetConfig().setId(datasetId);
            UUID businessEntityId = model.getDatasetConfig().getFields().stream().map(ViewField::getBusinessEntityId).findAny().orElseThrow(() -> new TrendzAnomalyModelException("The model does not contain any entity."));
            this.businessEntityService.findEntityById(user, businessEntityId);
            model.getDatasetConfig().setBusinessEntityId(businessEntityId);
        }
        if (config.isRebuildRequired()) {
            model.setStatus(AnomalyModelStatus.QUEUED);
        }
        if (!config.isMlPropertiesTheSame()) {
            UUID propertiesId = model.getProperties() == null || model.getProperties().getId() == null ? UUID.randomUUID() : model.getProperties().getId();
            model.setProperties(properties.getMlProperties());
            model.getProperties().setId(propertiesId);
        }
        if (!config.isModelTypeTheSame()) {
            model.setType(properties.getModelType());
        }
        if (!config.isAlarmTypeTheSame()) {
            model.setAlarmType(properties.getAlarmType());
        }
        if (!config.isAlarmConfigTheSame()) {
            model.setAnomalyAlarmConfig(properties.getAlarmConfig());
        }
    }

    public Mono<ClusterReport> buildModel(JwtSecurityUser user, AnomalyModel anomalyModelToBuild) {
        if (ModelType.CLUSTERING.equals((Object)anomalyModelToBuild.getType())) {
            return this.buildClusterModel(user, anomalyModelToBuild);
        }
        return Mono.error((Throwable)new TrendzInternalException("model type not supported " + String.valueOf(anomalyModelToBuild.getType())));
    }

    private Mono<ClusterReport> buildClusterModel(JwtSecurityUser user, AnomalyModel anomalyModelToBuild) {
        this.metricService.incrementAllModelsBuild(user);
        AtomicLong allStartTs = new AtomicLong();
        anomalyModelToBuild.setStatus(AnomalyModelStatus.IN_PROGRESS);
        DatasetConfig datasetConfig = anomalyModelToBuild.getDatasetConfig();
        datasetConfig.setMaxPointsCount(anomalyModelToBuild.getProperties().getSegmentSplitProperties().getMaxPointsCount());
        return Mono.fromRunnable(() -> allStartTs.set(System.currentTimeMillis())).then(this.datasetFetcher.fetchDataset(user, datasetConfig).collectList()).map(dataset -> {
            this.validateDataset(dataset);
            ClusterReport clusterReport = this.clusteringService.computeClusters(anomalyModelToBuild, dataset);
            anomalyModelToBuild.setStatus(AnomalyModelStatus.READY);
            long allEndTs = System.currentTimeMillis();
            this.metricService.incrementSuccessfulModelsBuild(user);
            this.metricService.recordSuccessfulReportDuration(user, allEndTs - allStartTs.get());
            return clusterReport;
        }).doOnError(th -> {
            anomalyModelToBuild.setStatus(AnomalyModelStatus.FAILED);
            long allEndTs = System.currentTimeMillis();
            this.metricService.incrementFailedModelsBuild(user);
            this.metricService.recordFailedReportDuration(user, allEndTs - allStartTs.get());
            log.error("Cluster model build failed {}", (Object)anomalyModelToBuild, th);
        }).doFinally(t -> {
            long allEndTs = System.currentTimeMillis();
            log.info("Model Ready in {} ms", (Object)(allEndTs - allStartTs.get()));
        });
    }

    private void validateDataset(List<DataVector> dataset) {
        if (CollectionUtils.isEmpty(dataset)) {
            throw new BadConfiguredTaskException("No Items found for configured datasource");
        }
        long totalPoints = dataset.stream().mapToLong(dv -> dv.getPoints().values().stream().mapToLong(List::size).sum()).sum();
        if (totalPoints < 50L) {
            String message = String.format("Found %s points. But minimum 50 points required", totalPoints);
            throw new TrendzTaskException(message);
        }
    }
}

