/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.model.anomaly;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.trendz.domain.alarm.AlarmCreateRequest;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmConfig;
import org.thingsboard.trendz.domain.anomaly.AnomalyAlarmReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.alarm.AlarmService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AnomalyAlarmService {
    private final AlarmService alarmService;

    @Autowired
    public AnomalyAlarmService(AlarmService alarmService) {
        this.alarmService = alarmService;
    }

    public Mono<Boolean> clearOrDeleteAlarmsFrom(JwtSecurityUser user, List<Anomaly> anomalies, boolean delete) {
        Set alarmsToDeleteOrClear = anomalies.stream().map(Anomaly::getAlarmId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (alarmsToDeleteOrClear.isEmpty()) {
            return Mono.just((Object)true);
        }
        if (delete) {
            return this.alarmService.deleteAll(user, alarmsToDeleteOrClear).doOnNext(res -> anomalies.forEach(anomaly -> anomaly.setAlarmId(null)));
        }
        return this.alarmService.clearAll(user, alarmsToDeleteOrClear).doOnNext(res -> anomalies.forEach(anomaly -> anomaly.setAlarmId(null)));
    }

    public Flux<AnomalyAlarmReport> createAlarms(JwtSecurityUser user, AnomalyModel anomalyModel, List<Anomaly> anomalies, long activeFromTs, AnomalyAlarmConfig anomalyAlarmConfig) {
        String alarmType = this.extractAlarmType(anomalyModel);
        return Flux.fromStream(anomalies.stream().filter(anomaly -> anomaly.getScore() >= (double)anomalyAlarmConfig.getAlarmCreationThreshold())).flatMap(anomaly -> {
            AlarmCreateRequest alarmCreateRequest = this.alarmCreateRequestFromAnomaly(anomaly, activeFromTs, alarmType, anomalyAlarmConfig);
            return this.alarmService.createAlarm(alarmCreateRequest, user, anomalyModel.getDatasetConfig().getBusinessEntityId()).map(alarm -> {
                boolean isCreatedNew = !alarm.getId().getId().equals(anomaly.getAlarmId());
                return new AnomalyAlarmReport(alarm, anomaly, isCreatedNew);
            });
        });
    }

    private String extractAlarmType(AnomalyModel anomalyModel) {
        return anomalyModel.getAlarmType() == null ? "Anomaly from '%s' anomaly model".formatted(anomalyModel.getName()) : anomalyModel.getAlarmType();
    }

    private AlarmCreateRequest alarmCreateRequestFromAnomaly(Anomaly anomaly, long activeFrom, String type, AnomalyAlarmConfig anomalyAlarmConfig) {
        boolean isActive = activeFrom <= anomaly.getEndTs();
        return AlarmCreateRequest.builder().alarmId(anomaly.getAlarmId()).itemId(anomaly.getItemId()).type(type).timeRange(TimeRange.builder().startTs(anomaly.getStartTs()).endTs(anomaly.getEndTs()).build()).alarmSeverity(this.getAlarmSeverity(anomaly, anomalyAlarmConfig)).isActive(isActive).build();
    }

    private AlarmSeverity getAlarmSeverity(Anomaly anomaly, AnomalyAlarmConfig anomalyAlarmConfig) {
        if (anomaly.getScore() >= (double)anomalyAlarmConfig.getCriticalScoreThreshold() && anomalyAlarmConfig.getCriticalScoreThreshold() > 0) {
            return AlarmSeverity.CRITICAL;
        }
        if (anomaly.getScore() >= (double)anomalyAlarmConfig.getMajorScoreThreshold() && anomalyAlarmConfig.getMajorScoreThreshold() > 0) {
            return AlarmSeverity.MAJOR;
        }
        if (anomaly.getScore() >= (double)anomalyAlarmConfig.getMinorScoreThreshold() && anomalyAlarmConfig.getMinorScoreThreshold() > 0) {
            return AlarmSeverity.MINOR;
        }
        return AlarmSeverity.WARNING;
    }
}

