/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.metrics.MetricService;

@Service
public class ViewReportMetricService
extends MetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewReportMetricService.class);
    private final Counter allReportsCounter = this.registerCounter("count.all", "How many reports were started");
    private final Counter successfulReportsCounter = this.registerCounter("count.successful", "How many reports were finished successful");
    private final Counter failedReportsCounter = this.registerCounter("count.failed", "How many reports were failed");
    private final DistributionSummary reportsDurationAllSummary = this.registerDistributionSummary("duration.all", "Duration of each of all reports", "Millis");
    private final DistributionSummary reportsDurationSuccessfulSummary = this.registerDistributionSummary("duration.successful", "Duration of each of successful reports", "Millis");
    private final DistributionSummary reportsDurationFailedSummary = this.registerDistributionSummary("duration.failed", "Duration of each of failed reports", "Millis");
    private final DistributionSummary loadTelemetryPointsCountSummary = this.registerDistributionSummary("telemetry.load.points.count", "Count of telemetry points loaded", "Points");
    private final DistributionSummary loadTelemetryRequestsCountSummary = this.registerDistributionSummary("telemetry.load.requests.count", "Count of telemetry requests loaded", "Requests");
    private final Map<UUID, Counter> tenantIdToAllReportsCounterMap = new ConcurrentHashMap();
    private final Map<UUID, Counter> tenantIdToSuccessfulReportsCounterMap = new ConcurrentHashMap();
    private final Map<UUID, Counter> tenantIdToFailedReportsCounterMap = new ConcurrentHashMap();
    private final Map<UUID, DistributionSummary> tenantIdToReportsDurationAllSummaryMap = new ConcurrentHashMap();
    private final Map<UUID, DistributionSummary> tenantIdToReportsDurationSuccessfulSummaryMap = new ConcurrentHashMap();
    private final Map<UUID, DistributionSummary> tenantIdToReportsDurationFailedSummaryMap = new ConcurrentHashMap();
    private final Map<UUID, DistributionSummary> tenantIdToLoadTelemetryPointsCountSummaryMap = new ConcurrentHashMap();
    private final Map<UUID, DistributionSummary> tenantIdToLoadTelemetryRequestsCountSummaryMap = new ConcurrentHashMap();

    @Autowired
    public ViewReportMetricService(MeterRegistry meterRegistry, UserManagementService userManagementService) {
        super(meterRegistry, userManagementService);
    }

    protected String getMetricPrefix() {
        return super.getMetricPrefix() + "reports.";
    }

    public void incrementAllReportsCounter(JwtSecurityUser user) {
        this.allReportsCounter.increment();
        this.tenantIdToAllReportsCounterMap.computeIfAbsent(user.getTenantId(), key -> this.registerCounter("count.all", "How many reports were started", user)).increment();
    }

    public void incrementSuccessfulReportsCounter(JwtSecurityUser user) {
        this.successfulReportsCounter.increment();
        this.tenantIdToSuccessfulReportsCounterMap.computeIfAbsent(user.getTenantId(), key -> this.registerCounter("count.successful", "How many reports were finished successful", user)).increment();
    }

    public void incrementFailedReportsCounter(JwtSecurityUser user) {
        this.failedReportsCounter.increment();
        this.tenantIdToFailedReportsCounterMap.computeIfAbsent(user.getTenantId(), key -> this.registerCounter("count.failed", "How many reports were failed", user)).increment();
    }

    public void recordSuccessfulReportDuration(JwtSecurityUser user, long duration) {
        DistributionSummary summaryAllByTenant = this.tenantIdToReportsDurationAllSummaryMap.computeIfAbsent(user.getTenantId(), key -> this.registerDistributionSummary("duration.all", "Duration of each of all reports", "Millis", user));
        DistributionSummary summarySuccessfulByTenant = this.tenantIdToReportsDurationSuccessfulSummaryMap.computeIfAbsent(user.getTenantId(), key -> this.registerDistributionSummary("duration.successful", "Duration of each of successful reports", "Millis", user));
        this.reportsDurationAllSummary.record((double)duration);
        this.reportsDurationSuccessfulSummary.record((double)duration);
        summaryAllByTenant.record((double)duration);
        summarySuccessfulByTenant.record((double)duration);
    }

    public void recordFailedReportDuration(JwtSecurityUser user, long duration) {
        DistributionSummary summaryAllByTenant = this.tenantIdToReportsDurationAllSummaryMap.computeIfAbsent(user.getTenantId(), key -> this.registerDistributionSummary("duration.all", "Duration of each of all reports", "Millis", user));
        DistributionSummary summaryFailedByTenant = this.tenantIdToReportsDurationFailedSummaryMap.computeIfAbsent(user.getTenantId(), key -> this.registerDistributionSummary("duration.failed", "Duration of each of failed reports", "Millis", user));
        this.reportsDurationAllSummary.record((double)duration);
        this.reportsDurationFailedSummary.record((double)duration);
        summaryAllByTenant.record((double)duration);
        summaryFailedByTenant.record((double)duration);
    }

    public void recordLoadTelemetryPointsCount(JwtSecurityUser user, long pointsCount, long requestsCount) {
        DistributionSummary summaryByTenantForPoints = this.tenantIdToLoadTelemetryPointsCountSummaryMap.computeIfAbsent(user.getTenantId(), key -> this.registerDistributionSummary("telemetry.load.points.count", "Count of telemetry points loaded", "Points", user));
        DistributionSummary summaryForTenantForRequests = this.tenantIdToLoadTelemetryRequestsCountSummaryMap.computeIfAbsent(user.getTenantId(), key -> this.registerDistributionSummary("telemetry.load.requests.count", "Count of telemetry requests loaded", "Requests"));
        this.loadTelemetryPointsCountSummary.record((double)pointsCount);
        this.loadTelemetryRequestsCountSummary.record((double)requestsCount);
        summaryByTenantForPoints.record((double)pointsCount);
        summaryForTenantForRequests.record((double)requestsCount);
    }

    private Counter registerCounter(String name, String description) {
        return this.registerCounter(name, description, null);
    }

    private Counter registerCounter(String name, String description, JwtSecurityUser user) {
        return Counter.builder((String)(this.getMetricPrefix() + name)).description(description).baseUnit("Report").tag("tenant", user == null ? "All" : this.getTenantId(user)).tag("tenant_name", user == null ? "All" : this.getTenantName(user)).tag("customer", user == null ? "All" : this.getCustomerId(user)).tag("customer_name", user == null ? "All" : this.getCustomerName(user)).register(this.meterRegistry);
    }

    private DistributionSummary registerDistributionSummary(String name, String description, String unit) {
        return this.registerDistributionSummary(name, description, unit, null);
    }

    private DistributionSummary registerDistributionSummary(String name, String description, String unit, JwtSecurityUser user) {
        return DistributionSummary.builder((String)(this.getMetricPrefix() + name)).description(description).baseUnit(unit).tag("tenant", user == null ? "All" : this.getTenantId(user)).tag("tenant_name", user == null ? "All" : this.getTenantName(user)).tag("customer", user == null ? "All" : this.getCustomerId(user)).tag("customer_name", user == null ? "All" : this.getCustomerName(user)).register(this.meterRegistry);
    }
}

