/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metrics;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RateLimitsMetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitsMetricService.class);
    private Gauge totalRequestCountGauge;
    private Gauge connectionsMaxGauge;
    private Gauge connectionsTotalGauge;
    private Gauge connectionsActiveGauge;
    private Gauge connectionsIdleGauge;
    private Gauge connectionsPendingGauge;
    private Gauge connectionsWaitingGauge;
    private DistributionSummary rateLimitWaitSummary;
    private final MeterRegistry meterRegistry;

    @Autowired
    public RateLimitsMetricService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.rateLimitWaitSummary = DistributionSummary.builder((String)"trendz.rateLimitWait").description("Waiting quota duration for each request sent by Trendz during current runtime.").baseUnit("Millis").register(meterRegistry);
    }

    private String getMetricPrefix() {
        return "trendz.webclient.";
    }

    public void initializeRequestsTotal(AtomicLong count) {
        this.totalRequestCountGauge = Gauge.builder((String)(this.getMetricPrefix() + "requests.total"), (Object)count, AtomicLong::get).description("Total count of requests sent by Trendz during current runtime.").baseUnit("Request").register(this.meterRegistry);
    }

    public void initializeRequestsPending(AtomicLong count) {
        this.connectionsPendingGauge = Gauge.builder((String)(this.getMetricPrefix() + "requests.pending"), (Object)count, AtomicLong::get).description("Count of request waiting free connection in the web client pool.").baseUnit("Request").register(this.meterRegistry);
    }

    public void initializeRequestsWaiting(AtomicLong count) {
        this.connectionsWaitingGauge = Gauge.builder((String)(this.getMetricPrefix() + "requests.waiting"), (Object)count, AtomicLong::get).description("Count of request waiting rate limit permission before become pending request waiting connection.").baseUnit("Request").register(this.meterRegistry);
    }

    public void initializeConnectionsMax(int count) {
        this.connectionsMaxGauge = Gauge.builder((String)(this.getMetricPrefix() + "connections.max"), (Object)count, i -> i.intValue()).description("Maximum possible count of connections in the web client pool (static value).").baseUnit("Connection").register(this.meterRegistry);
    }

    public void initializeConnectionsTotal(AtomicLong count) {
        this.connectionsTotalGauge = Gauge.builder((String)(this.getMetricPrefix() + "connections.total"), (Object)count, AtomicLong::get).description("Total count of created connections in the web client pool.").baseUnit("Connection").register(this.meterRegistry);
    }

    public void initializeConnectionsActive(AtomicLong count) {
        this.connectionsActiveGauge = Gauge.builder((String)(this.getMetricPrefix() + "connections.active"), (Object)count, AtomicLong::get).description("Count of active connections in the web client pool.").baseUnit("Connection").register(this.meterRegistry);
    }

    public void initializeConnectionsIdle(AtomicLong count) {
        this.connectionsIdleGauge = Gauge.builder((String)(this.getMetricPrefix() + "connections.idle"), (Object)count, AtomicLong::get).description("Count of idle connections in the web client pool.").baseUnit("Connection").register(this.meterRegistry);
    }

    public void recordRateLimitWaitDuration(long duration) {
        this.rateLimitWaitSummary.record((double)duration);
    }
}

