/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.metrics.MetricService;

@Service
public class ModelMetricService
extends MetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelMetricService.class);
    private final Counter modelsAllCounter;
    private final Counter modelsSuccessfulCounter;
    private final Counter modelsFailedCounter;
    private final DistributionSummary modelsDurationAllSummary;
    private final DistributionSummary modelsDurationSuccessfulSummary;
    private final DistributionSummary modelsDurationFailedSummary;
    private final Map<UUID, Counter> tenantIdToAllModelsCounterMap;
    private final Map<UUID, Counter> tenantIdToSuccessfulModelsCounterMap;
    private final Map<UUID, Counter> tenantIdToFailedModelsCounterMap;
    private final Map<UUID, DistributionSummary> tenantIdToModelsDurationAllSummaryMap;
    private final Map<UUID, DistributionSummary> tenantIdToModelsDurationSuccessfulSummaryMap;
    private final Map<UUID, DistributionSummary> tenantIdToModelsDurationFailedSummaryMap;

    @Autowired
    public ModelMetricService(MeterRegistry meterRegistry, UserManagementService userManagementService) {
        super(meterRegistry, userManagementService);
        this.modelsAllCounter = Counter.builder((String)"trendz.models.count.all").description("How many model builds were started").baseUnit("Models").tag("tenant", "All").tag("tenant_name", "All").tag("customer", "All").tag("customer_name", "All").register(this.meterRegistry);
        this.modelsSuccessfulCounter = Counter.builder((String)"trendz.models.count.successful").description("How many model builds were finished successful").baseUnit("Models").tag("tenant", "All").tag("tenant_name", "All").tag("customer", "All").tag("customer_name", "All").register(this.meterRegistry);
        this.modelsFailedCounter = Counter.builder((String)"trendz.models.count.failed").description("How many model builds were failed").baseUnit("Models").tag("tenant", "All").tag("tenant_name", "All").tag("customer", "All").tag("customer_name", "All").register(this.meterRegistry);
        this.modelsDurationAllSummary = DistributionSummary.builder((String)"trendz.models.duration.all").description("Duration of each of all models build").baseUnit("Millis").tag("tenant", "All").tag("tenant_name", "All").tag("customer", "All").tag("customer_name", "All").register(this.meterRegistry);
        this.modelsDurationSuccessfulSummary = DistributionSummary.builder((String)"trendz.models.duration.successful").description("Duration of each of successful models build").baseUnit("Millis").tag("tenant", "All").tag("tenant_name", "All").tag("customer", "All").tag("customer_name", "All").register(this.meterRegistry);
        this.modelsDurationFailedSummary = DistributionSummary.builder((String)"trendz.models.duration.failed").description("Duration of each of failed models build").baseUnit("Millis").tag("tenant", "All").tag("tenant_name", "All").tag("customer", "All").tag("customer_name", "All").register(this.meterRegistry);
        this.tenantIdToAllModelsCounterMap = new ConcurrentHashMap();
        this.tenantIdToSuccessfulModelsCounterMap = new ConcurrentHashMap();
        this.tenantIdToFailedModelsCounterMap = new ConcurrentHashMap();
        this.tenantIdToModelsDurationAllSummaryMap = new ConcurrentHashMap();
        this.tenantIdToModelsDurationSuccessfulSummaryMap = new ConcurrentHashMap();
        this.tenantIdToModelsDurationFailedSummaryMap = new ConcurrentHashMap();
    }

    protected String getMetricPrefix() {
        return super.getMetricPrefix() + "models.";
    }

    public void incrementAllModelsBuild(JwtSecurityUser user) {
        this.modelsAllCounter.increment();
        this.tenantIdToAllModelsCounterMap.computeIfAbsent(user.getTenantId(), key -> Counter.builder((String)(this.getMetricPrefix() + "count.all")).description("How many model builds were started").baseUnit("Models").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry)).increment();
    }

    public void incrementSuccessfulModelsBuild(JwtSecurityUser user) {
        this.modelsSuccessfulCounter.increment();
        this.tenantIdToSuccessfulModelsCounterMap.computeIfAbsent(user.getTenantId(), key -> Counter.builder((String)(this.getMetricPrefix() + "count.successful")).description("How many model builds were successful").baseUnit("Models").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry)).increment();
    }

    public void incrementFailedModelsBuild(JwtSecurityUser user) {
        this.modelsFailedCounter.increment();
        this.tenantIdToFailedModelsCounterMap.computeIfAbsent(user.getTenantId(), key -> Counter.builder((String)(this.getMetricPrefix() + "count.failed")).description("How many model builds were failed").baseUnit("Models").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry)).increment();
    }

    public void recordSuccessfulReportDuration(JwtSecurityUser user, long duration) {
        DistributionSummary summaryAllByTenant = this.tenantIdToModelsDurationAllSummaryMap.computeIfAbsent(user.getTenantId(), key -> DistributionSummary.builder((String)(this.getMetricPrefix() + "duration.all")).description("Duration of each of all models build").baseUnit("Millis").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry));
        DistributionSummary summarySuccessfulByTenant = this.tenantIdToModelsDurationSuccessfulSummaryMap.computeIfAbsent(user.getTenantId(), key -> DistributionSummary.builder((String)(this.getMetricPrefix() + "duration.successful")).description("Duration of each of successful models build").baseUnit("Millis").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry));
        this.modelsDurationAllSummary.record((double)duration);
        this.modelsDurationSuccessfulSummary.record((double)duration);
        summaryAllByTenant.record((double)duration);
        summarySuccessfulByTenant.record((double)duration);
    }

    public void recordFailedReportDuration(JwtSecurityUser user, long duration) {
        DistributionSummary summaryAllByTenant = this.tenantIdToModelsDurationAllSummaryMap.computeIfAbsent(user.getTenantId(), key -> DistributionSummary.builder((String)(this.getMetricPrefix() + "duration.all")).description("Duration of each of all models build").baseUnit("Millis").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry));
        DistributionSummary summaryFailedByTenant = this.tenantIdToModelsDurationFailedSummaryMap.computeIfAbsent(user.getTenantId(), key -> DistributionSummary.builder((String)(this.getMetricPrefix() + "duration.failed")).description("Duration of each of failed models build").baseUnit("Millis").tag("tenant", this.getTenantId(user)).tag("tenant_name", this.getTenantName(user)).tag("customer", this.getCustomerId(user)).tag("customer_name", this.getCustomerName(user)).register(this.meterRegistry));
        this.modelsDurationAllSummary.record((double)duration);
        this.modelsDurationFailedSummary.record((double)duration);
        summaryAllByTenant.record((double)duration);
        summaryFailedByTenant.record((double)duration);
    }
}

