/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutorManagementMetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorManagementMetricService.class);
    private List<Gauge> gaugeQueueSizeList = new ArrayList();
    private List<Gauge> gaugeActiveCountList = new ArrayList();
    private List<Gauge> gaugePoolSizeList = new ArrayList();
    private final MeterRegistry meterRegistry;

    @Autowired
    public ExecutorManagementMetricService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    private String getMetricPrefix() {
        return "trendz.executor.";
    }

    public void initializeServiceGauges(ThreadPoolExecutor service, String label) {
        Gauge gaugeQueueSize = Gauge.builder((String)(this.getMetricPrefix() + label + ".queue.size"), (Object)service, i -> i.getQueue().size()).description("The task queue size used by this executor").baseUnit("Tasks in queue").register(this.meterRegistry);
        Gauge gaugeActiveCount = Gauge.builder((String)(this.getMetricPrefix() + label + ".active.count"), (Object)service, ThreadPoolExecutor::getActiveCount).description("Approximate number of threads that are actively executing tasks").baseUnit("Executing tasks").register(this.meterRegistry);
        Gauge gaugePoolSize = Gauge.builder((String)(this.getMetricPrefix() + label + ".pool.size"), (Object)service, ThreadPoolExecutor::getPoolSize).description("The current number of threads in the pool").baseUnit("Threads").register(this.meterRegistry);
        this.gaugeQueueSizeList.add(gaugeQueueSize);
        this.gaugeActiveCountList.add(gaugeActiveCount);
        this.gaugePoolSizeList.add(gaugePoolSize);
        log.debug("The thread pool executor with label \"{}\" is registered", (Object)label);
    }
}

