/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item.configmaker;

import java.time.ZoneId;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.domain.metric.item.pattern.TimePatternGroupingConfig;
import org.thingsboard.trendz.domain.metric.item.pattern.TimePatternGroupingType;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.item.configmaker.TimePatternConfigMaker;

@Service
public class HeatmapCalendarTimePatternConfigMaker
extends TimePatternConfigMaker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeatmapCalendarTimePatternConfigMaker.class);

    @Autowired
    public HeatmapCalendarTimePatternConfigMaker(BusinessEntityService businessEntityService) {
        super(businessEntityService);
    }

    public TimePatternGroupingType getType() {
        return TimePatternGroupingType.HEATMAP_CALENDAR;
    }

    public ViewConfig makeViewConfig(JwtSecurityUser user, TimePatternGroupingConfig config, UUID entityFieldId, ItemLite itemLite, ZoneId zoneId) {
        ViewConfig viewConfig = super.makeTemplateConfig(user, config, entityFieldId, itemLite, zoneId);
        this.addDateField(viewConfig, DateAggregationType.RAW);
        this.setViewType(viewConfig, ViewType.HEATMAP_CALENDAR);
        DatePickerConfig datePickerConfig = viewConfig.getDatePickerConfig();
        datePickerConfig.setRangeBy(DatePickerConfigSelectType.Value.day.name());
        return viewConfig;
    }
}

