/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.entity.metadata.RangeConfig;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.definition.view.config.StateProperty;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.domain.metric.item.range.RangeConfigBuildRequest;
import org.thingsboard.trendz.domain.metric.item.range.RangeConfigBuildResponse;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.item.ItemMetricRangeConfigService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.TsData;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.ViewReportBuildJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.BusinessEntityUtils;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.ViewConfigUtils;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ItemMetricRangeConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItemMetricRangeConfigService.class);
    private static final List<String> NAMES_FOR_RANGES = List.of("Low", "Medium", "High");
    private static final String SINGLE_NAME = "Constant";
    private final BusinessEntityService businessEntityService;
    private final TaskService taskService;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public ItemMetricRangeConfigService(BusinessEntityService businessEntityService, TaskService taskService, TbRestDataSource tbRestDataSource) {
        this.businessEntityService = businessEntityService;
        this.taskService = taskService;
        this.tbRestDataSource = tbRestDataSource;
    }

    public RangeConfig getDefault(UUID entityFieldId, JwtSecurityUser user, DatePickerConfig datePickerConfig, ZoneId zoneId, UUID itemId) {
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, entityFieldId);
        if (entityField.getType() != FieldType.NUMERIC && entityField.getType() != FieldType.DATE) {
            throw new TrendzInternalException("Impossible to retrieve range config for entity field: " + String.valueOf(entityField.getId()));
        }
        long now = System.currentTimeMillis();
        TimeRange timeRange = datePickerConfig.buildStartEndPair(zoneId, now);
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, entityField.getBusinessEntityId());
        DoubleSummaryStatistics summaryStatistics = this.loadTelemetry(entityField.getQuery().getKey(), businessEntity.getQuery().getEntityType(), itemId, user, timeRange).stream().map(TsData::getValue).mapToDouble(Double::parseDouble).summaryStatistics();
        if (summaryStatistics.getMin() == summaryStatistics.getMax()) {
            RangeConfig.Node node = RangeConfig.Node.builder().min(summaryStatistics.getMin()).max(this.getMaxForSingleStateConfig(summaryStatistics.getMin())).name("Constant").build();
            return RangeConfig.builder().nodes(List.of(node)).stateProperty(StateProperty.DURATION).build();
        }
        int rangeCount = NAMES_FOR_RANGES.size();
        double min = summaryStatistics.getMin();
        double max = summaryStatistics.getMax();
        double step = (max - min) / (double)rangeCount;
        ArrayList<RangeConfig.Node> nodes = new ArrayList<RangeConfig.Node>();
        for (int i = 0; i < rangeCount; ++i) {
            double currentMin = ItemMetricRangeConfigService.smartRound((double)(min + step * (double)i));
            double currentMax = ItemMetricRangeConfigService.smartRound((double)(min + step * (double)(i + 1)));
            RangeConfig.Node node = RangeConfig.Node.builder().name((String)NAMES_FOR_RANGES.get(i)).min(currentMin).max(currentMax).build();
            nodes.add(node);
        }
        RangeConfig.Node lastNode = (RangeConfig.Node)nodes.get(rangeCount - 1);
        lastNode.setMax(ItemMetricRangeConfigService.smartRound((double)(max + 1.0)));
        return new RangeConfig(StateProperty.DURATION, nodes);
    }

    public RangeConfigBuildResponse triggerRangeConfigBuild(JwtSecurityUser user, RangeConfigBuildRequest request) {
        ViewReportBuildJob chartJob = ViewReportBuildJob.builder().viewConfig(this.createViewConfigForChart(user, request)).build();
        ViewReportBuildJob cardsJob = ViewReportBuildJob.builder().viewConfig(this.createViewConfigForCards(user, request)).build();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_BUILD_VIEW, user.getTenantCustomerKey());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference, true).orElseThrow(() -> new TaskNotFoundException(reference));
        UUID chartExecutionId = this.taskService.runExecution(user, task.getId(), (TaskJob)chartJob, false, true);
        UUID cardsExecutionId = this.taskService.runExecution(user, task.getId(), (TaskJob)cardsJob, false, true);
        return RangeConfigBuildResponse.builder().chartExecutionId(chartExecutionId).cardsExecutionId(cardsExecutionId).build();
    }

    private ViewConfig createViewConfigForChart(JwtSecurityUser user, RangeConfigBuildRequest request) {
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, request.getEntityFieldId());
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, entityField.getBusinessEntityId());
        ViewConfig viewConfig = this.createBaseViewConfig(user, request, businessEntity);
        HashMap<String, BooleanNode> settings = new HashMap<String, BooleanNode>();
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$ViewType[request.getViewType().ordinal()]) {
            case 1: {
                settings.put("barStacked", BooleanNode.valueOf((boolean)true));
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalStateException("View Type: " + String.valueOf(request.getViewType()) + " is unsupported for Range Config Build.");
            }
        }
        viewConfig.setName("Ranges for %s %s (%s Chart)".formatted(businessEntity.getName(), entityField.getName(), this.toCamelCase(request.getViewType().name())));
        viewConfig.setViewType(request.getViewType());
        viewConfig.setSettings((JsonNode)new ObjectNode(JsonNodeFactory.instance, settings));
        ViewConfigUtils.addDateField((ViewConfig)viewConfig, (DateAggregationType)request.getAggregationType(), (String)"Date Aggregation (%s)".formatted(request.getAggregationType()));
        viewConfig.getYAxis().addAll(this.mapRangeConfigToViewFields(request.getRangeConfig(), businessEntity, entityField));
        return viewConfig;
    }

    private ViewConfig createViewConfigForCards(JwtSecurityUser user, RangeConfigBuildRequest request) {
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, request.getEntityFieldId());
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, entityField.getBusinessEntityId());
        ViewConfig viewConfig = this.createBaseViewConfig(user, request, businessEntity);
        viewConfig.setName("Ranges for %s %s (Cards)".formatted(businessEntity.getName(), entityField.getName()));
        viewConfig.setViewType(ViewType.TABLE);
        viewConfig.getXAxis().addAll(this.mapRangeConfigToViewFields(request.getRangeConfig(), businessEntity, entityField));
        return viewConfig;
    }

    private ViewConfig createBaseViewConfig(JwtSecurityUser user, RangeConfigBuildRequest request, BusinessEntity businessEntity) {
        BusinessEntityField nameField = BusinessEntityUtils.findNameField((BusinessEntity)businessEntity, (JwtSecurityUser)user);
        ViewConfig viewConfig = new ViewConfig();
        long now = System.currentTimeMillis();
        viewConfig.setDatePickerConfig(request.getDatePickerConfig());
        viewConfig.setTzName(request.getTzName());
        viewConfig.setDatasetEnableMap(new HashMap());
        viewConfig.setDatasetItemMap(new HashMap());
        viewConfig.setDatasetDataMap(new HashMap());
        viewConfig.setTenantId(user.getTenantId());
        viewConfig.setCustomerId(user.getCustomerId());
        viewConfig.setCreatedAt(now);
        viewConfig.setUpdatedAt(now);
        ViewConfigUtils.addItemFilter((BusinessEntityField)nameField, (ViewConfig)viewConfig, (ItemLite)request.getItemLite(), (String)"%s name".formatted(nameField.getName()));
        return viewConfig;
    }

    private double getMaxForSingleStateConfig(double min) {
        return min == 0.0 ? 1.0 : min + Math.abs(min) / 1000.0;
    }

    private String toCamelCase(String input) {
        String lower = input.toLowerCase();
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    private List<ViewField> mapRangeConfigToViewFields(RangeConfig rangeConfig, BusinessEntity businessEntity, BusinessEntityField entityField) {
        List<ViewField> viewFields = rangeConfig.getNodes().stream().map(node -> this.mapRangeNodeToViewField(node, businessEntity, entityField, rangeConfig.getStateProperty())).toList();
        log.trace("ViewFields: {}", viewFields.stream().map(ViewField::getLabel).toList());
        return viewFields;
    }

    private ViewField mapRangeNodeToViewField(RangeConfig.Node node, BusinessEntity businessEntity, BusinessEntityField entityField, StateProperty stateProperty) {
        ViewField viewField = new ViewField();
        viewField.setId(UUID.randomUUID());
        viewField.setStateField(true);
        viewField.setLabel(node.getName());
        viewField.setStateProperty(stateProperty);
        viewField.setScriptLanguage(ScriptLanguage.JS);
        viewField.setAggregationType(FieldAggregation.SUM);
        viewField.setStateCondition("var okRate = none(%s.%s);\nreturn %s <= okRate && okRate < %s;".formatted(businessEntity.getName(), entityField.getName(), node.getMin(), node.getMax()));
        return viewField;
    }

    private List<TsData> loadTelemetry(String key, BusinessEntityType entityType, UUID itemId, JwtSecurityUser user, TimeRange timeRange) {
        Mono request = this.tbRestDataSource.loadTelemetry(user, entityType, itemId, key, timeRange.getStartTs(), timeRange.getEndTs()).map(map -> map.getOrDefault(key, Collections.emptyList()));
        return (List)DonReactive.block((Mono)request);
    }

    public static double smartRound(double value) {
        int scale;
        if (value == 0.0) {
            return 0.0;
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        BigDecimal abs = bd.abs();
        if (abs.compareTo(BigDecimal.ONE) >= 0) {
            BigDecimal rounded = bd.setScale(2, RoundingMode.HALF_UP);
            double d = rounded.doubleValue();
            return d == -0.0 ? 0.0 : d;
        }
        BigDecimal s = abs.stripTrailingZeros();
        int precision = s.precision();
        int exponent = precision - (scale = s.scale()) - 1;
        int targetScale = Math.max(0, -exponent + 2);
        BigDecimal rounded = bd.setScale(targetScale, RoundingMode.HALF_UP);
        double d = rounded.doubleValue();
        return d == -0.0 ? 0.0 : d;
    }
}

