/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.item;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.domain.metric.item.AttributeDetails;
import org.thingsboard.trendz.domain.metric.item.ItemDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.BooleanTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.CountPercentPair;
import org.thingsboard.trendz.domain.metric.item.telemetry.DateTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.HistogramNumericStats;
import org.thingsboard.trendz.domain.metric.item.telemetry.NumericTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.StringTelemetryDetails;
import org.thingsboard.trendz.domain.metric.item.telemetry.TelemetryDetails;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class ItemDetailsMapper {
    public String mapToString(ItemDetails itemDetails) {
        String template = "Current datetime: %s\n%s\n%s\n\nList of attributes:\n%s\n\nList of telemetries:\n%s\n";
        return template.formatted(this.mapLongToDate(System.currentTimeMillis()), this.createTitle(itemDetails), this.createItemInfo(itemDetails), this.createAttributesList(itemDetails.getAttributeDetails()), this.createTelemetriesList(itemDetails.getTelemetryDetails()));
    }

    public String mapTelemetryDetailsToString(TelemetryDetails telemetryDetails, TestResult testResult) {
        if (testResult.getResult() != null && testResult.getResult().isEmpty()) {
            return "\n\t\tEmpty response";
        }
        if (telemetryDetails == null) {
            return "\n\t\tError: %s".formatted(testResult.getError());
        }
        return this.createTelemetryRaw(telemetryDetails);
    }

    private String createTitle(ItemDetails itemDetails) {
        Object title = "%s profile: \"%s\"".formatted(itemDetails.getItemType(), itemDetails.getItemProfileName());
        if (itemDetails.getItemProfileDescription() != null && !itemDetails.getItemProfileDescription().isEmpty()) {
            title = (String)title + ": %s".formatted(itemDetails.getItemProfileDescription());
        }
        return title;
    }

    private String createItemInfo(ItemDetails itemDetails) {
        Object itemInfo = "%s name: \"%s\"".formatted(itemDetails.getItemType(), itemDetails.getItemName());
        if (itemDetails.getItemLabel() != null && !itemDetails.getItemLabel().isEmpty()) {
            itemInfo = (String)itemInfo + ": %s".formatted(itemDetails.getItemLabel());
        }
        return itemInfo;
    }

    private String createAttributesList(List<AttributeDetails> attributeData) {
        return attributeData.stream().map(arg_0 -> this.createAttributeRaw(arg_0)).collect(Collectors.joining("\n"));
    }

    private String createAttributeRaw(AttributeDetails attributeData) {
        Object attributeRaw = "\t%s".formatted(attributeData.getName());
        if (attributeData.getDescription() != null && !attributeData.getDescription().isEmpty()) {
            attributeRaw = (String)attributeRaw + ": %s".formatted(attributeData.getDescription());
        }
        attributeRaw = (String)attributeRaw + "\n\t\tScope: %s".formatted(attributeData.getScope());
        attributeRaw = (String)attributeRaw + "\n\t\tAttribute key: %s".formatted(attributeData.getKey());
        attributeRaw = (String)attributeRaw + "\n\t\tUniq key (field identifier): \"%s\"".formatted(attributeData.uniqKey());
        attributeRaw = (String)attributeRaw + "\n\t\tType: %s".formatted(attributeData.getFieldType().name());
        attributeRaw = (String)attributeRaw + "\n\t\tValue: \"%s\"".formatted(attributeData.getData());
        return attributeRaw;
    }

    private String createTelemetriesList(List<TelemetryDetails> telemetryData) {
        return telemetryData.stream().map(arg_0 -> this.createTelemetryRaw(arg_0)).collect(Collectors.joining("\n"));
    }

    private String createTelemetryRaw(TelemetryDetails telemetryDetails) {
        StringBuilder telemetryRaw = new StringBuilder();
        if (telemetryDetails.getKey() != null) {
            telemetryRaw.append("\t%s".formatted(telemetryDetails.getName()));
            if (telemetryDetails.getDescription() != null && !telemetryDetails.getDescription().isEmpty()) {
                telemetryRaw.append(": %s".formatted(telemetryDetails.getDescription()));
            }
            telemetryRaw.append("\n\t\tTelemetry key: \"%s\"".formatted(telemetryDetails.getKey())).append("\n\t\tUniq key (field identifier): \"%s\"".formatted(telemetryDetails.uniqKey()));
        }
        telemetryRaw.append("\n\t\tAvg interval between values: %s".formatted(this.mapDuration(telemetryDetails.getAvgInterval()))).append("\n\t\tFirst telemetry point datetime: %s".formatted(this.mapLongToDate(telemetryDetails.getFirstTelemetryTs()))).append("\n\t\tLast telemetry point datetime: %s".formatted(this.mapLongToDate(telemetryDetails.getLastTelemetryTs()))).append("\n\t\tTotal count of telemetry points: %s".formatted(telemetryDetails.getCount()));
        if (telemetryDetails instanceof StringTelemetryDetails) {
            StringTelemetryDetails stringTelemetryDetails = (StringTelemetryDetails)telemetryDetails;
            telemetryRaw.append("\n\t\tType: STRING").append(this.mapTopValuesToString(stringTelemetryDetails.getTopValues()));
        } else if (telemetryDetails instanceof NumericTelemetryDetails) {
            NumericTelemetryDetails numericData = (NumericTelemetryDetails)telemetryDetails;
            telemetryRaw.append("\n\t\tType: NUMERIC").append("\n\t\tLast vale: %s".formatted(numericData.getLastValue())).append("\n\t\tMax value: %s".formatted(numericData.getMaxValue())).append("\n\t\tAvg value: %s".formatted(numericData.getAvgValue())).append("\n\t\tMin value: %s".formatted(numericData.getMinValue())).append(this.mapHistogramToString(numericData.getHistogramNumericStats()));
        } else if (telemetryDetails instanceof BooleanTelemetryDetails) {
            BooleanTelemetryDetails booleanData = (BooleanTelemetryDetails)telemetryDetails;
            telemetryRaw.append("\n\t\tType: BOOLEAN").append("\n\t\tLast value: %s".formatted(booleanData.isLastValue()));
            String statsBlock = "\t\tStats:\n\t\t\t%s stats:\n\t\t\t\tCount: %s\n\t\t\t\tPercent: %s%%\n";
            CountPercentPair falseStats = booleanData.getFalseStats();
            CountPercentPair trueStats = booleanData.getTrueStats();
            telemetryRaw.append(statsBlock.formatted("False", falseStats.getCount(), falseStats.getPercent())).append(statsBlock.formatted("True", trueStats.getCount(), trueStats.getPercent()));
        } else if (telemetryDetails instanceof DateTelemetryDetails) {
            telemetryRaw.append("\n\t\tType: DATE");
        }
        return telemetryRaw.toString();
    }

    private String mapLongToDate(long ts) {
        if (ts < 10000000000L) {
            ts *= 1000L;
        }
        ZonedDateTime zonedDateTime = DateTimeUtils.fromTs((long)ts, (ZoneId)ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE, MMMM dd, yyyy HH:mm:ss");
        return zonedDateTime.format(formatter);
    }

    private String mapDuration(long durationMillis) {
        return durationMillis >= 0L ? DurationFormatUtils.formatDuration((long)durationMillis, (String)"d'd' H'h' m'm' s's'", (boolean)false) : "Not enough data (one point)";
    }

    private String mapTopValuesToString(Map<String, CountPercentPair> topValues) {
        String blockTemplate = "\t\t\tValue: \"%s\"\n\t\t\tCount: %s\n\t\t\tPercent: %s%%\n\n";
        String statsInOrder = topValues.entrySet().stream().sorted(Comparator.comparingLong(e -> ((CountPercentPair)e.getValue()).getCount()).reversed()).map(e -> blockTemplate.formatted(e.getKey(), ((CountPercentPair)e.getValue()).getCount(), ((CountPercentPair)e.getValue()).getPercent())).collect(Collectors.joining());
        return "\t\tTop values:\n%s\n".formatted(statsInOrder);
    }

    private String mapHistogramToString(HistogramNumericStats stats) {
        String blockTemplate = "\t\t\tRange (Percents) %s%% - %s%%\n\t\t\tMin on range: %s\n\t\t\tMax on range: %s\n\n";
        int totalSize = 100;
        int baseSize = totalSize / stats.getBinsCount();
        int remainder = totalSize % stats.getBinsCount();
        List<Integer> percents = IntStream.range(0, stats.getBinsCount()).map(i -> baseSize + (i < remainder ? 1 : 0)).boxed().toList();
        ArrayList<String> blocks = new ArrayList<String>();
        int to = 0;
        for (int i2 = 0; i2 < stats.getBinsCount(); ++i2) {
            int from = to;
            double max = ((HistogramNumericStats.Item)stats.getItems().get(i2)).getMaxValue();
            double min = ((HistogramNumericStats.Item)stats.getItems().get(i2)).getMinValue();
            blocks.add(blockTemplate.formatted(from, to += percents.get(i2).intValue(), min, max));
        }
        return "\n\t\tHistogram:\n%s\n".formatted(String.join((CharSequence)"", blocks));
    }
}

