/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.assistance;

import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.ErrorMetadata;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceContext;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceResponse;
import org.thingsboard.trendz.service.metric.agent.developer.PythonDeveloperExpertAgent;
import org.thingsboard.trendz.service.metric.agent.input.MetricBusinessAnalystExpertAgent;
import org.thingsboard.trendz.service.metric.agent.input.domain.MetricBusinessAnalystExpertResult;
import org.thingsboard.trendz.service.metric.agent.memorymanager.MetricMemoryManagerExpertAgent;
import org.thingsboard.trendz.service.metric.agent.memorymanager.domain.MetricMemoryManagerExpertResult;
import org.thingsboard.trendz.service.metric.agent.output.MetricOutputExpertAgent;
import org.thingsboard.trendz.service.metric.agent.output.domain.MetricOutputExpertResult;
import org.thingsboard.trendz.service.metric.item.ItemDetailsService;
import org.thingsboard.trendz.service.metric.topology.TopologyDetailsService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;

@Service
public class MetricCodeAssistanceSupervisor {
    private final ItemDetailsService itemDetailsService;
    private final TopologyDetailsService topologyDetailsService;
    private final MetricMemoryManagerExpertAgent metricMemoryManagerExpertAgent;
    private final MetricBusinessAnalystExpertAgent metricBusinessAnalystExpertAgent;
    private final PythonDeveloperExpertAgent pythonDeveloperExpertAgent;
    private final MetricOutputExpertAgent metricOutputExpertAgent;

    @Autowired
    public MetricCodeAssistanceSupervisor(ItemDetailsService itemDetailsService, TopologyDetailsService topologyDetailsService, MetricMemoryManagerExpertAgent metricMemoryManagerExpertAgent, MetricBusinessAnalystExpertAgent metricBusinessAnalystExpertAgent, PythonDeveloperExpertAgent pythonDeveloperExpertAgent, MetricOutputExpertAgent metricOutputExpertAgent) {
        this.itemDetailsService = itemDetailsService;
        this.topologyDetailsService = topologyDetailsService;
        this.metricMemoryManagerExpertAgent = metricMemoryManagerExpertAgent;
        this.pythonDeveloperExpertAgent = pythonDeveloperExpertAgent;
        this.metricBusinessAnalystExpertAgent = metricBusinessAnalystExpertAgent;
        this.metricOutputExpertAgent = metricOutputExpertAgent;
    }

    public MetricCodeAssistanceResponse process(TaskExecutionProgressStepBuilder stepBuilder, MetricCodeAssistanceContext context) {
        MetricMemoryManagerExpertResult memoryManagerExpertResult;
        String itemDetails;
        String topologyDetails = this.topologyDetailsService.mapWideTopologyForItem(context.getBusinessEntity().getId(), context.getUser());
        MetricBusinessAnalystExpertResult businessAnalystExpertResult = (MetricBusinessAnalystExpertResult)this.processAgent(context, () -> this.lambda$process$1(context, topologyDetails, itemDetails = this.itemDetailsService.loadItemDetailsAsString(context.getUser(), context.getBusinessEntity(), context.getItemId(), context.getDatePickerConfig(), context.getZoneId()), memoryManagerExpertResult = (MetricMemoryManagerExpertResult)this.processAgent(context, () -> this.metricMemoryManagerExpertAgent.aggregateMemory(context), AiAgentType.METRIC_MEMORY_MANAGER_EXPERT)), AiAgentType.METRIC_BUSINESS_ANALYST_EXPERT);
        String source = businessAnalystExpertResult.isUseRelations() ? topologyDetails : itemDetails;
        TestResult newTestResult = (TestResult)this.processAgent(context, () -> this.pythonDeveloperExpertAgent.calculateMetric(stepBuilder, context, businessAnalystExpertResult, source), AiAgentType.PYTHON_DEVELOPER_SENIOR_EXPERT);
        MetricOutputExpertResult outputExpertResult = (MetricOutputExpertResult)this.processAgent(context, () -> this.metricOutputExpertAgent.makeAnswerForUser(context, newTestResult, memoryManagerExpertResult, businessAnalystExpertResult), AiAgentType.METRIC_OUTPUT_EXPERT);
        ErrorMetadata errorMetadata = ErrorMetadata.builder().failedAgent(AiAgentType.METRIC_OUTPUT_EXPERT).comment(outputExpertResult.getAnswer()).build();
        return MetricCodeAssistanceResponse.builder().errorMetadata(errorMetadata).task(memoryManagerExpertResult.getTask()).modified(businessAnalystExpertResult.getNewMetricDefinition()).testResult(newTestResult).agentMetadataList(context.getAgentMetadataContainer()).allRequirements(memoryManagerExpertResult.getRequirementList()).build();
    }

    private <T> T processAgent(MetricCodeAssistanceContext context, Supplier<T> agent, AiAgentType aiAgentType) {
        context.getProgressContent().updateContent(aiAgentType);
        return (T)context.getStepBuilder().makeStep(aiAgentType.name(), agent);
    }

    private /* synthetic */ MetricBusinessAnalystExpertResult lambda$process$1(MetricCodeAssistanceContext context, String topologyDetails, String itemDetails, MetricMemoryManagerExpertResult memoryManagerExpertResult) {
        return this.metricBusinessAnalystExpertAgent.analyze(context, topologyDetails, itemDetails, memoryManagerExpertResult.getTask());
    }
}

