/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric.agent.memorymanager;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.chat.ChatMessageLite;
import org.thingsboard.trendz.domain.metric.assistance.MetricCodeAssistanceContext;
import org.thingsboard.trendz.service.metric.agent.MetricExplorerAiService;
import org.thingsboard.trendz.service.metric.agent.memorymanager.domain.MetricMemoryManagerExpertResponse;
import org.thingsboard.trendz.service.metric.agent.memorymanager.domain.MetricMemoryManagerExpertResult;

@Service
public class MetricMemoryManagerExpertAgent {
    private static final String FIRST_AI_MESSAGE = "I'm here to help you implement the metric.\n\nI can help you with:\n- Debugging your Python code\n- Explaining calculation logic\n- Optimizing performance\n- Handling edge case\n\nWhat would you like assistance with?\n";
    private final MetricExplorerAiService metricExplorerAiService;

    @Autowired
    public MetricMemoryManagerExpertAgent(MetricExplorerAiService metricExplorerAiService) {
        this.metricExplorerAiService = metricExplorerAiService;
    }

    public MetricMemoryManagerExpertResult aggregateMemory(MetricCodeAssistanceContext context) {
        MetricMemoryManagerExpertResponse response = this.metricExplorerAiService.aggregateMemory(context.getUser(), context.getAgentMetadataContainer(), context.getRequirementList(), this.mapHistory(context.getHistory()), context.getQuestion(), context.getChatSummary());
        context.setChatSummary(response.getChatSummary());
        return MetricMemoryManagerExpertResult.builder().task(response.getTask()).chatSummary(response.getChatSummary()).requirementList(response.getRequirementList()).build();
    }

    private List<String> mapHistory(List<ChatMessageLite> chatMessageLites) {
        ArrayList<String> history = new ArrayList<String>(chatMessageLites.size() * 2 + 1);
        history.add(FIRST_AI_MESSAGE);
        chatMessageLites.stream().flatMap(message -> Stream.of(message.getUserQuestion(), message.getAiAnswer())).forEach(history::add);
        return history;
    }
}

