/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.exception.service.script.engine.PythonExecutorException;
import org.thingsboard.trendz.exception.service.script.engine.ScriptEngineException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.script.calculatedfield.ScriptCalculationService;

@Service
public class MetricPythonCalculationTester {
    private final ScriptCalculationService scriptCalculationService;

    @Autowired
    public MetricPythonCalculationTester(ScriptCalculationService scriptCalculationService) {
        this.scriptCalculationService = scriptCalculationService;
    }

    public TestResult test(DatePickerConfig datePickerConfig, ZoneId zoneId, BusinessEntityType entityType, MetricDefinition metricDefinition, JwtSecurityUser user) {
        UUID debugLogId = UUID.randomUUID();
        TimeRange timeRange = datePickerConfig.buildStartEndPair(zoneId, System.currentTimeMillis());
        List fieldValues = null;
        String error = null;
        boolean isSuccess = true;
        ArrayList logContainer = new ArrayList();
        try {
            fieldValues = this.scriptCalculationService.processNativeScript(user, metricDefinition.getItem().getId(), entityType, this.makeNativeCalculationViewField(metricDefinition.getBusinessEntityId(), debugLogId), ScriptLanguage.PYTHON, metricDefinition.getName(), metricDefinition.getCode(), timeRange.getStartTs(), timeRange.getEndTs(), "hour", zoneId, logContainer);
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)throwable;
                Throwable throwable2 = executionException.getCause();
                if (throwable2 instanceof ScriptEngineException) {
                    ScriptEngineException scriptEngineException = (ScriptEngineException)throwable2;
                    Throwable throwable3 = scriptEngineException.getCause();
                    if (throwable3 instanceof PythonExecutorException) {
                        PythonExecutorException pythonExecutorException = (PythonExecutorException)throwable3;
                        error = pythonExecutorException.getMessage();
                    } else {
                        error = scriptEngineException.getMessage();
                    }
                } else {
                    error = executionException.getMessage();
                }
            } else {
                error = e.getMessage();
            }
            isSuccess = false;
        }
        return TestResult.builder().error(error).logs(logContainer).valid(isSuccess).result(fieldValues).build();
    }

    private ViewField makeNativeCalculationViewField(UUID businessEntityId, UUID debugLogId) {
        ViewField viewField = new ViewField();
        viewField.setBusinessEntityId(businessEntityId);
        viewField.setScriptDebugLogId(debugLogId);
        return viewField;
    }
}

