/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.metric;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.metric.MetricDefinitionDao;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTimeRangeStrategy;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldType;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.domain.definition.view.config.ScriptLanguage;
import org.thingsboard.trendz.domain.manual.ManualDataset;
import org.thingsboard.trendz.domain.metric.CalculationCreationRequest;
import org.thingsboard.trendz.domain.metric.MetricCreationResult;
import org.thingsboard.trendz.domain.metric.MetricDefinition;
import org.thingsboard.trendz.domain.metric.MetricDefinitionCalculationStatus;
import org.thingsboard.trendz.domain.metric.MetricDefinitionCreationRequest;
import org.thingsboard.trendz.domain.metric.MetricDefinitionFilteringField;
import org.thingsboard.trendz.domain.metric.MetricDefinitionMetadata;
import org.thingsboard.trendz.domain.metric.MetricDefinitionModificationRequest;
import org.thingsboard.trendz.domain.metric.MetricDefinitionSortingField;
import org.thingsboard.trendz.domain.metric.MetricGenerationResult;
import org.thingsboard.trendz.domain.metric.TestResult;
import org.thingsboard.trendz.domain.metric.ai.MetricDefinitionAiLite;
import org.thingsboard.trendz.domain.metric.item.ItemDetails;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundException;
import org.thingsboard.trendz.exception.metric.MetricDefinitionWithoutCodeException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.agent.MetricExplorerAiService;
import org.thingsboard.trendz.service.metric.agent.developer.PythonDeveloperExpertAgent;
import org.thingsboard.trendz.service.metric.item.ItemDetailsMapper;
import org.thingsboard.trendz.service.metric.item.ItemDetailsService;
import org.thingsboard.trendz.service.metric.topology.TopologyDetailsService;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.progress_content.MetricDefinitionGenerateContent;
import org.thingsboard.trendz.service.view.proto.FillGapSettings;
import org.thingsboard.trendz.service.view.proto.FillGapStrategy;

@Service
public class MetricDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricDefinitionService.class);
    private final ItemDetailsService itemDetailsService;
    private final ItemDetailsMapper itemDetailsMapper;
    private final TopologyDetailsService topologyDetailsService;
    private final MetricExplorerAiService metricExplorerAiService;
    private final MetricDefinitionDao metricDefinitionDao;
    private final BusinessEntityService businessEntityService;
    private final CalculationFieldService calculationFieldService;
    private final PythonDeveloperExpertAgent pythonDeveloperExpertAgent;

    @Autowired
    public MetricDefinitionService(ItemDetailsService itemDetailsService, ItemDetailsMapper itemDetailsMapper, TopologyDetailsService topologyDetailsService, MetricExplorerAiService metricExplorerAiService, MetricDefinitionDao metricDefinitionDao, BusinessEntityService businessEntityService, CalculationFieldService calculationFieldService, PythonDeveloperExpertAgent pythonDeveloperExpertAgent) {
        this.itemDetailsService = itemDetailsService;
        this.itemDetailsMapper = itemDetailsMapper;
        this.topologyDetailsService = topologyDetailsService;
        this.metricExplorerAiService = metricExplorerAiService;
        this.metricDefinitionDao = metricDefinitionDao;
        this.businessEntityService = businessEntityService;
        this.calculationFieldService = calculationFieldService;
        this.pythonDeveloperExpertAgent = pythonDeveloperExpertAgent;
    }

    public MetricDefinition create(MetricDefinitionCreationRequest request, JwtSecurityUser user) {
        this.businessEntityService.findEntityById(user, request.getBusinessEntityId());
        long now = System.currentTimeMillis();
        MetricDefinition metricDefinition = MetricDefinition.builder().id(UUID.randomUUID()).tenantId(user.getTenantId()).customerId(user.getCustomerId()).businessEntityId(request.getBusinessEntityId()).item(request.getItemLite()).name(request.getName()).userInput("Created by user without AI.").description("Not Provided").howToCalculate("Not Provided").isAdvancedMode(true).isOutdated(false).autoDeletable(false).createdTs(now).build();
        return this.metricDefinitionDao.save(metricDefinition);
    }

    @TaskExecutionProgressDecorator(name="Manual definition generation")
    public MetricCreationResult create(TaskExecutionProgressStepBuilder stepBuilder, JwtSecurityUser user, UUID businessEntityId, UUID itemId, DatePickerConfig datePickerConfig, ZoneId zoneId, String name, String description, boolean advancedMode) {
        MetricDefinitionGenerateContent mutableContent = (MetricDefinitionGenerateContent)stepBuilder.getMutableContent();
        TaskExecutionProgressStepBuilder stepLoadMetadata = stepBuilder.makeStep("Prepare metadata");
        mutableContent.setState(MetricDefinitionGenerateContent.State.PREPARE_METADATA);
        ArrayList agentMetadataContainer = new ArrayList();
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, businessEntityId);
        stepLoadMetadata.close();
        TaskExecutionProgressStepBuilder stepLoadItemDetails = stepBuilder.makeStep("Load item details");
        mutableContent.setState(MetricDefinitionGenerateContent.State.LOAD_ITEM_DETAILS);
        Pair sourceItemPair = this.getSourceItemPair(businessEntity, user, itemId, datePickerConfig, zoneId, advancedMode);
        stepLoadItemDetails.close();
        MetricDefinitionAiLite aiLite = this.metricExplorerAiService.createMetricDefinition(stepBuilder, user, agentMetadataContainer, (String)sourceItemPair.getKey(), name, description, advancedMode);
        TaskExecutionProgressStepBuilder stepDefinitionMapping = stepBuilder.makeStep("Definition mapping");
        mutableContent.setState(MetricDefinitionGenerateContent.State.DEFINITION_MAPPING);
        MetricDefinition metricDefinition = aiLite.toData(user, businessEntityId, ((Item)sourceItemPair.getValue()).toLite());
        List fields = advancedMode ? this.mapFields(Collections.emptyMap(), user) : this.mapFields(aiLite.getUniqKeys(), businessEntity);
        metricDefinition.setName(name);
        metricDefinition.setUserInput(description);
        metricDefinition.setFields(fields);
        metricDefinition.setAdvancedMode(advancedMode);
        stepDefinitionMapping.close();
        TaskExecutionProgressStepBuilder stepTestMetric = stepBuilder.makeStep("Test Metric");
        TestResult testResult = this.pythonDeveloperExpertAgent.calculateMetric(stepBuilder, metricDefinition, user, (String)sourceItemPair.getKey(), businessEntity, agentMetadataContainer, datePickerConfig, zoneId, List.of("Implement metric definition"));
        stepTestMetric.close();
        this.metricDefinitionDao.save(metricDefinition);
        return MetricCreationResult.builder().testResult(testResult).metricDefinition(metricDefinition).agentMetadataContainer(agentMetadataContainer).build();
    }

    public void save(MetricDefinition metricDefinition) {
        this.metricDefinitionDao.save(metricDefinition);
    }

    public MetricDefinition modify(UUID metricDefinitionId, MetricDefinitionModificationRequest request, JwtSecurityUser user) {
        List<MetricDefinition.UseCase> useCases;
        MetricDefinition metricDefinition = this.getMetricDefinitionById(metricDefinitionId, user);
        boolean isModified = false;
        if (request.getName() != null && !request.getName().equals(metricDefinition.getName())) {
            metricDefinition.setName(request.getName());
            isModified = true;
        }
        if (request.getUserInput() != null && !request.getUserInput().equals(metricDefinition.getUserInput())) {
            metricDefinition.setUserInput(request.getUserInput());
            isModified = true;
        }
        if (request.getDescription() != null && !request.getDescription().equals(metricDefinition.getDescription())) {
            metricDefinition.setDescription(request.getDescription());
            isModified = true;
        }
        if (request.getHowToCalculate() != null && !request.getHowToCalculate().equals(metricDefinition.getHowToCalculate())) {
            metricDefinition.setHowToCalculate(request.getHowToCalculate());
            isModified = true;
        }
        if (request.getCode() != null && !request.getCode().equals(metricDefinition.getCode())) {
            metricDefinition.setCode(request.getCode());
            isModified = true;
        }
        if (request.getItem() != null && !request.getItem().equals((Object)metricDefinition.getItem())) {
            metricDefinition.setItem(request.getItem());
            isModified = true;
        }
        if (request.getAdvancedMode() != null && !request.getAdvancedMode().equals(metricDefinition.isAdvancedMode())) {
            metricDefinition.setAdvancedMode(request.getAdvancedMode().booleanValue());
            isModified = true;
        }
        if (request.getUseCases() != null && !(useCases = request.getUseCases().stream().map(MetricDefinition.UseCase::new).toList()).equals(metricDefinition.getUseCases())) {
            metricDefinition.setItem(request.getItem());
            isModified = true;
        }
        if (request.getFields() != null) {
            // empty if block
        }
        if (isModified) {
            this.metricDefinitionDao.save(metricDefinition);
        }
        return metricDefinition;
    }

    @TaskExecutionProgressDecorator(name="Automatic definition generation")
    public MetricGenerationResult generateMetricDefinitions(TaskExecutionProgressStepBuilder stepBuilder, JwtSecurityUser user, UUID businessEntityId, UUID itemId, DatePickerConfig datePickerConfig, ZoneId zoneId, int countSimple, int countAdvanced, String seed) {
        MetricDefinitionGenerateContent mutableContent = (MetricDefinitionGenerateContent)stepBuilder.getMutableContent();
        MetricGenerationResult mgr1 = this.generateMetricDefinitions(stepBuilder, user, businessEntityId, itemId, datePickerConfig, zoneId, countSimple, seed, false);
        MetricGenerationResult mgr2 = this.generateMetricDefinitions(stepBuilder, user, businessEntityId, itemId, datePickerConfig, zoneId, countAdvanced, seed, true);
        try (TaskExecutionProgressStepBuilder stepPostProcess = stepBuilder.makeStep("Post-processing");){
            mutableContent.setState(MetricDefinitionGenerateContent.State.POST_PROCESSING);
            MetricGenerationResult result = MetricGenerationResult.merge((MetricGenerationResult)mgr1, (MetricGenerationResult)mgr2);
            this.metricDefinitionDao.rewriteWith(result.getMetricDefinitions(), user, true);
            MetricGenerationResult metricGenerationResult = result;
            return metricGenerationResult;
        }
    }

    private MetricGenerationResult generateMetricDefinitions(TaskExecutionProgressStepBuilder stepBuilder, JwtSecurityUser user, UUID businessEntityId, UUID itemId, DatePickerConfig datePickerConfig, ZoneId zoneId, int count, String seed, boolean advancedMode) {
        MetricDefinitionGenerateContent mutableContent = (MetricDefinitionGenerateContent)stepBuilder.getMutableContent();
        MetricGenerationResult result = new MetricGenerationResult(new ArrayList(), new ArrayList());
        if (count <= 0) {
            return result;
        }
        try (TaskExecutionProgressStepBuilder stepGenerate = stepBuilder.makeStep(advancedMode ? "Generate advanced metrics" : "Generate simple metrics");){
            mutableContent.setState(advancedMode ? MetricDefinitionGenerateContent.State.GENERATE_ADVANCED_METRIC : MetricDefinitionGenerateContent.State.GENERATE_SIMPLE_METRIC);
            BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, businessEntityId);
            List recentMetadata = this.metricDefinitionDao.getRecentMetadata(user, businessEntityId, itemId, advancedMode, count * 3);
            Pair sourceItemPair = this.getSourceItemPair(businessEntity, user, itemId, datePickerConfig, zoneId, advancedMode);
            List aiResponses = this.metricExplorerAiService.generateMetricDefinitions(user, result.getAgentMetadataContainer(), (String)sourceItemPair.getKey(), count, seed, advancedMode, recentMetadata);
            List<MetricDefinition> metricDefinitions = aiResponses.stream().map(aiResponse -> aiResponse.toData(user, businessEntityId, ((Item)sourceItemPair.getValue()).toLite())).peek(metricDefinition -> metricDefinition.setAdvancedMode(advancedMode)).toList();
            result.setMetricDefinitions(metricDefinitions);
            MetricGenerationResult metricGenerationResult = result;
            return metricGenerationResult;
        }
    }

    public Page<MetricDefinition> getAllMetricDefinitions(int page, int pageSize, JwtSecurityUser user, List<MetricDefinitionFilteringField> filteringFields, List<MetricDefinitionSortingField> sortingFields) {
        return this.metricDefinitionDao.getAllMetricDefinitions(page, pageSize, user, filteringFields, sortingFields);
    }

    public List<MetricDefinition> getAllSavedByBusinessEntityId(UUID businessEntityId, JwtSecurityUser user) {
        return this.metricDefinitionDao.findAllSavedByBusinessEntityId(businessEntityId, user);
    }

    public List<MetricDefinition> getAllMetricDefinitions(JwtSecurityUser user) {
        return this.metricDefinitionDao.getAllMetricDefinitions(user);
    }

    public List<MetricDefinition> importAllMetricDefinitions(List<MetricDefinition> newMetricDefinitions) {
        return this.metricDefinitionDao.saveAll(newMetricDefinitions);
    }

    public List<MetricDefinitionMetadata> importAllMetricDefinitionMetadata(List<MetricDefinitionMetadata> newMetricDefinitionMetadata) {
        return this.metricDefinitionDao.saveAllMetadata(newMetricDefinitionMetadata);
    }

    public List<MetricDefinitionMetadata> getAllMetricDefinitionMetadata(JwtSecurityUser securityUser) {
        return this.metricDefinitionDao.getAllMetadata(securityUser);
    }

    public MetricDefinition getMetricDefinitionById(UUID metricDefinitionId, JwtSecurityUser securityUser) {
        return this.metricDefinitionDao.findMetricDefinitionById(metricDefinitionId, securityUser);
    }

    public UUID createCalculationBasedOnMetricDefinition(UUID metricDefinitionId, JwtSecurityUser user, CalculationCreationRequest request) {
        MetricDefinition metricDefinition = this.getMetricDefinitionById(metricDefinitionId, user);
        if (metricDefinition.getCode() == null) {
            throw new MetricDefinitionWithoutCodeException(metricDefinitionId);
        }
        long now = System.currentTimeMillis();
        CalculationField calculationField = request.getCalculationId() == null ? CalculationField.builder().name(request.getCalculationName()).tbTelemetryKey(request.getCalculationKey()).fieldAggregation(request.getAggregation()).tenantId(user.getTenantId()).customerId(user.getCustomerId()).splitTimeRange(false).splitTimeRangeTimeUnit(DateAggregationUnit.MONTH).manualDataset(ManualDataset.builder().data(new HashMap()).build()).fillGapSettings(FillGapSettings.builder().enableFillGap(false).fillGapStrategy(FillGapStrategy.AVG).timeUnit(DateAggregationUnit.HOUR).build()).timeRangeStrategy(CalculationFieldTimeRangeStrategy.FIXED).fixedStrategyDatePicker(this.makeDatePickerForFixedStrategy(request.getDateGrouping())).groupingInterval(request.getDateGrouping()).creationTime(now).build() : (CalculationField)this.calculationFieldService.findById(user, request.getCalculationId()).orElseThrow(() -> new CalculationFieldNotFoundException(request.getCalculationId()));
        calculationField.setLanguage(ScriptLanguage.PYTHON);
        calculationField.setReturnDataType(FieldType.NUMERIC);
        calculationField.setBusinessEntityId(metricDefinition.getBusinessEntityId());
        calculationField.setCalculationFieldType(CalculationFieldType.NATIVE);
        calculationField.setScript(metricDefinition.getCode());
        calculationField.setUpdateTime(now);
        CalculationField saved = this.calculationFieldService.save(user, calculationField);
        if (request.getCalculationId() == null) {
            this.businessEntityService.findEntityByIdAsOptional(user, saved.getBusinessEntityId()).ifPresent(businessEntity -> businessEntity.getFields().stream().filter(i -> i.getId().equals(saved.getAssociatedEntityFieldId())).findAny().ifPresent(entityField -> {
                String description = metricDefinition.getDescription().length() > 255 ? metricDefinition.getDescription().substring(0, 252) + "..." : metricDefinition.getDescription();
                entityField.setDescription(description);
                this.businessEntityService.saveEntity(user, businessEntity);
            }));
        }
        metricDefinition.setCalculationFieldId(saved.getId());
        metricDefinition.setOutdated(false);
        this.metricDefinitionDao.save(metricDefinition);
        return saved.getId();
    }

    public MetricDefinitionCalculationStatus getMetricDefinitionCalculationStatus(UUID metricDefinitionId, JwtSecurityUser securityUser) {
        MetricDefinition metricDefinition = this.getMetricDefinitionById(metricDefinitionId, securityUser);
        UUID calculationFieldId = metricDefinition.getCalculationFieldId();
        if (calculationFieldId == null) {
            return MetricDefinitionCalculationStatus.MISSING;
        }
        Optional calculationFieldOptional = this.calculationFieldService.findById(securityUser, calculationFieldId);
        if (calculationFieldOptional.isEmpty()) {
            return MetricDefinitionCalculationStatus.DELETED;
        }
        CalculationField calculationField = (CalculationField)calculationFieldOptional.get();
        if (calculationField.getScript().equals(metricDefinition.getCode())) {
            metricDefinition.setOutdated(false);
            this.metricDefinitionDao.save(metricDefinition);
            return MetricDefinitionCalculationStatus.SYNCED;
        }
        if (metricDefinition.isOutdated()) {
            return MetricDefinitionCalculationStatus.UNSYNCED;
        }
        return MetricDefinitionCalculationStatus.OUTDATED;
    }

    public void deleteMetricDefinitionById(UUID metricDefinitionId, JwtSecurityUser securityUser) {
        this.metricDefinitionDao.deleteMetricDefinitionById(metricDefinitionId, securityUser);
    }

    public TrendzSimpleEntityUsage findUsage(JwtSecurityUser user) {
        return this.metricDefinitionDao.findUsage(user.getTenantId());
    }

    private List<MetricDefinition.Field> mapFields(List<String> uniqKeys, BusinessEntity businessEntity) {
        Map<String, UUID> sourceMap = businessEntity.getFields().stream().filter(businessEntityField -> businessEntityField.uniqKey() != null).collect(Collectors.toMap(BusinessEntityField::uniqKey, BusinessEntityField::getId, (ef1, ef2) -> ef1));
        return uniqKeys.stream().filter(sourceMap::containsKey).map(sourceMap::get).map(entityFieldId -> new MetricDefinition.Field(businessEntity.getId(), entityFieldId)).toList();
    }

    private List<MetricDefinition.Field> mapFields(Map<String, List<String>> uniqKeysMap, JwtSecurityUser user) {
        List businessEntities = this.businessEntityService.getAllEntities(user);
        Map<String, UUID> businessEntitySourceMap = businessEntities.stream().collect(Collectors.toMap(BusinessEntity::uniqKey, BusinessEntity::getId));
        Map<UUID, Map> fullEntityFieldSourceMap = businessEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, businessEntity -> businessEntity.getFields().stream().filter(entityField -> entityField.uniqKey() != null).collect(Collectors.toMap(BusinessEntityField::uniqKey, BusinessEntityField::getId, (ef1, ef2) -> ef1))));
        return uniqKeysMap.entrySet().stream().filter(entry -> businessEntitySourceMap.containsKey(entry.getKey())).flatMap(entry -> {
            UUID businessEntityId = (UUID)businessEntitySourceMap.get(entry.getKey());
            Map localEntityFieldSourceMap = (Map)fullEntityFieldSourceMap.get(businessEntityId);
            return ((List)entry.getValue()).stream().filter(localEntityFieldSourceMap::containsKey).map(localEntityFieldSourceMap::get).map(entityId -> new MetricDefinition.Field(businessEntityId, entityId));
        }).toList();
    }

    private Pair<String, Item> getSourceItemPair(BusinessEntity businessEntity, JwtSecurityUser user, UUID itemId, DatePickerConfig datePickerConfig, ZoneId zoneId, boolean advancedMode) {
        if (advancedMode) {
            return Pair.of((Object)this.topologyDetailsService.mapWideTopologyForItem(businessEntity.getId(), user), (Object)this.itemDetailsService.loadItem(businessEntity, itemId, user));
        }
        ItemDetails itemDetails = this.itemDetailsService.loadItemDetails(user, businessEntity, itemId, datePickerConfig, zoneId);
        return Pair.of((Object)this.itemDetailsMapper.mapToString(itemDetails), (Object)itemDetails.getItem());
    }

    private DatePickerConfig makeDatePickerForFixedStrategy(String dateGrouping) {
        return switch (dateGrouping) {
            case "minute", "hour" -> DatePickerConfig.builder().relativeLastAmount(1).relativeUnit("this").selectedUnit(new DatePickerConfigSelectType("Days", DatePickerConfigSelectType.Value.day, false)).selectedType(new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true)).build();
            case "day" -> DatePickerConfig.builder().relativeLastAmount(7).relativeUnit("last").selectedUnit(new DatePickerConfigSelectType("Days", DatePickerConfigSelectType.Value.day, false)).selectedType(new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true)).build();
            case "week" -> DatePickerConfig.builder().relativeLastAmount(14).relativeUnit("last").selectedUnit(new DatePickerConfigSelectType("Days", DatePickerConfigSelectType.Value.day, false)).selectedType(new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true)).build();
            case "month" -> DatePickerConfig.builder().relativeLastAmount(3).relativeUnit("last").selectedUnit(new DatePickerConfigSelectType("Months", DatePickerConfigSelectType.Value.month, false)).selectedType(new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true)).build();
            case "year" -> DatePickerConfig.builder().relativeLastAmount(3).relativeUnit("last").selectedUnit(new DatePickerConfigSelectType("Years", DatePickerConfigSelectType.Value.year, false)).selectedType(new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true)).build();
            default -> throw new IllegalArgumentException("Can't define date grouping");
        };
    }
}

