/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition.metadata;

import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityFieldMetadataDao;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityFieldMetadata;
import org.thingsboard.trendz.domain.definition.entity.metadata.RangeConfig;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.definition.metadata.BusinessEntityFieldMetadataService;
import org.thingsboard.trendz.service.metric.item.ItemMetricRangeConfigService;

@Service
public class BusinessEntityFieldMetadataService {
    private static final Set<FieldAggregation> AVAILABLE_NUMERIC_AGGREGATIONS = Set.of(FieldAggregation.MIN, FieldAggregation.MAX, FieldAggregation.SUM, FieldAggregation.AVG, FieldAggregation.COUNT, FieldAggregation.LATEST, FieldAggregation.UNIQ);
    private static final Set<FieldAggregation> AVAILABLE_TEXT_AGGREGATIONS = Set.of(FieldAggregation.UNIQ, FieldAggregation.LATEST, FieldAggregation.COUNT);
    private final BusinessEntityService businessEntityService;
    private final BusinessEntityFieldMetadataDao entityFieldMetadataDao;
    private final ItemMetricRangeConfigService rangeConfigService;

    @Autowired
    public BusinessEntityFieldMetadataService(BusinessEntityService businessEntityService, BusinessEntityFieldMetadataDao entityFieldMetadataDao, ItemMetricRangeConfigService rangeConfigService) {
        this.businessEntityService = businessEntityService;
        this.entityFieldMetadataDao = entityFieldMetadataDao;
        this.rangeConfigService = rangeConfigService;
    }

    public List<BusinessEntityFieldMetadata> getAll(JwtSecurityUser user) {
        return this.entityFieldMetadataDao.findAll(user);
    }

    public RangeConfig getRangeConfig(UUID entityFieldId, JwtSecurityUser user, DatePickerConfig datePickerConfig, ZoneId zoneId, UUID itemId) {
        this.businessEntityService.findEntityFieldById(user, entityFieldId);
        return this.entityFieldMetadataDao.getMetadata(user, entityFieldId).map(BusinessEntityFieldMetadata::getRangeConfig).orElseGet(() -> this.rangeConfigService.getDefault(entityFieldId, user, datePickerConfig, zoneId, itemId));
    }

    public void saveRangeConfig(UUID entityFieldId, JwtSecurityUser user, RangeConfig rangeConfig) {
        this.businessEntityService.findEntityFieldById(user, entityFieldId);
        this.entityFieldMetadataDao.updateMetadata(rangeConfig, null, null, user, entityFieldId);
    }

    public FieldAggregation getAggregation(UUID entityFieldId, JwtSecurityUser user) {
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, entityFieldId);
        Optional<FieldAggregation> fieldAggregation = this.entityFieldMetadataDao.getMetadata(user, entityFieldId).map(BusinessEntityFieldMetadata::getAggregation);
        if (fieldAggregation.isEmpty()) {
            return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1, 2 -> FieldAggregation.SUM;
                case 3, 4 -> FieldAggregation.UNIQ;
                case 5 -> throw new TrendzInternalException("FieldType of entity field cannot be BLANK: " + String.valueOf(entityFieldId));
            };
        }
        FieldAggregation aggregation = fieldAggregation.get();
        if (!this.isLegal(aggregation, entityField)) {
            this.entityFieldMetadataDao.clearDataFromMetadata(user, entityFieldId, false, true, false);
        }
        return aggregation;
    }

    public void saveAggregation(UUID entityFieldId, JwtSecurityUser user, FieldAggregation aggregation) {
        BusinessEntityField entityField = this.businessEntityService.findEntityFieldById(user, entityFieldId);
        if (this.isLegal(aggregation, entityField)) {
            this.entityFieldMetadataDao.updateMetadata(null, null, aggregation, user, entityFieldId);
        }
    }

    public List<BusinessEntityFieldMetadata> saveAll(List<BusinessEntityFieldMetadata> entityFieldMetadata) {
        return this.entityFieldMetadataDao.saveAll(entityFieldMetadata);
    }

    public String getDateGrouping(UUID entityFieldId, JwtSecurityUser user) {
        this.businessEntityService.findEntityFieldById(user, entityFieldId);
        return this.entityFieldMetadataDao.getMetadata(user, entityFieldId).map(BusinessEntityFieldMetadata::getDateGrouping).orElse("day");
    }

    public void saveDateGrouping(UUID entityFieldId, JwtSecurityUser user, String dateGrouping) {
        this.businessEntityService.findEntityFieldById(user, entityFieldId);
        this.entityFieldMetadataDao.updateMetadata(null, dateGrouping, null, user, entityFieldId);
    }

    public void clearRangeConfig(UUID entityFieldId, JwtSecurityUser user) {
        this.entityFieldMetadataDao.clearDataFromMetadata(user, entityFieldId, true, false, false);
    }

    public BusinessEntityFieldMetadata.Overview getOverview(UUID entityFieldId, JwtSecurityUser user) {
        this.businessEntityService.findEntityFieldById(user, entityFieldId);
        String dateGrouping = this.getDateGrouping(entityFieldId, user);
        FieldAggregation fieldAggregation = this.getAggregation(entityFieldId, user);
        return new BusinessEntityFieldMetadata.Overview(dateGrouping, fieldAggregation);
    }

    private boolean isLegal(FieldAggregation aggregation, BusinessEntityField entityField) {
        return switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$field$FieldType[entityField.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1, 2 -> AVAILABLE_NUMERIC_AGGREGATIONS.contains(aggregation);
            case 3, 4 -> AVAILABLE_TEXT_AGGREGATIONS.contains(aggregation);
            case 5 -> throw new TrendzInternalException("FieldType of entity field cannot be BLANK: " + String.valueOf(entityField.getId()));
        };
    }
}

