/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.definition;

import com.google.common.collect.Sets;
import jakarta.transaction.Transactional;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.business.BusinessEntityDao;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityFieldNotFoundException;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.exception.service.definition.TrendzDefinitionNullIdException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.TopologyStorage;
import org.thingsboard.trendz.service.definition.TopologyStorageService;
import org.thingsboard.trendz.service.provider.TbCustomerRelationService;
import org.thingsboard.trendz.service.startup.UserInitializationService;

@Service
@Transactional
public class BusinessEntityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusinessEntityService.class);
    private static final String TENANT_INIT_STATUS_CACHE_NAME = "tenantInitStatusCache";
    private final BusinessEntityDao businessEntityDao;
    private final UserInitializationService userInitializationService;
    private final TbCustomerRelationService relationService;
    private final TopologyStorageService storageService;

    @Autowired
    public BusinessEntityService(BusinessEntityDao businessEntityDao, UserInitializationService userInitializationService, TbCustomerRelationService relationService, TopologyStorageService storageService) {
        this.businessEntityDao = businessEntityDao;
        this.userInitializationService = userInitializationService;
        this.relationService = relationService;
        this.storageService = storageService;
    }

    public List<BusinessEntity> getAllEntities(JwtSecurityUser user) {
        TopologyStorage topologyStorage = this.storageService.loadAllEntities(user);
        List<BusinessEntity> result = topologyStorage.getEntityMap().values().stream().map(BusinessEntity::new).collect(Collectors.toList());
        log.debug("All business entities are loaded for user {}, user type {}, entity count {}", new Object[]{user.getUserId(), user.getOwnerEntityType(), result.size()});
        return result;
    }

    public BusinessEntity findEntityById(JwtSecurityUser user, UUID id) {
        return (BusinessEntity)this.findEntityByIdAsOptional(user, id).orElseThrow(() -> new BusinessEntityNotFoundException(id, user.getTenantId()));
    }

    public Optional<BusinessEntity> findEntityByIdAsOptional(JwtSecurityUser user, UUID id) {
        if (id == null) {
            throw new TrendzDefinitionNullIdException();
        }
        TopologyStorage topologyStorage = this.storageService.loadAllEntities(user);
        BusinessEntity businessEntity = (BusinessEntity)topologyStorage.getEntityMap().get(id);
        if (businessEntity == null) {
            log.debug("No business entity found for user {}, entity id {}", (Object)user.getUserId(), (Object)id);
        } else {
            log.debug("Business entity found for user {}, entity id {}, entity name \"{}\"", new Object[]{user.getUserId(), id, businessEntity.getName()});
        }
        return Optional.ofNullable(businessEntity).map(BusinessEntity::new);
    }

    public Map<UUID, BusinessEntity> getBusinessEntitySourceMap(JwtSecurityUser user) {
        return this.getAllEntities(user).stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
    }

    public BusinessEntityField findEntityFieldById(JwtSecurityUser user, UUID id) {
        if (id == null) {
            throw new TrendzDefinitionNullIdException();
        }
        TopologyStorage topologyStorage = this.storageService.loadAllEntities(user);
        BusinessEntityField field = (BusinessEntityField)topologyStorage.getFieldMap().get(id);
        if (field == null) {
            log.debug("No business entity field found for user {}, field id {}", (Object)user.getUserId(), (Object)id);
        } else {
            log.debug("Business entity field found for user {}, entity id {}, field name \"{}\"", new Object[]{user.getUserId(), id, field.getName()});
        }
        return Optional.ofNullable(field).map(BusinessEntityField::new).orElseThrow(() -> new BusinessEntityFieldNotFoundException(id));
    }

    @Caching(evict={@CacheEvict(cacheNames={"topologyStorage"}, allEntries=true), @CacheEvict(cacheNames={"tenantInitStatusCache"}, allEntries=true)})
    public BusinessEntity saveEntity(JwtSecurityUser user, BusinessEntity businessEntity) {
        this.syncRelations(businessEntity, user);
        return this.businessEntityDao.saveEntity(this.beforeSave(businessEntity), user.getTenantId());
    }

    @Caching(evict={@CacheEvict(cacheNames={"topologyStorage"}, allEntries=true), @CacheEvict(cacheNames={"tenantInitStatusCache"}, allEntries=true)})
    public List<BusinessEntity> saveAllEntities(List<BusinessEntity> entities, JwtSecurityUser user) {
        if (entities.isEmpty()) {
            return entities;
        }
        List entitiesToSave = entities.stream().map(arg_0 -> this.beforeSave(arg_0)).collect(Collectors.toList());
        return this.businessEntityDao.saveAllEntities(entitiesToSave, user.getTenantId());
    }

    public boolean deleteEntity(JwtSecurityUser user, UUID id) {
        this.businessEntityDao.deleteByIdAndTenantId(id, user.getTenantId());
        this.removeOphanRelations(id, user);
        this.storageService.resetCache(user);
        this.userInitializationService.refreshInitStatus(user);
        return true;
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, BusinessEntity oldBusinessEntity, BusinessEntity newBusinessEntity) {
        Object relatedEntityFieldIdSet;
        if (!user.isTenantUser()) {
            throw new TrendzException("Only tenant users can find depended entities!");
        }
        if (newBusinessEntity != null && !oldBusinessEntity.getId().equals(newBusinessEntity.getId())) {
            throw new TrendzException("The business entity ids are not equal!");
        }
        if (newBusinessEntity == null) {
            relatedEntityFieldIdSet = oldBusinessEntity.getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
        } else {
            Set differenceIdSet;
            HashSet oldFieldSet = new HashSet(oldBusinessEntity.getFields());
            Map newFieldSourceMap = newBusinessEntity.getFields().stream().collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
            Set differenceSet = oldFieldSet.stream().filter(oldField -> !newFieldSourceMap.containsKey(oldField.getId()) || !((BusinessEntityField)newFieldSourceMap.get(oldField.getId())).equals(oldField)).collect(Collectors.toSet());
            Set oldFieldIdSet = oldFieldSet.stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
            Sets.SetView intersectionIdSet = Sets.intersection(oldFieldIdSet, differenceIdSet = differenceSet.stream().map(BusinessEntityField::getId).collect(Collectors.toSet()));
            relatedEntityFieldIdSet = intersectionIdSet.isEmpty() ? Set.of(EntityId.NULL_UUID) : intersectionIdSet;
        }
        Set subCustomers = this.relationService.getAllSubCustomerIds(user);
        return this.businessEntityDao.findDependedEntities(user, relatedEntityFieldIdSet, subCustomers);
    }

    private BusinessEntity beforeSave(BusinessEntity businessEntity) {
        if (businessEntity.getId() == null) {
            businessEntity.setId(TimeStampUUIDGenerator.generateId());
        }
        for (BusinessEntityField field : businessEntity.getFields()) {
            if (field.getId() == null) {
                field.setId(TimeStampUUIDGenerator.generateId());
            }
            if (field.getBusinessEntityId() != null) continue;
            field.setBusinessEntityId(businessEntity.getId());
        }
        return businessEntity;
    }

    private void syncRelations(BusinessEntity businessEntity, JwtSecurityUser user) {
        List allEntities = this.getAllEntities(user);
        Map entityMap = allEntities.stream().collect(Collectors.toMap(BusinessEntity::getId, Function.identity()));
        HashSet<UUID> modifiedEntities = new HashSet<UUID>();
        for (BusinessEntity entity : allEntities) {
            boolean changed;
            if (entity.getId().equals(businessEntity.getId()) || !(changed = entity.getRelations().removeIf(relation -> relation.getRelatedEntityId().equals(businessEntity.getId()) && this.findOpposite(businessEntity.getRelations(), relation).isEmpty()))) continue;
            modifiedEntities.add(entity.getId());
        }
        for (Relation relation2 : businessEntity.getRelations()) {
            BusinessEntity relatedEntity = (BusinessEntity)entityMap.get(relation2.getRelatedEntityId());
            if (relatedEntity == null || relatedEntity.getId().equals(businessEntity.getId())) continue;
            List oppositeRelations = this.findOpposite(relatedEntity.getRelations(), relation2);
            if (oppositeRelations.isEmpty()) {
                relatedEntity.getRelations().add(relation2.revert(businessEntity.getId()));
                modifiedEntities.add(relatedEntity.getId());
                continue;
            }
            for (Relation opposite : oppositeRelations) {
                if (opposite.isEnabled() == relation2.isEnabled()) continue;
                opposite.setEnabled(relation2.isEnabled());
                modifiedEntities.add(relatedEntity.getId());
            }
        }
        this.businessEntityDao.saveAllEntities(modifiedEntities.stream().map(entityMap::get).toList(), user.getTenantId());
    }

    private List<Relation> findOpposite(List<Relation> relations, Relation target) {
        return relations.stream().filter(relation -> relation.getDirection() != target.getDirection() && relation.getRelationType().equals(target.getRelationType())).toList();
    }

    private void removeOphanRelations(UUID relatedId, JwtSecurityUser user) {
        List<BusinessEntity> businessEntitiesToModify = this.getAllEntities(user).stream().filter(businessEntity -> businessEntity.getRelations().stream().map(Relation::getRelatedEntityId).anyMatch(id -> id.equals(relatedId))).toList();
        businessEntitiesToModify.forEach(businessEntity -> businessEntity.setRelations(this.recreateRelationsWithoutRelatedEntity(relatedId, businessEntity.getRelations())));
        this.businessEntityDao.saveAllEntities(businessEntitiesToModify, user.getTenantId());
    }

    private List<Relation> recreateRelationsWithoutRelatedEntity(UUID relatedId, List<Relation> relations) {
        return relations.stream().filter(relation -> !relatedId.equals(relation.getRelatedEntityId())).toList();
    }
}

