/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.customize;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.thingsboard.server.common.data.wl.Palette;
import org.thingsboard.server.common.data.wl.PaletteSettings;
import org.thingsboard.server.common.data.wl.WhiteLabelingParams;
import org.thingsboard.trendz.dao.customize.CustomViewSettingsDao;
import org.thingsboard.trendz.dao.customize.DomainTenantPairDao;
import org.thingsboard.trendz.domain.customize.CustomViewSettings;
import org.thingsboard.trendz.domain.customize.PaletteSelection;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.domain.definition.ApplicationProperty;
import org.thingsboard.trendz.domain.system.Deployment;
import org.thingsboard.trendz.exception.service.customize.CustomizationException;
import org.thingsboard.trendz.exception.service.customize.TbWhitelabelingLoadException;
import org.thingsboard.trendz.exception.service.customize.TrendzCustomizationException;
import org.thingsboard.trendz.exception.service.provider.TbWebClientException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.definition.ApplicationPropertyService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.subscription.LicenceService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class CustomizationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomizationService.class);
    private final TbRestDataSource tbRestDataSource;
    private final CustomViewSettingsDao customViewSettingsDao;
    private final DomainTenantPairDao domainTenantPairDao;
    private final LicenceService licenceService;
    private final UserManagementService userManagementService;
    private final ApplicationPropertyService applicationPropertyService;
    private final Cache customViewSettingsCache;
    private final Cache domainTrackCache;
    private final Cache domainAllowedWhiteLabelingCache;
    private final Deployment deployment;
    public static final String WHITELABELING_API_PREFIX = "apiTrendz";
    public static final String WHITELABELING_DEFAULT_PREFIX = "trendz";
    public static final String WHITELABELING_CLOUD_ALTERNATIVE_PREFIX = "analytics";
    public static final Set<String> TB_CLOUD_URLS = Set.of("eu.thingsboard.cloud", "thingsboard.cloud", "tbqa.cloud");

    @Autowired
    public CustomizationService(TbRestDataSource tbRestDataSource, CustomViewSettingsDao customViewSettingsDao, DomainTenantPairDao domainTenantPairDao, LicenceService licenceService, UserManagementService userManagementService, ApplicationPropertyService applicationPropertyService, CacheService cacheService, Deployment deployment) {
        this.tbRestDataSource = tbRestDataSource;
        this.customViewSettingsDao = customViewSettingsDao;
        this.domainTenantPairDao = domainTenantPairDao;
        this.licenceService = licenceService;
        this.userManagementService = userManagementService;
        this.applicationPropertyService = applicationPropertyService;
        this.deployment = deployment;
        this.customViewSettingsCache = cacheService.getCache(CacheConfigurationName.tenantCustomViewSettingsCacheName);
        this.domainTrackCache = cacheService.getCache(CacheConfigurationName.domainTrackCacheName);
        this.domainAllowedWhiteLabelingCache = cacheService.getCache(CacheConfigurationName.domainAllowedWhiteLabelingCacheName);
    }

    public void trackDomain(JwtSecurityUser user, String domain) {
        if (!TB_CLOUD_URLS.contains(domain)) {
            this.domainTrackCache.get((Object)user.getTenantId(), () -> {
                this.domainTenantPairDao.writePair(domain, user.getTenantId());
                return true;
            });
        }
    }

    public void detachFromDomains(JwtSecurityUser user, String domain) {
        UUID tenantId = user.getTenantId();
        Set domains = this.domainTenantPairDao.findByTenantId(tenantId);
        this.domainTenantPairDao.removeAllByTenantId(tenantId);
        this.domainTrackCache.evict((Object)user.getTenantId());
        this.trackDomain(user, domain);
        log.info("Tenant was detached from following domains {} and wired to following domain {}, user = {}", new Object[]{domains, domain, user});
    }

    public String getCompanyName(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toUpperCase(input.charAt(0)));
        for (int i = 1; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                result.append(" ");
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public void updateTbBaseUrl(String tbBaseUrl) {
        String oldUrl = this.applicationPropertyService.getProperty(ApplicationProperty.Key.DEFAULT_TB_BASE_URL).orElse("None");
        this.applicationPropertyService.setProperty(ApplicationProperty.Key.DEFAULT_TB_BASE_URL, tbBaseUrl);
        this.customViewSettingsDao.updateThingsboardRedirectUrl(oldUrl, tbBaseUrl);
    }

    public boolean checkAccessOfWhiteLabeling(JwtSecurityUser user) {
        if (this.licenseForbidsWhiteLabeling(user)) {
            return false;
        }
        Optional whiteLabelingParams = this.getWhiteLabelingParams(user);
        return whiteLabelingParams.isPresent();
    }

    public CustomViewSettings getCustomViewSettings(String domain) {
        return this.getCustomViewSettings(domain, JwtSecurityUser.NOT_USER);
    }

    public CustomViewSettings getCustomViewSettings(String domain, JwtSecurityUser user) {
        if (JwtSecurityUser.NOT_USER.equals((Object)user)) {
            if (TB_CLOUD_URLS.contains(domain)) {
                log.debug("Default customization provided for cloud-domain without tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.createDefaultCustomViewSettings(domain);
            }
            boolean allowedUserExists = Boolean.TRUE.equals(this.domainAllowedWhiteLabelingCache.get((Object)domain, () -> {
                Set tenantIdSet = this.domainTenantPairDao.findByDomain(domain);
                log.debug("Found {} tenants for domain [{}]", (Object)tenantIdSet.size(), (Object)domain);
                if (tenantIdSet.isEmpty()) {
                    return true;
                }
                boolean allowed = false;
                for (UUID tenantId : tenantIdSet) {
                    Optional<JwtSecurityUser> userOpt = this.userManagementService.findFirstTenantUserByTenantId(tenantId).map(UserRecord::getUser);
                    if (!userOpt.isPresent()) continue;
                    try {
                        if (this.licenseForbidsWhiteLabeling(userOpt.get())) continue;
                        allowed = true;
                        break;
                    }
                    catch (TbWebClientException tbWebClientException) {
                    }
                }
                log.debug("Domain white labeling permission check, domain = {}, result = {}", (Object)domain, (Object)allowed);
                return allowed;
            }));
            if (allowedUserExists) {
                log.debug("Special customization provided for self-domain without tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.provideCustomViewSettings(domain);
            }
            log.debug("Default customization provided for self-domain with low-level subscription tenant: domain = {}, user = {}", (Object)domain, (Object)user);
            return this.createDefaultCustomViewSettings(domain);
        }
        if (this.licenseForbidsWhiteLabeling(user)) {
            log.debug("Default customization provided for low-level subscription tenant: domain = {}, user = {}", (Object)domain, (Object)user);
            return this.createDefaultCustomViewSettings(domain);
        }
        Set domains = this.domainTenantPairDao.findByTenantId(user.getTenantId());
        if (TB_CLOUD_URLS.contains(domain)) {
            if (domains.isEmpty()) {
                log.debug("Default customization created for cloud-domain with new tenant: domain = {}, user = {}", (Object)domain, (Object)user);
                return this.provideCustomViewSettings(domain, user);
            }
            if (domains.size() == 1) {
                String foundDomain = (String)domains.iterator().next();
                log.debug("Special customization provided for cloud-domain with known tenant: domain = {}, user = {}", (Object)foundDomain, (Object)user);
                return this.provideCustomViewSettings(foundDomain, user);
            }
            log.warn("You have ambiguous domain settings, details: domain = CLOUD, user = {}, registered domains = {}", (Object)user, (Object)domains);
            throw new CustomizationException("You have ambiguous domain settings!");
        }
        if (domains.isEmpty()) {
            log.debug("Special customization created for self-domain with known tenant: domain = {}, user = {}", (Object)domain, (Object)user);
            return this.provideCustomViewSettings(domain, user);
        }
        if (domains.size() == 1) {
            String foundDomain = (String)domains.iterator().next();
            log.debug("Special customization found for self-domain with known tenant: domain = {}, user = {}", (Object)foundDomain, (Object)user);
            return this.provideCustomViewSettings(foundDomain, user);
        }
        log.warn("You have ambiguous domain settings, details: domain = {}, user = {}, registered domains = {}", new Object[]{domain, user, domains});
        throw new CustomizationException("You have ambiguous domain settings!");
    }

    public CustomViewSettings setupCustomViewSettings(CustomViewSettings settings, String domain, JwtSecurityUser user) {
        String internalTrendzUrl = this.applicationPropertyService.getProperty(ApplicationProperty.Key.INTERNAL_TRENDZ_URL).orElse(null);
        if (this.licenseForbidsWhiteLabeling(user)) {
            log.warn("You can have not customization settings, details: domain = CLOUD, asked domain = {}, user = {}", (Object)settings.getDomain(), (Object)user);
            throw new CustomizationException("Your subscription is too low to have customization settings!");
        }
        this.validateSettings(settings);
        Set domains = this.domainTenantPairDao.findByTenantId(user.getTenantId());
        if (TB_CLOUD_URLS.contains(domain)) {
            if (domains.isEmpty()) {
                log.debug("You do not have any custom domain for customization: domain = CLOUD, asked domain = {}, user = {}, registered domains = {}", new Object[]{settings.getDomain(), user, domains});
                throw new CustomizationException("You do not have any custom domain for customization!");
            }
            if (domains.size() == 1) {
                String foundDomain = (String)domains.iterator().next();
                if (TB_CLOUD_URLS.contains(settings.getDomain()) || foundDomain.equals(settings.getDomain())) {
                    log.debug("Saved customization for cloud with domain and tenant: domain = CLOUD, asked domain = {}, user = {}, registered domains = {}", new Object[]{settings.getDomain(), user, domains});
                    settings.setDomain(foundDomain);
                    return this.saveCustomViewSettings(settings, user);
                }
                log.warn("You can set only your customization settings, details: domain = CLOUD, asked domain = {}, user = {}, registered domains = {}", new Object[]{settings.getDomain(), user, domains});
                throw new CustomizationException("You can set only your customization settings!");
            }
        }
        if (!Objects.equals(settings.getDomain(), domain) && !Objects.equals(internalTrendzUrl, domain)) {
            log.error(domain);
            log.error(settings.getDomain());
            log.error(internalTrendzUrl);
            log.warn("Domain and settings are not match, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
            throw new CustomizationException("Domain and settings are not match!");
        }
        if (domains.isEmpty()) {
            log.warn("Domain is not tracked, but it is impossible, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
            throw new CustomizationException("Domain is not tracked, but it is impossible!");
        }
        if (domains.size() == 1) {
            String foundDomain = (String)domains.iterator().next();
            if (foundDomain.equals(settings.getDomain())) {
                Optional whitelabelingParams = this.getWhiteLabelingParams(user);
                boolean whitelabelingEnabled = whitelabelingParams.isPresent();
                if (!whitelabelingEnabled && settings.getPaletteSelection() == PaletteSelection.TB_SELECTION) {
                    throw new TbWhitelabelingLoadException("TB service does not have white labeling");
                }
                if (whitelabelingParams.isPresent()) {
                    PaletteSettings paletteSettings = whitelabelingParams.map(WhiteLabelingParams::getPaletteSettings).orElse(null);
                    settings.setTbPaletteSettings(paletteSettings);
                }
                log.debug("Saved customization for self-hosted with domain and tenant: domain = {}, user = {}", (Object)settings.getDomain(), (Object)user);
                return this.saveCustomViewSettings(settings, user);
            }
            log.warn("You can set only your customization settings, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
            throw new CustomizationException("You can set only your customization settings!");
        }
        log.warn("You have ambiguous domain settings, details: domain = {}}, asked domain = {}, user = {}, registered domains = {}", new Object[]{domain, settings.getDomain(), user, domains});
        throw new CustomizationException("You have ambiguous domain settings!");
    }

    public String fetchUserLanguage(JwtSecurityUser user) {
        String defaultLanguage = "en_US";
        Optional langOpt = (Optional)DonReactive.block((Mono)this.tbRestDataSource.getUserByApi(user).map(u -> {
            JsonNode userAdditionalInfo = u.getAdditionalInfo();
            if (Objects.isNull(userAdditionalInfo) || userAdditionalInfo.isNull()) {
                return Optional.empty();
            }
            JsonNode langNode = userAdditionalInfo.get("lang");
            if (Objects.isNull(langNode) || langNode.isNull()) {
                return Optional.empty();
            }
            return Optional.of(langNode.asText());
        }).defaultIfEmpty(Optional.empty()));
        if (Objects.isNull(langOpt)) {
            return "en_US";
        }
        return langOpt.orElse("en_US");
    }

    private CustomViewSettings provideCustomViewSettings(String domain) {
        String key = this.getCustomViewSettingsKey(domain, null);
        return (CustomViewSettings)this.customViewSettingsCache.get((Object)key, () -> this.customViewSettingsDao.findCustomSettings(domain).orElseGet(() -> this.createDefaultCustomViewSettings(domain)));
    }

    private CustomViewSettings provideCustomViewSettings(String domain, JwtSecurityUser user) {
        String key = this.getCustomViewSettingsKey(domain, user);
        CustomViewSettings cachedValue = (CustomViewSettings)this.customViewSettingsCache.get((Object)key, CustomViewSettings.class);
        if (cachedValue == null) {
            cachedValue = this.customViewSettingsDao.findCustomSettings(domain).orElseGet(() -> {
                CustomViewSettings defaultData = this.createDefaultCustomViewSettings(domain, user);
                this.customViewSettingsDao.saveCustomSettings(defaultData);
                this.saveCustomViewSettings(defaultData, user);
                return defaultData;
            });
        }
        return cachedValue;
    }

    private CustomViewSettings createDefaultCustomViewSettings(String domain) {
        return this.createDefaultCustomViewSettings(domain, null);
    }

    private CustomViewSettings createDefaultCustomViewSettings(String domain, JwtSecurityUser user) {
        PaletteSettings tbPaletteSettings = user == null ? null : (PaletteSettings)this.getWhiteLabelingParams(user).map(WhiteLabelingParams::getPaletteSettings).orElse(null);
        String tbBaseUrl = this.applicationPropertyService.getProperty(ApplicationProperty.Key.DEFAULT_TB_BASE_URL).orElse("None");
        return CustomViewSettings.builder().domain(domain).url(WHITELABELING_DEFAULT_PREFIX).paletteSelection(PaletteSelection.DEFAULT).trendzPaletteSettings(null).tbPaletteSettings(null).tabName("Trendz").logoBase64(null).darkMode(false).tbPaletteSettings(tbPaletteSettings).trendzPaletteSettings(this.getDefaultPaletteSettings()).thingsboardRedirectUrl(tbBaseUrl).build();
    }

    private CustomViewSettings saveCustomViewSettings(CustomViewSettings settings, JwtSecurityUser user) {
        String keyWithUser = this.getCustomViewSettingsKey(settings.getDomain(), user);
        String keyWithoutUser = this.getCustomViewSettingsKey(settings.getDomain(), null);
        this.customViewSettingsCache.put((Object)keyWithUser, (Object)settings);
        this.customViewSettingsCache.put((Object)keyWithoutUser, (Object)settings);
        this.domainAllowedWhiteLabelingCache.evict((Object)settings.getDomain());
        return this.customViewSettingsDao.saveCustomSettings(settings);
    }

    private boolean licenseForbidsWhiteLabeling(JwtSecurityUser user) {
        return !this.licenceService.isWhitelabelingEnabled(user);
    }

    private String getCustomViewSettingsKey(String domain, JwtSecurityUser user) {
        if (user == null) {
            return domain;
        }
        return domain + String.valueOf(user);
    }

    private void validateSettings(CustomViewSettings settings) {
        Set<String> forbiddenUrls;
        Set<String> allowedUrls;
        if (this.deployment.isCloud() ? !(allowedUrls = Set.of(WHITELABELING_DEFAULT_PREFIX, WHITELABELING_CLOUD_ALTERNATIVE_PREFIX)).contains(settings.getUrl()) : (forbiddenUrls = Set.of("", WHITELABELING_API_PREFIX)).contains(settings.getUrl())) {
            throw new TrendzCustomizationException("Forbidden url!");
        }
    }

    private Optional<WhiteLabelingParams> getWhiteLabelingParams(JwtSecurityUser user) {
        try {
            return (Optional)DonReactive.block((Mono)this.tbRestDataSource.loadCurrentWhiteLabelParams(user));
        }
        catch (TbWebClientException e) {
            if (e.getCause() instanceof WebClientResponseException.Forbidden) {
                return Optional.empty();
            }
            if (e.getCause() instanceof WebClientResponseException.NotFound) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private PaletteSettings getDefaultPaletteSettings() {
        Palette primaryPalette = new Palette();
        primaryPalette.setColors(Map.of("color", "#5555FF", "contrastColor", "#555563"));
        Palette accentPalette = new Palette();
        PaletteSettings paletteSettings = new PaletteSettings();
        paletteSettings.setPrimaryPalette(primaryPalette);
        paletteSettings.setAccentPalette(accentPalette);
        return paletteSettings;
    }
}

