/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.cache;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.TrendzInternalException;

public class PreloadedCache {
    private Map<String, Map<FieldAggregation, Map<UUID, Map<UUID, CachedTelemetry>>>> cacheMap = new ConcurrentHashMap();

    public boolean containsCache(ViewField viewField, UUID itemId) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (this.cacheMap.containsKey(fieldKey) && ((Map)this.cacheMap.get(fieldKey)).containsKey(fieldAggregation)) {
            return ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).containsKey(itemId);
        }
        return false;
    }

    public Collection<CachedTelemetry> getCache(ViewField viewField, UUID itemId) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (this.cacheMap.containsKey(fieldKey) && ((Map)this.cacheMap.get(fieldKey)).containsKey(fieldAggregation) && ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).containsKey(itemId)) {
            return new ConcurrentLinkedQueue<CachedTelemetry>(((Map)((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).get(itemId)).values());
        }
        return null;
    }

    public void addCache(ViewField viewField, UUID itemId, CachedTelemetry cacheList) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (cacheList.getId() == null) {
            throw new IllegalArgumentException("Cached telemetry header must have id.");
        }
        this.cacheMap.computeIfAbsent(fieldKey, i -> new ConcurrentHashMap()).computeIfAbsent(fieldAggregation, i -> new ConcurrentHashMap()).computeIfAbsent(itemId, i -> new ConcurrentHashMap()).putIfAbsent(cacheList.getId(), cacheList);
    }

    public void resetCache(ViewField viewField, UUID itemId) {
        String fieldKey = this.getViewFieldKey(viewField);
        FieldAggregation fieldAggregation = viewField.getAggregationType();
        if (this.cacheMap.containsKey(fieldKey) && ((Map)this.cacheMap.get(fieldKey)).containsKey(fieldAggregation) && ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).containsKey(itemId)) {
            ((Map)((Map)this.cacheMap.get(fieldKey)).get(fieldAggregation)).put(itemId, new ConcurrentHashMap());
        }
    }

    private String getViewFieldKey(ViewField viewField) {
        if (viewField.isBatchCalculation()) {
            return viewField.getCalcFunction();
        }
        if (viewField.isStateField()) {
            return viewField.getStateCondition();
        }
        UUID entityFieldId = viewField.getEntityFieldId();
        if (entityFieldId == null) {
            throw new TrendzInternalException("The given view field doesn't have BE field ID, maybe it's a new type of field?");
        }
        return entityFieldId.toString();
    }
}

