/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.cache;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.cache.CachedTelemetryDaoAsync;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.cache.LoadedCachingData;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CachedTelemetryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryService.class);
    private static final Set<FieldAggregation> forbiddenTelemetryAggregations = Set.of(FieldAggregation.NONE, FieldAggregation.UNIQ, FieldAggregation.LATEST);
    private final CachedTelemetryDaoAsync cachedTelemetryDaoAsync;

    public CachedTelemetryService(CachedTelemetryDaoAsync cachedTelemetryDaoAsync) {
        this.cachedTelemetryDaoAsync = cachedTelemetryDaoAsync;
    }

    public static boolean isPossibleToUseTelemetryCache(ViewRequest request, ViewField viewField, BusinessEntityField entityField) {
        if (viewField.isCalculatedField() || viewField.isBatchCalculation() || viewField.isStateField() || viewField.isNativeCalculation()) {
            return false;
        }
        if (viewField.isAnomalyField() || viewField.isAlarmField() || viewField.isPredictionModelField()) {
            return false;
        }
        if (viewField.isCalculatedField() && !viewField.isBatchCalculation()) {
            return false;
        }
        if (!(viewField.isStateField() || viewField.isBatchCalculation() || entityField != null && entityField.hasTime())) {
            return false;
        }
        if (forbiddenTelemetryAggregations.contains(viewField.getAggregationType())) {
            return false;
        }
        if (DateAggregationType.isNotLoadableAggregationType((DateAggregationType)request.getCachingDateAggregationType())) {
            return false;
        }
        long startTs = request.getStartTs(viewField);
        long endTs = request.getEndTs(viewField) + 1L;
        ZoneId requestZoneId = request.getZoneId();
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), requestZoneId);
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTs), requestZoneId);
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)request.getCachingDateAggregationType());
        return timeUnit.between(startDate, endDate) > 0L;
    }

    public static FieldType getFieldTypeOfData(List<FieldValue> data) {
        if (data.isEmpty()) {
            throw new TrendzInternalException("Wrong data processing detected - empty value list loaded");
        }
        Set fieldTypeSet = data.stream().map(FieldValue::getFieldType).collect(Collectors.toSet());
        if (fieldTypeSet.size() > 1) {
            throw new TrendzInternalException("Wrong data processing detected - there is mix of different field types: [%s]".formatted(fieldTypeSet));
        }
        FieldType type = (FieldType)fieldTypeSet.iterator().next();
        if (type == null) {
            throw new TrendzInternalException("Wrong data processing detected - field type is null");
        }
        return type;
    }

    public void validateNeededTimeRangeOfCache(long startTs, long endTs, ZoneId zoneId, DateAggregationType cachingDateAggregation) {
        ZonedDateTime startDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTs), zoneId);
        ZonedDateTime endDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTs + 1L), zoneId);
        ChronoUnit timeUnit = DateAggregationType.mapDateAggregationToChronoUnit((DateAggregationType)cachingDateAggregation);
        if (timeUnit.between(startDate, endDate) == 0L) {
            throw new IllegalArgumentException("Queried telemetry cache has time-range shorter than duration of aggregation time unit");
        }
    }

    public Optional<Long> getRealLatestTelemetryFromItem(ViewContext ctx, ViewField viewField, Item item) {
        Map idToEntityFieldMap = ctx.getBusinessEntityFieldMap();
        BusinessEntityField entityField = (BusinessEntityField)idToEntityFieldMap.get(viewField.getEntityFieldId());
        String key = entityField.getQuery().getKey();
        return Optional.ofNullable((TsValue)item.getLatestTelemetry().get(key)).stream().filter(tsValue -> !tsValue.isEmpty()).map(TsValue::getTs).findAny();
    }

    public CachedTelemetry createNewCachedTelemetry(LoadedCachingData loadedCachingData, UUID itemId, long startTs, long endTs, DateAggregationType type, ViewField viewField, UUID tenantId) {
        long uploadTime = System.currentTimeMillis();
        List loadedData = loadedCachingData.getData();
        long latestPointTs = loadedCachingData.getLatestTs();
        String function = this.getFunctionFromField(viewField);
        FieldType fieldType = CachedTelemetryService.getFieldTypeOfData((List)loadedData);
        List loadedPoints = fieldType == FieldType.BLANK ? Collections.emptyList() : this.mapToCachePoints(loadedData);
        return CachedTelemetry.builder().itemId(itemId).tenantId(tenantId).uploadTime(uploadTime).calculatedField(viewField.isCalculatedField()).stateField(viewField.isStateField()).startTs(startTs).endTs(endTs).fieldType(fieldType).fieldAggregation(viewField.getAggregationType()).dateAggregationType(type).businessEntityId(viewField.getBusinessEntityId()).businessEntityFieldId(viewField.getEntityFieldId()).calculatedOrStateFunction(function).points(loadedPoints).latestTelemetryPoint(latestPointTs).build();
    }

    public CachedTelemetry mergeCachedTelemetries(List<CachedTelemetry> telemetryList) {
        if (telemetryList.isEmpty()) {
            throw new IllegalArgumentException("Telemetry cache list is empty therefore there is nothing to merge.");
        }
        if (telemetryList.size() == 1) {
            CachedTelemetry telemetry = telemetryList.iterator().next();
            CachedTelemetry copy = new CachedTelemetry(telemetry);
            copy.setId(null);
            return copy;
        }
        long finalStartTs = telemetryList.stream().mapToLong(CachedTelemetry::getStartTs).min().orElseThrow(TrendzInternalException::new);
        long finalLatestTelemetryPoint = telemetryList.stream().mapToLong(CachedTelemetry::getLatestTelemetryPoint).max().orElseThrow(TrendzInternalException::new);
        long finalEndTs = telemetryList.stream().mapToLong(CachedTelemetry::getEndTs).max().orElseThrow(TrendzInternalException::new);
        long earliestUploadTime = telemetryList.stream().mapToLong(CachedTelemetry::getUploadTime).min().orElseThrow(TrendzInternalException::new);
        List mergedPointList = telemetryList.stream().map(CachedTelemetry::getPoints).flatMap(Collection::stream).distinct().sorted(Comparator.comparingLong(CachedTelemetryPoint::getTs)).collect(Collectors.toList());
        FieldType fieldType = telemetryList.stream().map(CachedTelemetry::getFieldType).filter(type -> !type.equals((Object)FieldType.BLANK)).findAny().orElse(FieldType.BLANK);
        CachedTelemetry exampleOfCompatibleCache = telemetryList.get(0);
        return CachedTelemetry.builder().id(null).itemId(exampleOfCompatibleCache.getItemId()).tenantId(exampleOfCompatibleCache.getTenantId()).uploadTime(earliestUploadTime).calculatedField(exampleOfCompatibleCache.isCalculatedField()).stateField(exampleOfCompatibleCache.isStateField()).startTs(finalStartTs).endTs(finalEndTs).latestTelemetryPoint(finalLatestTelemetryPoint).fieldType(fieldType).fieldAggregation(exampleOfCompatibleCache.getFieldAggregation()).dateAggregationType(exampleOfCompatibleCache.getDateAggregationType()).businessEntityId(exampleOfCompatibleCache.getBusinessEntityId()).businessEntityFieldId(exampleOfCompatibleCache.getBusinessEntityFieldId()).calculatedOrStateFunction(exampleOfCompatibleCache.getCalculatedOrStateFunction()).points(mergedPointList).build();
    }

    public void verifyDuplicatedPoints(List<CachedTelemetry> telemetryList) {
        HashMap<Long, CachedTelemetryPoint> aggregatedTimestampToPointList = new HashMap<Long, CachedTelemetryPoint>();
        for (CachedTelemetry cache : telemetryList) {
            for (CachedTelemetryPoint cachePoint : cache.getPoints()) {
                CachedTelemetryPoint duplicate;
                if (aggregatedTimestampToPointList.containsKey(cachePoint.getTs()) && !(duplicate = (CachedTelemetryPoint)aggregatedTimestampToPointList.get(cachePoint.getTs())).getValue().equals(cachePoint.getValue())) {
                    throw new TrendzInternalException("Telemetry caches are intersects, points are not corresponding.");
                }
                aggregatedTimestampToPointList.putIfAbsent(cachePoint.getTs(), cachePoint);
            }
        }
    }

    public List<TimeRange> findGapsBetweenCaches(List<CachedTelemetry> telemetryList, long startTs, long endTs) {
        if (telemetryList.isEmpty()) {
            return Lists.newArrayList((Object[])new TimeRange[]{new TimeRange(startTs, endTs)});
        }
        List sortedTelemetryList = telemetryList.stream().sorted(Comparator.comparingLong(CachedTelemetry::getStartTs)).collect(Collectors.toList());
        CachedTelemetry first = (CachedTelemetry)sortedTelemetryList.get(0);
        CachedTelemetry last = (CachedTelemetry)sortedTelemetryList.get(sortedTelemetryList.size() - 1);
        long firstStart = first.getStartTs();
        long lastEnd = last.getEndTs();
        long prevEndTs = first.getEndTs();
        ArrayList<TimeRange> resultTimeRangeList = new ArrayList<TimeRange>();
        if (startTs < firstStart) {
            resultTimeRangeList.add(new TimeRange(startTs, firstStart - 1L));
        }
        for (CachedTelemetry cachedTelemetry : sortedTelemetryList) {
            if (prevEndTs < cachedTelemetry.getStartTs()) {
                resultTimeRangeList.add(new TimeRange(prevEndTs, cachedTelemetry.getStartTs() - 1L));
            }
            prevEndTs = cachedTelemetry.getEndTs();
        }
        if (lastEnd < endTs) {
            resultTimeRangeList.add(new TimeRange(lastEnd, endTs));
        }
        return resultTimeRangeList;
    }

    public CachedTelemetry uniteMergedCacheAndGapData(CachedTelemetry mergedCache, List<LoadedCachingData> loadedCachingData) {
        List loadedValues = loadedCachingData.stream().map(LoadedCachingData::getData).flatMap(Collection::stream).collect(Collectors.toList());
        long latestPointTs = Math.max(mergedCache.getLatestTelemetryPoint(), loadedCachingData.stream().max(Comparator.comparingLong(LoadedCachingData::getLatestTs)).map(LoadedCachingData::getLatestTs).orElse(0L));
        List loadedPointsForGaps = this.mapToCachePoints(loadedValues);
        mergedCache.getPoints().addAll(loadedPointsForGaps);
        mergedCache.setLatestTelemetryPoint(latestPointTs);
        boolean isAllMergedCachePointsBlankOrEmpty = this.isAllMergedCachePointsBlankOrEmpty(mergedCache);
        if (isAllMergedCachePointsBlankOrEmpty && !loadedValues.isEmpty()) {
            FieldType type = CachedTelemetryService.getFieldTypeOfData(loadedValues);
            mergedCache.setFieldType(type);
        }
        return mergedCache;
    }

    private boolean isAllMergedCachePointsBlankOrEmpty(CachedTelemetry mergedCache) {
        return mergedCache.getPoints().isEmpty() || mergedCache.getFieldType() == FieldType.BLANK;
    }

    public List<FieldValue> mapToFieldValues(Item item, long startTs, long endTs, List<CachedTelemetryPoint> allPoints, FieldType fieldType) {
        if (allPoints.isEmpty()) {
            return Lists.newArrayList((Object[])new FieldValue[]{new FieldValue(item, FieldType.BLANK, null)});
        }
        return allPoints.stream().filter(point -> startTs <= point.getTs() && point.getTs() < endTs).map(point -> new FieldValue(item, fieldType, point.getValue(), point.getTs())).collect(Collectors.toList());
    }

    public String getFunctionFromField(ViewField viewField) {
        Object result = "null";
        if (viewField.isStateField()) {
            result = viewField.getStateCondition();
        }
        if (viewField.isCalculatedField()) {
            result = viewField.getCalcFunction();
        }
        result = (String)result + "\n\n\n" + String.valueOf(viewField.getFillGapSettings());
        return result;
    }

    public List<CachedTelemetryPoint> mapToCachePoints(List<FieldValue> fieldValues) {
        boolean isBlankList = fieldValues.stream().allMatch(fieldValue -> fieldValue.getFieldType() == FieldType.BLANK);
        if (isBlankList) {
            return new ArrayList<CachedTelemetryPoint>();
        }
        return fieldValues.stream().map(fieldValue -> new CachedTelemetryPoint(fieldValue.getTs(), fieldValue.getInnerValue())).collect(Collectors.toList());
    }

    public Mono<List<CachedTelemetry>> loadAllCompatibleCachedTelemetry(Set<UUID> itemIds, long startTs, long endTs, ViewField viewField, DateAggregationType cachingDateAggregation) {
        String function = this.getFunctionFromField(viewField);
        return this.cachedTelemetryDaoAsync.findAllCompatibleCachedTelemetriesAsync(itemIds, startTs, endTs, viewField.getAggregationType(), cachingDateAggregation, viewField.getEntityFieldId(), function);
    }

    public Mono<UUID> persistCashAndRemoveOthers(CachedTelemetry cachedTelemetry, List<CachedTelemetry> oldTelemetryCaches) {
        return this.cachedTelemetryDaoAsync.saveAndMergeCachesAsync(cachedTelemetry, oldTelemetryCaches);
    }

    public Mono<UUID> persistTelemetry(CachedTelemetry cachedTelemetry) {
        return this.cachedTelemetryDaoAsync.saveCachedTelemetryAsync(cachedTelemetry);
    }

    public Mono<Boolean> removeAllCacheByTenantId(TenantId tenantId) {
        return this.cachedTelemetryDaoAsync.removeAllByTenantIdAsync(tenantId);
    }

    public Mono<Boolean> removeTelemetries(List<CachedTelemetry> cachedTelemetries) {
        if (cachedTelemetries.isEmpty()) {
            return Mono.just((Object)true);
        }
        return this.cachedTelemetryDaoAsync.removeTelemetries(cachedTelemetries);
    }

    public Mono<Boolean> removeAllCache() {
        return this.cachedTelemetryDaoAsync.removeAllCacheAsync();
    }
}

