/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.view;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewFieldType;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationUnit;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.assistance.view.ViewMapper;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class ViewMapperImpl
implements ViewMapper {
    private final BusinessEntityService businessEntityService;

    @Autowired
    public ViewMapperImpl(BusinessEntityService businessEntityService) {
        this.businessEntityService = businessEntityService;
    }

    public List<ViewField> mapLiteViewFieldListToViewFieldList(List<LiteViewField> liteViewFieldList, List<BusinessEntity> reducedTopology) {
        return Objects.requireNonNullElse(liteViewFieldList, Collections.emptyList()).stream().filter(Objects::nonNull).map(liteViewField -> this.mapLiteViewFieldToViewField(liteViewField, reducedTopology)).toList();
    }

    public ViewField mapLiteViewFieldToViewField(LiteViewField liteViewField, List<BusinessEntity> reducedTopology) {
        ViewField viewField = new ViewField();
        viewField.setId(UUID.randomUUID());
        if (liteViewField.get_type() == LiteViewFieldType.DATA) {
            BusinessEntity restoredBusinessEntity = this.restoreBusinessEntity(liteViewField.getDataField(), reducedTopology);
            BusinessEntityField restoredBusinessEntityField = (BusinessEntityField)restoredBusinessEntity.getFields().get(0);
            String fieldName = liteViewField.getX_fieldName() == null ? liteViewField.getDataField().getField().getName() : liteViewField.getX_fieldName();
            viewField.setLabel(fieldName);
            viewField.setBusinessEntityId(restoredBusinessEntity.getId());
            viewField.setEntityFieldId(restoredBusinessEntityField.getId());
            viewField.setAggregationType(liteViewField.getDataField().getAggregation());
            if (viewField.getAggregationType() == FieldAggregation.NONE) {
                viewField.setAggregationType(FieldAggregation.UNIQ);
            }
        } else {
            viewField.setLabel("Date: " + String.valueOf(liteViewField.getGroupingItem().getUnit()));
            viewField.setAggregationType(FieldAggregation.NONE);
            viewField.setVirtualDateField(true);
            viewField.setDateGrouping(DateAggregationType.mapUnitToType((DateAggregationUnit)liteViewField.getGroupingItem().getUnit(), (boolean)liteViewField.getGroupingItem().isCyclic()));
        }
        return viewField;
    }

    public String mapViewConfigToString(ViewConfig viewConfig, JwtSecurityUser user) {
        Map businessEntitySourceMap = this.businessEntityService.getBusinessEntitySourceMap(user);
        Map businessEntityFieldSourceMap = businessEntitySourceMap.values().stream().map(BusinessEntity::getFields).flatMap(Collection::stream).collect(Collectors.toMap(BusinessEntityField::getId, Function.identity()));
        if (viewConfig == null) {
            return "No Data";
        }
        return "View name: %s\nView type: %s\nX-Axis: %s\nY-Axis: %s\nSeries: %s\nFilters: %s\n".formatted(viewConfig.getName(), viewConfig.getViewType(), this.mapViewFieldsToString(businessEntitySourceMap, businessEntityFieldSourceMap, viewConfig.getXAxis()), this.mapViewFieldsToString(businessEntitySourceMap, businessEntityFieldSourceMap, viewConfig.getYAxis()), this.mapViewFieldsToString(businessEntitySourceMap, businessEntityFieldSourceMap, viewConfig.getSeries()), this.mapViewFieldsToString(businessEntitySourceMap, businessEntityFieldSourceMap, viewConfig.getHiddenFields()));
    }

    public String mapViewReportToString(ViewConfig viewConfig, List<DataRow> rows, ZoneId zoneId) {
        Map<UUID, String> xAxisLabels = viewConfig.getXAxis().stream().collect(Collectors.toMap(ViewField::getId, ViewField::getLabel));
        Map<UUID, String> yAxisLabels = viewConfig.getYAxis().stream().collect(Collectors.toMap(ViewField::getId, ViewField::getLabel));
        Map<UUID, String> seriesLabels = viewConfig.getSeries().stream().collect(Collectors.toMap(ViewField::getId, ViewField::getLabel));
        Map<UUID, List<DataCell>> data = rows.stream().map(DataRow::getCells).flatMap(Collection::stream).collect(Collectors.groupingBy(DataCell::getViewFieldId));
        Map<UUID, DateAggregationType> dateAggregationTypeMap = viewConfig.getAllFields().stream().filter(ViewField::isVirtualDateField).collect(Collectors.toMap(ViewField::getId, ViewField::getDateGrouping));
        data.keySet().stream().filter(dateAggregationTypeMap::containsKey).map(data::get).flatMap(Collection::stream).filter(dataCell -> dataCell.getData() != null).filter(dataCell -> dataCell.getData().toString().matches("\\d+")).forEach(cell -> {
            DateAggregationType dateAggregationType = (DateAggregationType)dateAggregationTypeMap.get(cell.getViewFieldId());
            long dateLong = Long.parseLong(cell.getData().toString());
            if (dateAggregationType == DateAggregationType.DAY) {
                String[] dayNames = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
                if (dateLong >= 1L && dateLong <= 7L) {
                    cell.setData((Object)dayNames[(int)dateLong - 1]);
                } else {
                    cell.setData((Object)"Invalid day");
                }
            } else if (dateAggregationType == DateAggregationType.MONTH) {
                String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
                if (dateLong >= 1L && dateLong <= 12L) {
                    cell.setData((Object)monthNames[(int)dateLong - 1]);
                } else {
                    cell.setData((Object)"Invalid month");
                }
            } else if (dateAggregationType != DateAggregationType.HOUR && dateAggregationType != DateAggregationType.MINUTE) {
                String isoDate = Instant.ofEpochMilli(dateLong).atZone(zoneId).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                cell.setData((Object)isoDate);
            }
        });
        List sortedRows = rows.stream().sorted(Comparator.comparing(row -> this.getAxisValue((DataRow)row, seriesLabels.keySet()), Comparator.naturalOrder()).thenComparing(row -> this.getAxisValue((DataRow)row, xAxisLabels.keySet()), Comparator.naturalOrder())).collect(Collectors.toList());
        int maxRows = data.values().stream().mapToInt(List::size).max().orElse(0);
        String headers = Stream.concat(Stream.concat(seriesLabels.values().stream(), xAxisLabels.values().stream()), yAxisLabels.values().stream()).collect(Collectors.joining(" | "));
        String separator = "-".repeat(headers.length());
        String rowsData = IntStream.range(0, maxRows).mapToObj(i -> Stream.concat(Stream.concat(seriesLabels.keySet().stream(), xAxisLabels.keySet().stream()), yAxisLabels.keySet().stream()).map(fieldId -> {
            DataCell cell = this.getCellForRow(sortedRows, fieldId, i);
            return cell != null ? String.valueOf(cell.getData()) : "";
        }).collect(Collectors.joining(" | "))).collect(Collectors.joining("\n"));
        return String.join((CharSequence)"\n", headers, separator, rowsData);
    }

    private String getAxisValue(DataRow row, Set<UUID> indexes) {
        return row.getCells().stream().filter(cell -> indexes.contains(cell.getViewFieldId())).map(DataCell::getData).map(object -> object == null ? "No Data" : object.toString()).collect(Collectors.joining());
    }

    private DataCell getCellForRow(List<DataRow> rows, UUID fieldId, int index) {
        if (index < rows.size()) {
            DataRow row = rows.get(index);
            return row.getCells().stream().filter(cell -> cell.getViewFieldId().equals(fieldId)).findFirst().orElse(null);
        }
        return null;
    }

    private String mapViewFieldsToString(Map<UUID, BusinessEntity> businessEntitySourceMap, Map<UUID, BusinessEntityField> businessEntityFieldSourceMap, List<ViewField> viewFieldList) {
        return viewFieldList.isEmpty() ? "Empty" : viewFieldList.stream().map(viewField -> this.mapViewFieldToString(viewField, (BusinessEntity)businessEntitySourceMap.get(viewField.getBusinessEntityId()), (BusinessEntityField)businessEntityFieldSourceMap.get(viewField.getEntityFieldId()))).map(s -> "\n\t" + s).collect(Collectors.joining());
    }

    private String mapViewFieldToString(ViewField viewField, BusinessEntity businessEntity, BusinessEntityField businessEntityField) {
        if (viewField.isVirtualDateField()) {
            return "Date grouping field: %s".formatted(viewField.getDateGrouping().name());
        }
        return "(%s from %s) as '%s' (%s %s) aggregated with %s".formatted(businessEntityField.getName(), businessEntity.getName(), viewField.getLabel(), businessEntityField.getType().name(), businessEntityField.getQuery().getQueryType().name(), viewField.getAggregationType().name());
    }

    private BusinessEntity restoreBusinessEntity(LiteDataField liteDataField, List<BusinessEntity> businessEntityList) {
        List pairList = businessEntityList.stream().filter(businessEntity -> businessEntity.getName().equals(liteDataField.getX_businessEntityName())).flatMap(businessEntity -> businessEntity.getFields().stream().filter(businessEntityField -> businessEntityField.getName().equals(liteDataField.getField().getName())).map(businessEntityField -> Pair.of((Object)businessEntity, (Object)businessEntityField))).toList();
        if (pairList.isEmpty()) {
            String message = "%s/%s was not found.".formatted(liteDataField.getX_businessEntityName(), liteDataField.getField().getName());
            throw new TrendzException(message);
        }
        Pair pair2 = (Pair)pairList.iterator().next();
        BusinessEntity newBE = new BusinessEntity((BusinessEntity)pair2.getLeft());
        newBE.setFields(List.of((BusinessEntityField)pair2.getRight()));
        return newBE;
    }
}

