/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.view;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptExecutionRequest;
import org.thingsboard.trendz.domain.assistance.summary.ViewAiSummaryRequest;
import org.thingsboard.trendz.domain.chat.ChatType;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewConfig;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.ViewConfigService;
import org.thingsboard.trendz.service.assistance.agent.customprompt.domain.CustomPromptResult;
import org.thingsboard.trendz.service.assistance.customprompt.CustomPromptService;
import org.thingsboard.trendz.service.assistance.llm.LlmService;
import org.thingsboard.trendz.service.assistance.view.ViewAiSummaryService;
import org.thingsboard.trendz.service.assistance.view.ViewMapper;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.ViewAiSummaryJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Service
public class ViewAiSummaryServiceImpl
implements ViewAiSummaryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViewAiSummaryServiceImpl.class);
    private final CustomPromptService customPromptService;
    private final TaskService taskService;
    private final ViewMapper viewMapper;
    private final ViewConfigService viewConfigService;
    private final LlmService llmService;

    @Autowired
    public ViewAiSummaryServiceImpl(CustomPromptService customPromptService, TaskService taskService, ViewMapper viewMapper, ViewConfigService viewConfigService, LlmService llmService) {
        this.customPromptService = customPromptService;
        this.taskService = taskService;
        this.viewMapper = viewMapper;
        this.viewConfigService = viewConfigService;
        this.llmService = llmService;
    }

    public CustomPromptResult getAiSummary(ViewAiSummaryRequest viewAiSummaryRequest, JwtSecurityUser user) {
        ZoneId zoneId = DateTimeUtils.fromTzName((String)viewAiSummaryRequest.getTzName());
        String data = this.viewMapper.mapViewReportToString(viewAiSummaryRequest.getViewConfig(), viewAiSummaryRequest.getRows(), zoneId);
        String request = "User request: %s\nName: %s\nTimerange: %s\nView Type: %s\n\nAnswer on user request:\n%s".formatted(viewAiSummaryRequest.getAiMemory(), viewAiSummaryRequest.getViewConfig().getName(), this.mapDatePickerToAiRequest(viewAiSummaryRequest.getViewConfig().getDatePickerConfig()), viewAiSummaryRequest.getViewConfig().getViewType().name(), data);
        CustomPromptExecutionRequest customPromptExecutionRequest = CustomPromptExecutionRequest.builder().prompt(viewAiSummaryRequest.getPrompt()).promptId(viewAiSummaryRequest.getPromptId()).data(request).build();
        CustomPromptResult result = this.customPromptService.executeViewSummary(customPromptExecutionRequest, user);
        log.info("Custom prompt execution result: {}", (Object)result);
        return result;
    }

    public UUID runAiSummaryExecution(ViewAiSummaryRequest viewAiSummaryRequest, JwtSecurityUser user) {
        this.llmService.validateChatTypeForUser(user, ChatType.CUSTOM_PROMPT);
        UUID viewConfigId = viewAiSummaryRequest.getViewConfig().getId();
        String referenceKey = Optional.ofNullable(viewConfigId).flatMap(id -> this.viewConfigService.findConfigById(user, id)).map(ViewConfig::getId).map(UUID::toString).orElse(user.getTenantCustomerKey());
        TaskReference reference = new TaskReference(TaskReferencedEntityType.VIEW_CONFIG_AI_SUMMARY_TASK, referenceKey);
        ViewAiSummaryJob job = ViewAiSummaryJob.builder().viewAiSummaryRequest(viewAiSummaryRequest).build();
        Task task = this.taskService.findTaskByReferencedEntity(user, reference).orElseGet(() -> this.taskService.createTask(user, TaskConfig.builder().reference(reference).job((TaskJob)job).name("View config, AI summary: " + viewAiSummaryRequest.getViewConfig().getName()).build()));
        return this.taskService.runExecution(user, task.getId(), (TaskJob)job, false, true);
    }

    private String mapDatePickerToAiRequest(DatePickerConfig datePickerConfig) {
        return "The data was geather from %s to %s.".formatted(DateTimeUtils.fromTs((long)datePickerConfig.getStartTs()).format(DateTimeFormatter.ISO_DATE), DateTimeUtils.fromTs((long)datePickerConfig.getEndTs()).format(DateTimeFormatter.ISO_DATE));
    }
}

