/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.view;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDateGroupingItem;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewConfig;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewField;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteViewFieldType;
import org.thingsboard.trendz.domain.assistance.agent.lite.viewconfig.LiteCardViewConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewType;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.view.ViewExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.view.domain.ViewExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;

@Service
public class CardViewExpertAgent
implements ViewExpertAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CardViewExpertAgent.class);
    private final AgentService agentService;

    @Autowired
    public CardViewExpertAgent(AgentService agentService) {
        this.agentService = agentService;
    }

    public AiAgentType getAgentType() {
        return AiAgentType.CARD_VIEW_EXPERT;
    }

    public ViewExpertResult generateView(ViewAssistanceContext context, Set<LiteDataField> dataFields, Set<LiteDateGroupingItem> dateGroupingItems) {
        ViewExpertRequest viewExpertRequest = ViewExpertRequest.builder().userQuestion(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, this.getAgentType())).dateGroupingItems(dateGroupingItems).liteDataFields(dataFields).build();
        LiteCardViewConfig cardViewConfig = (LiteCardViewConfig)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)viewExpertRequest, this.getAgentType());
        if (cardViewConfig.isWithLine()) {
            Map<String, IntNode> settings = Map.of("title", new TextNode(cardViewConfig.getCardTitle()), "legendDisabled", BooleanNode.getTrue(), "titleSize", new IntNode(1));
            return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(LiteViewConfig.builder().viewType(ViewType.CARD_WITH_LINE).xAxis(List.of(LiteViewField.builder()._type(LiteViewFieldType.DATE_TIME).groupingItem(cardViewConfig.getGroupingItem()).x_fieldName("Date").build())).series(Collections.emptyList()).yAxis(List.of(LiteViewField.builder()._type(LiteViewFieldType.DATA).dataField(cardViewConfig.getValue()).build())).settings(settings).build()).status(cardViewConfig.get_status())).comment(cardViewConfig.get_comment())).build();
        }
        return ((ViewExpertResult.ViewExpertResultBuilder)((ViewExpertResult.ViewExpertResultBuilder)ViewExpertResult.builder().liteViewConfig(LiteViewConfig.builder().viewType(ViewType.CARD).xAxis(List.of(LiteViewField.builder()._type(LiteViewFieldType.DATA).dataField(cardViewConfig.getValue()).build())).series(Collections.emptyList()).yAxis(Collections.emptyList()).build()).status(cardViewConfig.get_status())).comment(cardViewConfig.get_comment())).build();
    }
}

