/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.settings;

import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteDataField;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.settings.GeneralViewSettingsExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.settings.domain.GeneralViewSettingsExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.settings.domain.GeneralViewSettingsExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.settings.domain.GeneralViewSettingsExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;

@Service
public class GeneralViewSettingsExpertAgentImpl
implements GeneralViewSettingsExpertAgent {
    private final AgentService agentService;

    @Autowired
    public GeneralViewSettingsExpertAgentImpl(AgentService agentService) {
        this.agentService = agentService;
    }

    public GeneralViewSettingsExpertResult generateViewSettings(ViewAssistanceContext context, Set<LiteDataField> liteDataFields) {
        ViewAssistanceState state = context.getViewAssistanceState();
        GeneralViewSettingsExpertResult oldGeneralViewSettings = state.getGeneralViewSettings();
        GeneralViewSettingsExpertResult newGeneralViewSettings = this.process(context, liteDataFields);
        if (oldGeneralViewSettings != null && oldGeneralViewSettings.getLiteViewType() != newGeneralViewSettings.getLiteViewType()) {
            state.setDateGrouper(null);
            state.setView(null);
        }
        state.setGeneralViewSettings(newGeneralViewSettings);
        return newGeneralViewSettings;
    }

    public GeneralViewSettingsExpertResult process(ViewAssistanceContext context, Set<LiteDataField> liteDataFields) {
        GeneralViewSettingsExpertRequest generalViewSettingsExpertRequest = GeneralViewSettingsExpertRequest.builder().myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, AiAgentType.GENERAL_VIEW_SETTINGS_EXPERT)).question(context.getQuestion()).useCardAsDefault(this.useCardAsDefault(liteDataFields)).build();
        GeneralViewSettingsExpertResponse generalViewSettingsExpertResponse = (GeneralViewSettingsExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)generalViewSettingsExpertRequest, AiAgentType.GENERAL_VIEW_SETTINGS_EXPERT);
        return ((GeneralViewSettingsExpertResult.GeneralViewSettingsExpertResultBuilder)((GeneralViewSettingsExpertResult.GeneralViewSettingsExpertResultBuilder)GeneralViewSettingsExpertResult.builder().liteViewType(generalViewSettingsExpertResponse.getLiteViewType()).viewName(generalViewSettingsExpertResponse.getViewName()).comment(generalViewSettingsExpertResponse.get_comment())).status(generalViewSettingsExpertResponse.get_status())).build();
    }

    private boolean useCardAsDefault(Set<LiteDataField> liteDataFields) {
        if (liteDataFields.size() != 1) {
            return false;
        }
        LiteDataField liteDataField = (LiteDataField)liteDataFields.stream().findAny().orElseThrow();
        return liteDataField.getAggregation() != FieldAggregation.UNIQ && liteDataField.getAggregation() != FieldAggregation.NONE;
    }
}

