/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.assistance.agent.groupfinder;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.assistance.agent.AgentResponseStatus;
import org.thingsboard.trendz.domain.assistance.agent.AiAgentType;
import org.thingsboard.trendz.domain.assistance.agent.lite.LiteTopology;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.exception.assistance.AiTopologyLimitException;
import org.thingsboard.trendz.service.assistance.agent.AgentService;
import org.thingsboard.trendz.service.assistance.agent.TopologyMapper;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.GroupFinderExpertAgent;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.domain.GroupFinderExpertRequest;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.domain.GroupFinderExpertResponse;
import org.thingsboard.trendz.service.assistance.agent.groupfinder.domain.GroupFinderExpertResult;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceContext;
import org.thingsboard.trendz.service.assistance.domain.ViewAssistanceState;
import org.thingsboard.trendz.service.assistance.token.TokenUsageService;
import org.thingsboard.trendz.service.definition.BusinessEntityService;

@Service
public class GroupFinderExpertAgentImpl
implements GroupFinderExpertAgent {
    private final BusinessEntityService businessEntityService;
    private final TopologyMapper topologyMapper;
    private final AgentService agentService;
    private final TokenUsageService tokenUsageService;
    private final int topologyTokenLimit;

    @Autowired
    public GroupFinderExpertAgentImpl(BusinessEntityService businessEntityService, TopologyMapper topologyMapper, AgentService agentService, TokenUsageService tokenUsageService, @Value(value="${viewAssistance.agent.topologyTokenLimit}") int topologyTokenLimit) {
        this.businessEntityService = businessEntityService;
        this.topologyMapper = topologyMapper;
        this.agentService = agentService;
        this.tokenUsageService = tokenUsageService;
        this.topologyTokenLimit = topologyTokenLimit;
    }

    public GroupFinderExpertResult findGroup(ViewAssistanceContext context) {
        ViewAssistanceState viewAssistanceState = context.getViewAssistanceState();
        if (ObjectUtils.allNotNull((Object[])new Object[]{viewAssistanceState.getGroupFinder(), viewAssistanceState.getFilterQueryAnalyzer(), viewAssistanceState.getQueryAnalyzer()})) {
            return viewAssistanceState.getGroupFinder();
        }
        GroupFinderExpertResult groupFinderExpertResult = this.process(context);
        if (viewAssistanceState.getGroupFinder() == null || viewAssistanceState.getGroupFinder().getGroupNumber() != groupFinderExpertResult.getGroupNumber()) {
            viewAssistanceState.setTopologyMapper(null);
            viewAssistanceState.setView(null);
            viewAssistanceState.setFilter(null);
        }
        viewAssistanceState.setGroupFinder(groupFinderExpertResult);
        return groupFinderExpertResult;
    }

    private GroupFinderExpertResult process(ViewAssistanceContext context) {
        List businessEntities = this.businessEntityService.getAllEntities(context.getUser());
        List availableTopology = this.topologyMapper.filterBusinessEntities(businessEntities, context.getChatLite().getAvailableTopology(), context.getUser().getTenantId());
        LiteTopology liteTopology = this.topologyMapper.convertBusinessEntities(availableTopology, businessEntities);
        String inputData = this.topologyMapper.transformInputData(liteTopology, true);
        this.validateInputData(inputData);
        int countOfComponents = new HashSet(liteTopology.getEntityIdToComponentMap().values()).size();
        if (countOfComponents == 0 || countOfComponents == 1) {
            return ((GroupFinderExpertResult.GroupFinderExpertResultBuilder)((GroupFinderExpertResult.GroupFinderExpertResultBuilder)GroupFinderExpertResult.builder().status(AgentResponseStatus.SUCCESS)).comment("No AI")).availableTopology(availableTopology).liteTopology(liteTopology).build();
        }
        GroupFinderExpertRequest groupFinderExpertRequest = GroupFinderExpertRequest.builder().question(context.getQuestion()).myPreviousResponseWas(this.agentService.preparePreviousAnswerInfo(context, AiAgentType.GROUP_FINDER_EXPERT)).topology(inputData).build();
        GroupFinderExpertResponse groupFinderExpertResponse = (GroupFinderExpertResponse)this.agentService.processAiRequest(context.getUser(), context.getAgentMetadataContainer(), (Object)groupFinderExpertRequest, AiAgentType.GROUP_FINDER_EXPERT);
        List reducedTopology = this.reduceTopologyByGroupNumber(availableTopology, liteTopology, groupFinderExpertResponse.getGroupNumber());
        if (reducedTopology.isEmpty()) {
            return ((GroupFinderExpertResult.GroupFinderExpertResultBuilder)((GroupFinderExpertResult.GroupFinderExpertResultBuilder)GroupFinderExpertResult.builder().status(AgentResponseStatus.ERROR)).comment(groupFinderExpertResponse.get_comment())).build();
        }
        return ((GroupFinderExpertResult.GroupFinderExpertResultBuilder)((GroupFinderExpertResult.GroupFinderExpertResultBuilder)GroupFinderExpertResult.builder().status(groupFinderExpertResponse.get_status())).comment(groupFinderExpertResponse.get_comment())).groupNumber(groupFinderExpertResponse.getGroupNumber()).liteTopology(liteTopology).availableTopology(reducedTopology).build();
    }

    private void validateInputData(String text) {
        if (this.topologyTokenLimit < this.tokenUsageService.estimateTokenCount(text)) {
            throw new AiTopologyLimitException("Topology limit exception: please reduce available topology");
        }
    }

    private List<BusinessEntity> reduceTopologyByGroupNumber(List<BusinessEntity> topology, LiteTopology liteTopology, int groupNumber) {
        Set availableUUIDs = topology.stream().map(BusinessEntity::getId).filter(entityId -> {
            int entityComponentGroup = (Integer)liteTopology.getEntityIdToComponentMap().get(entityId);
            return entityComponentGroup == groupNumber;
        }).collect(Collectors.toSet());
        Set resultEntities = liteTopology.getLiteBusinessEntities().stream().filter(entity -> {
            String entityName = entity.getName();
            UUID entityId = (UUID)liteTopology.getEntityNameToIdMap().get(entityName);
            int entityComponentGroup = (Integer)liteTopology.getEntityIdToComponentMap().get(entityId);
            return entityComponentGroup == groupNumber;
        }).collect(Collectors.toSet());
        liteTopology.setLiteBusinessEntities(resultEntities);
        return topology.stream().filter(businessEntity -> availableUUIDs.contains(businessEntity.getId())).toList();
    }
}

